/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.animation.AnimationStateHandler;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatConstantSupplier;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements HitBoxSource {
    private static final Vector3f EMPTY_VECTOR = new Vector3f();
    private static final ItemStack AIR = new ItemStack(Material.AIR);
    @NotNull
    private final RendererGroup group;
    private final BoneMovement defaultFrame;
    @NotNull
    private final RenderedBone root;
    @Nullable
    private final RenderedBone parent;
    @NotNull
    private final Map<BoneName, RenderedBone> children;
    private final AnimationStateHandler<AnimationMovement> state = new AnimationStateHandler<AnimationMovement>(AnimationMovement.EMPTY, (a, s, t) -> a.time(t), t -> {
        this.relativeOffsetCache = null;
    });
    private final Int2ObjectOpenHashMap<ItemStack> tintCacheMap = new Int2ObjectOpenHashMap();
    private final boolean dummyBone;
    private final Object itemLock = new Object();
    @Nullable
    private ModelDisplay display;
    @Nullable
    private HitBox hitBox;
    private BoneItemMapper itemMapper;
    private volatile int previousTint;
    private volatile int tint = 0xFFFFFF;
    private volatile TransformedItemStack itemStack;
    private boolean firstTick = true;
    private volatile BoneMovement beforeTransform;
    private volatile BoneMovement afterTransform;
    private volatile BoneMovement relativeOffsetCache;
    private volatile ModelRotation rotation = ModelRotation.EMPTY;
    private Supplier<Vector3f> defaultPosition = FunctionUtil.asSupplier(EMPTY_VECTOR);
    private FloatSupplier scale = FloatConstantSupplier.ONE;
    private Function<Vector3f, Vector3f> positionModifier = p -> p;
    private Vector3f lastModifiedPosition = new Vector3f();
    private Function<Quaternionf, Quaternionf> rotationModifier = r -> r;
    private Quaternionf lastModifiedRotation = new Quaternionf();

    @ApiStatus.Internal
    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull BoneMovement movement, @NotNull TrackerModifier modifier, @NotNull Function<RenderedBone, Map<BoneName, RenderedBone>> childrenMapper) {
        this.group = group;
        this.parent = parent;
        this.itemMapper = group.getItemMapper();
        this.root = parent != null ? parent.root : this;
        this.itemStack = itemStack;
        this.dummyBone = itemStack.isAir();
        if (!this.dummyBone) {
            this.display = BetterModel.plugin().nms().create(firstLocation);
            this.display.display(transform);
            this.display.viewRange(modifier.viewRange());
            this.display.invisible(this.itemMapper == BoneItemMapper.EMPTY && !group.getParent().visibility());
        }
        this.defaultFrame = movement;
        this.children = childrenMapper.apply(this);
        this.applyItem();
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        return this.state.runningAnimation();
    }

    public boolean updateItem(@NotNull Predicate<RenderedBone> predicate, @NotNull RenderSource<?> source) {
        return this.itemStack(predicate, this.itemMapper.apply(source, this.itemStack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        if (predicate.test(this)) {
            HitBox previous = this.hitBox;
            RenderedBone renderedBone = this;
            synchronized (renderedBone) {
                if (previous != this.hitBox) {
                    return false;
                }
                NamedBoundingBox h = this.group.getHitBox();
                if (h == null) {
                    h = ModelBoundingBox.MIN.named(this.group.getName());
                }
                HitBoxListener l = listener;
                if (this.hitBox != null) {
                    this.hitBox.removeHitBox();
                    if (l == null) {
                        l = this.hitBox.listener();
                    }
                }
                this.hitBox = BetterModel.plugin().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
                return this.hitBox != null;
            }
        }
        return false;
    }

    public boolean enchant(@NotNull Predicate<RenderedBone> predicate, boolean enchant) {
        return this.itemStack(predicate, this.itemStack.modify(i -> {
            ItemMeta meta = i.getItemMeta();
            if (enchant) {
                meta.addEnchant(Enchantment.UNBREAKING, 0, true);
            } else {
                meta.removeEnchant(Enchantment.UNBREAKING);
            }
            i.setItemMeta(meta);
            return i;
        }));
    }

    public void moveDuration(int duration) {
        if (this.display != null) {
            this.display.moveDuration(duration);
        }
    }

    public void scale(@NotNull FloatSupplier scale) {
        this.scale = scale;
    }

    public boolean glow(@NotNull Predicate<RenderedBone> predicate, boolean glow, int glowColor) {
        if (this.display != null && predicate.test(this)) {
            this.display.glow(glow);
            this.display.glowColor(glowColor);
            return true;
        }
        return false;
    }

    public boolean billboard(@NotNull Predicate<RenderedBone> predicate, @NotNull Display.Billboard billboard) {
        if (this.display != null && predicate.test(this)) {
            this.display.billboard(billboard);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemStack(@NotNull Predicate<RenderedBone> predicate, @NotNull TransformedItemStack itemStack) {
        if (this.itemStack != itemStack && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.itemStack == itemStack) {
                    return false;
                }
                this.itemStack = itemStack;
                if (this.display != null) {
                    this.display.invisible(itemStack.isAir());
                }
                this.tintCacheMap.clear();
                return this.applyItem();
            }
        }
        return false;
    }

    public boolean brightness(@NotNull Predicate<RenderedBone> predicate, int block, int sky) {
        if (this.display != null && predicate.test(this)) {
            this.display.brightness(block, sky);
            return true;
        }
        return false;
    }

    public synchronized boolean addRotationModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Quaternionf, Quaternionf> function) {
        if (predicate.test(this)) {
            this.rotationModifier = this.rotationModifier.andThen(function);
            return true;
        }
        return false;
    }

    public synchronized boolean addPositionModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Vector3f, Vector3f> function) {
        if (predicate.test(this)) {
            this.positionModifier = this.positionModifier.andThen(function);
            return true;
        }
        return false;
    }

    public boolean rotate(@NotNull ModelRotation rotation, @NotNull PacketBundler bundler) {
        this.rotation = rotation;
        if (this.display != null) {
            this.display.rotate(rotation, bundler);
            return true;
        }
        return false;
    }

    public boolean tick(@NotNull PacketBundler bundler) {
        if (this.state.tick() || this.firstTick) {
            this.beforeTransform = this.afterTransform;
            BoneMovement boneMovement = this.afterTransform = this.relativeOffset();
            ModelDisplay d = this.display;
            if (d != null) {
                d.frame(RenderedBone.toInterpolationDuration(this.frame()));
                this.setup(boneMovement);
                if (this.isVisible()) {
                    d.sendTransformation(bundler);
                }
            }
            this.firstTick = false;
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        if (this.display == null || this.display.invisible()) {
            return false;
        }
        return this.beforeTransform != null && this.beforeTransform.isVisible() || this.afterTransform != null && this.afterTransform.isVisible();
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(bundler);
        }
    }

    public void forceUpdate(boolean showItem, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(showItem, bundler);
        }
    }

    private static int toInterpolationDuration(float delay) {
        return (int)Math.ceil(delay / (float)Tracker.MINECRAFT_TICK_MULTIPLIER);
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset) {
        return this.worldPosition(localOffset, EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset, @NotNull Vector3f globalOffset) {
        float progress = 1.0f - this.progress();
        BoneMovement after = this.afterTransform != null ? this.afterTransform : this.relativeOffset();
        BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
        return VectorUtil.fma(VectorUtil.linear(before.transform(), after.transform(), progress).add((Vector3fc)this.itemStack.offset()).add((Vector3fc)localOffset).rotate((Quaternionfc)MathUtil.toQuaternion(VectorUtil.linear(before.rawRotation(), after.rawRotation(), progress))), VectorUtil.linear(before.scale(), after.scale(), progress), globalOffset).add((Vector3fc)this.root.getGroup().getPosition()).mul(this.scale.getAsFloat()).rotateX(-this.rotation.radianX()).rotateY(-this.rotation.radianY());
    }

    @NotNull
    public Quaternionf worldRotation() {
        float progress = 1.0f - this.progress();
        BoneMovement after = this.afterTransform != null ? this.afterTransform : this.relativeOffset();
        BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
        return new Quaternionf().rotateZYX(0.0f, -this.rotation.radianY(), -this.rotation.radianX()).mul((Quaternionfc)MathUtil.toQuaternion(VectorUtil.linear(before.rawRotation(), after.rawRotation(), progress)));
    }

    private void setup(@NotNull BoneMovement boneMovement) {
        if (this.display != null) {
            float mul = this.scale.getAsFloat();
            this.display.transform(VectorUtil.fma(this.itemStack.offset().rotate((Quaternionfc)boneMovement.rotation(), new Vector3f()).add((Vector3fc)boneMovement.transform()).add((Vector3fc)this.root.group.getPosition()), mul, this.itemStack.position()).add((Vector3fc)this.defaultPosition.get()), boneMovement.scale().mul((Vector3fc)this.itemStack.scale(), new Vector3f()).mul(mul), boneMovement.rotation());
        }
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.defaultPosition = movement;
    }

    private float frame() {
        float frame = this.state.frame();
        return frame == 0.0f && this.parent != null ? this.parent.frame() : frame;
    }

    @NotNull
    private BoneMovement defaultFrame() {
        AnimationMovement keyframe = this.state.getKeyframe();
        return this.defaultFrame.plus(keyframe != null ? keyframe : new AnimationMovement(0.0f));
    }

    private float progress() {
        float f = this.frame();
        return f == 0.0f ? 0.0f : (float)this.state.getDelay() / f;
    }

    @NotNull
    private BoneMovement relativeOffset() {
        boolean preventModifierUpdate;
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        BoneMovement def = this.defaultFrame();
        boolean bl = preventModifierUpdate = RenderedBone.toInterpolationDuration(this.frame()) < 1;
        if (this.parent != null) {
            BoneMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new BoneMovement(VectorUtil.fma(def.transform().rotate((Quaternionfc)p.rotation()), p.scale(), p.transform()).sub((Vector3fc)this.parent.lastModifiedPosition).add((Vector3fc)this.modifiedPosition(preventModifierUpdate)), def.scale().mul((Vector3fc)p.scale()), p.rotation().div((Quaternionfc)this.parent.lastModifiedRotation, new Quaternionf()).mul((Quaternionfc)def.rotation()).mul((Quaternionfc)this.modifiedRotation(preventModifierUpdate)), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = new BoneMovement(def.transform().add((Vector3fc)this.modifiedPosition(preventModifierUpdate)), def.scale(), def.rotation().mul((Quaternionfc)this.modifiedRotation(preventModifierUpdate)), def.rawRotation());
        return this.relativeOffsetCache;
    }

    @NotNull
    private Vector3f modifiedPosition(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedPosition : (this.lastModifiedPosition = this.positionModifier.apply(new Vector3f()));
    }

    @NotNull
    private Quaternionf modifiedRotation(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedRotation : (this.lastModifiedRotation = this.rotationModifier.apply(new Quaternionf()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tint(@NotNull Predicate<RenderedBone> predicate, int tint) {
        if (tint == -1) {
            tint = this.previousTint;
        }
        if (this.tint != tint && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.tint == tint) {
                    return false;
                }
                this.previousTint = this.tint;
                this.tint = tint;
                return this.applyItem();
            }
        }
        return false;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(this.itemStack.isAir() ? AIR : (ItemStack)this.tintCacheMap.computeIfAbsent(this.tint, i -> BetterModel.plugin().nms().tint(this.itemStack.itemStack(), i)));
            return true;
        }
        return false;
    }

    @NotNull
    public BoneName getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
    }

    public void spawn(boolean hide, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(!hide && !this.display.invisible(), bundler);
        }
    }

    public boolean addAnimation(@NotNull AnimationPredicate filter, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            AnimationIterator<AnimationMovement> iterator2 = get != null ? get.iterator(type) : animator.emptyIterator(type);
            this.state.addAnimation(animator.name(), iterator2, modifier, removeTask);
            return true;
        }
        return false;
    }

    public boolean replaceAnimation(@NotNull AnimationPredicate filter, @NotNull String target, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            AnimationIterator<AnimationMovement> iterator2 = get != null ? get.iterator(type) : animator.emptyIterator(type);
            this.state.replaceAnimation(target, iterator2, modifier);
            return true;
        }
        return false;
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String name) {
        if (filter.test(this)) {
            this.state.stopAnimation(name);
        }
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
    }

    public boolean togglePart(@NotNull Predicate<RenderedBone> predicate, boolean toggle) {
        if (this.display != null && predicate.test(this)) {
            this.display.invisible(!toggle);
            return true;
        }
        return false;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        return this.findNotNullByTree(b2 -> predicate.test((RenderedBone)b2) ? b2 : null);
    }

    @Nullable
    public <T> T findNotNullByTree(@NotNull Function<RenderedBone, T> mapper) {
        T value = mapper.apply(this);
        if (value != null) {
            return value;
        }
        for (RenderedBone renderedBone : this.children.values()) {
            T childValue = renderedBone.findNotNullByTree(mapper);
            if (childValue == null) continue;
            return childValue;
        }
        return null;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> boneConsumer) {
        boneConsumer.accept(this);
        for (RenderedBone value : this.children.values()) {
            value.iterateTree(boneConsumer);
        }
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> bonePredicate) {
        boolean result = bonePredicate.test(this);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(bonePredicate)) continue;
            result = true;
        }
        return result;
    }

    public boolean iterateTree(@NotNull BonePredicate predicate, @NotNull BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        BonePredicate childPredicate = predicate.children(parentResult);
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    public boolean iterateAnimation(@NotNull AnimationPredicate predicate, @NotNull BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        AnimationPredicate childPredicate = predicate;
        if (parentResult) {
            childPredicate = childPredicate.children();
        }
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateAnimation(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox box = this.getGroup().getHitBox();
        if (box != null) {
            return this.worldPosition(box.centerPoint());
        }
        return this.worldPosition();
    }

    @Override
    @NotNull
    public Quaternionf hitBoxViewRotation() {
        return this.worldRotation();
    }

    @Override
    public float hitBoxScale() {
        return this.scale.getAsFloat();
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    @NotNull
    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @NotNull
    @Generated
    public RenderedBone getRoot() {
        return this.root;
    }

    @Nullable
    @Generated
    public RenderedBone getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public Map<BoneName, RenderedBone> getChildren() {
        return this.children;
    }

    @Generated
    public boolean isDummyBone() {
        return this.dummyBone;
    }

    @Nullable
    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Nullable
    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @Generated
    public void setItemMapper(BoneItemMapper itemMapper) {
        this.itemMapper = itemMapper;
    }
}

