/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public record Datapoint(float x, float y, float z, @Nullable String script) {
    public static final Parser PARSER = new Parser();

    @NotNull
    public Vector3f toVector() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static final class Parser
    implements Function<JsonElement, Datapoint>,
    JsonDeserializer<Datapoint> {
        private Parser() {
        }

        public Datapoint deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply(json);
        }

        @Override
        public Datapoint apply(JsonElement element) {
            JsonObject array = element.getAsJsonObject();
            JsonPrimitive script = array.getAsJsonPrimitive("script");
            return new Datapoint(Parser.parse(array.getAsJsonPrimitive("x")), Parser.parse(array.getAsJsonPrimitive("y")), Parser.parse(array.getAsJsonPrimitive("z")), script != null ? script.getAsString() : null);
        }

        private static float parse(@Nullable JsonPrimitive primitive) {
            if (primitive == null) {
                return 0.0f;
            }
            try {
                float f = primitive.getAsFloat();
                return Float.isNaN(f) ? 0.0f : f;
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
    }
}

