/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.animation.AnimationStateHandler;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class RenderPipeline {
    private final ModelRenderer parent;
    private final RenderSource<?> source;
    private final Map<BoneName, RenderedBone> entityMap;
    private final List<RenderedBone> bones;
    private final int displayAmount;
    private final Map<String, BlueprintAnimation> animationMap;
    private final Map<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private final Set<UUID> hidePlayerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Predicate<Player> viewFilter = p -> true;
    private Predicate<Player> hideFilter = p -> this.hidePlayerSet.contains(p.getUniqueId());
    private Consumer<PacketBundler> spawnPacketHandler = b2 -> {};
    private Consumer<PacketBundler> despawnPacketHandler = b2 -> {};
    private Consumer<PacketBundler> hidePacketHandler = b2 -> {};
    private Consumer<PacketBundler> showPacketHandler = b2 -> {};
    private ModelRotation rotation = ModelRotation.INVALID;
    private final AnimationStateHandler<TimeScript> scriptProcessor = new AnimationStateHandler<TimeScript>(TimeScript.EMPTY, (a, s, t) -> s == AnimationStateHandler.MappingState.PROGRESS ? a.time(t) : AnimationScript.EMPTY.time(t), s -> {
        if (s == null) {
            return;
        }
        if (s.isSync()) {
            BetterModel.plugin().scheduler().task(this.getSource().location(), () -> s.accept(this.getSource()));
        } else {
            s.accept(this.getSource());
        }
    });

    public RenderPipeline(@NotNull ModelRenderer parent, @NotNull RenderSource<?> source, @NotNull Map<BoneName, RenderedBone> entityMap) {
        this.parent = parent;
        this.source = source;
        this.entityMap = entityMap;
        this.animationMap = parent.animationMap();
        ArrayList b3 = new ArrayList();
        for (RenderedBone value : entityMap.values()) {
            value.iterateTree(b3::add);
        }
        this.bones = Collections.unmodifiableList(b3);
        this.displayAmount = (int)this.bones.stream().filter(rb -> rb.getDisplay() != null).count();
        this.animate("idle", new AnimationModifier(6, 0, 1.0f));
    }

    @NotNull
    public PacketBundler createBundler() {
        return BetterModel.plugin().nms().createBundler(this.displayAmount);
    }

    public void viewFilter(@NotNull Predicate<Player> filter) {
        this.viewFilter = this.viewFilter.and(Objects.requireNonNull(filter));
    }

    public void hideFilter(@NotNull Predicate<Player> filter) {
        this.hideFilter = this.hideFilter.and(Objects.requireNonNull(filter));
    }

    public void spawnPacketHandler(@NotNull Consumer<PacketBundler> spawnPacketHandler) {
        this.spawnPacketHandler = this.spawnPacketHandler.andThen(Objects.requireNonNull(spawnPacketHandler));
    }

    public void despawnPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.despawnPacketHandler = this.despawnPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void hidePacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.hidePacketHandler = this.hidePacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void showPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.showPacketHandler = this.showPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.playerMap.containsKey(uuid);
    }

    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.createHitBox(entity, predicate, listener));
        }
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        for (RenderedBone value : this.entityMap.values()) {
            RunningAnimation get = value.findNotNullByTree(RenderedBone::runningAnimation);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    public void despawn() {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> {
                HitBox hb = b2.getHitBox();
                if (hb != null) {
                    hb.removeHitBox();
                }
            });
        }
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        if (!bundler.isEmpty()) {
            for (PlayerChannelHandler value : this.playerMap.values()) {
                bundler.send(value.player());
            }
        }
        this.playerMap.clear();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.teleport(location, bundler));
        }
    }

    public boolean rotate(@NotNull ModelRotation rotation, @NotNull PacketBundler bundler) {
        if (rotation.equals(this.rotation)) {
            return false;
        }
        ModelRotation rot = this.rotation = rotation;
        boolean match = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.matchTree(b2 -> b2.rotate(rot, bundler))) continue;
            match = true;
        }
        return match;
    }

    public boolean tick(@NotNull PacketBundler bundler) {
        boolean match = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.matchTree(b2 -> b2.tick(bundler))) continue;
            match = true;
        }
        return match;
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.defaultPosition(movement));
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.forceUpdate(bundler));
        }
    }

    public void forceUpdate(boolean showItem, @NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.forceUpdate(showItem, bundler));
        }
    }

    public void scale(@NotNull FloatSupplier scale) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.scale(scale));
        }
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.anyMatch(predicate, (b2, p) -> b2.itemStack((Predicate<RenderedBone>)p, itemStack));
    }

    public boolean updateItem(@NotNull BonePredicate predicate) {
        return this.anyMatch(predicate, (b2, p) -> b2.updateItem((Predicate<RenderedBone>)p, this.source));
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.anyMatch(predicate, (b2, p) -> b2.glow((Predicate<RenderedBone>)p, glow, glowColor));
    }

    public boolean billboard(@NotNull BonePredicate predicate, @NotNull Display.Billboard billboard) {
        return this.anyMatch(predicate, (b2, p) -> b2.billboard((Predicate<RenderedBone>)p, billboard));
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.anyMatch(predicate, (b2, p) -> b2.brightness((Predicate<RenderedBone>)p, block, sky));
    }

    public boolean addRotationModifier(@NotNull BonePredicate predicate, @NotNull Function<Quaternionf, Quaternionf> mapper) {
        return this.anyMatch(predicate, (b2, p) -> b2.addRotationModifier((Predicate<RenderedBone>)p, mapper));
    }

    public boolean addPositionModifier(@NotNull BonePredicate predicate, @NotNull Function<Vector3f, Vector3f> mapper) {
        return this.anyMatch(predicate, (b2, p) -> b2.addPositionModifier((Predicate<RenderedBone>)p, mapper));
    }

    @NotNull
    public @Unmodifiable List<RenderedBone> bones() {
        return this.bones;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        for (RenderedBone value : this.entityMap.values()) {
            RenderedBone get = value.boneOf(predicate);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    public double height() {
        double h = 0.0;
        for (RenderedBone renderer : this.bones()) {
            float lt = renderer.hitBoxPosition().y;
            if (renderer.getName().tagged(BoneTags.HEAD, BoneTags.HEAD_WITH_CHILDREN)) {
                return lt;
            }
            if (!(h < (double)lt)) continue;
            h = lt;
        }
        return h;
    }

    public boolean tint(@NotNull BonePredicate predicate, int rgb) {
        return this.anyMatch(predicate, (b2, p) -> b2.tint((Predicate<RenderedBone>)p, rgb));
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.anyMatch(predicate, (b2, p) -> b2.enchant((Predicate<RenderedBone>)p, enchant));
    }

    public void moveDuration(int duration) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.moveDuration(duration));
        }
    }

    public boolean animate(@NotNull String animation) {
        return this.animate((RenderedBone e) -> true, animation, AnimationModifier.DEFAULT, () -> {});
    }

    public boolean animate(@NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.animate((RenderedBone e) -> true, animation, modifier, () -> {});
    }

    public void animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        BlueprintScript script = animation.script();
        if (script != null) {
            this.scriptProcessor.addAnimation(animation.name(), script.iterator(), modifier, () -> {});
        }
        Runnable playOnceTask = FunctionUtil.playOnce(removeTask);
        AnimationPredicate animationPredicate = AnimationPredicate.of(filter);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateAnimation(animationPredicate, (b2, a) -> b2.addAnimation((AnimationPredicate)a, animation, modifier, playOnceTask));
        }
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.animate(filter, get, modifier, removeTask);
        return true;
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.replace(filter, target, get, modifier);
        return true;
    }

    public void replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier) {
        BlueprintScript script = animation.script();
        if (script != null) {
            this.scriptProcessor.replaceAnimation(target, script.iterator(), modifier);
        }
        AnimationPredicate animationPredicate = AnimationPredicate.of(filter);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateAnimation(animationPredicate, (b2, a) -> b2.replaceAnimation((AnimationPredicate)a, target, animation, modifier));
        }
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String target) {
        this.scriptProcessor.stopAnimation(target);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.stopAnimation(filter, target));
        }
    }

    public boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        PlayerChannelHandler get = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (get == null) {
            return false;
        }
        this.playerMap.put(player.getUniqueId(), get);
        this.spawnPacketHandler.accept(bundler);
        boolean hided = this.isHide(player);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.spawn(hided, bundler));
        }
        return true;
    }

    public boolean remove(@NotNull Player player) {
        if (this.playerMap.remove(player.getUniqueId()) == null) {
            return false;
        }
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        bundler.send(player);
        return true;
    }

    private void remove0(@NotNull PacketBundler bundler) {
        this.despawnPacketHandler.accept(bundler);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b2 -> b2.remove(bundler));
        }
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.anyMatch(predicate, (b2, p) -> b2.togglePart((Predicate<RenderedBone>)p, toggle));
    }

    private boolean anyMatch(@NotNull BonePredicate predicate, BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean result = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.iterateTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public int playerCount() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<Player> allPlayer() {
        return this.playerMap.values().stream().map(PlayerChannelHandler::player);
    }

    @NotNull
    public Stream<Player> nonHidePlayer() {
        return this.filteredPlayer(p -> !this.isHide((Player)p));
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.filteredPlayer(this.viewFilter);
    }

    @NotNull
    public Stream<Player> filteredPlayer(@NotNull Predicate<Player> predicate) {
        return this.allPlayer().filter(predicate);
    }

    public boolean hide(@NotNull Player player) {
        if (this.hidePlayerSet.add(player.getUniqueId())) {
            if (this.playerMap.containsKey(player.getUniqueId())) {
                PacketBundler bundler = this.createBundler();
                this.forceUpdate(false, bundler);
                this.hidePacketHandler.accept(bundler);
                if (!bundler.isEmpty()) {
                    bundler.send(player);
                }
            }
            BetterModel.plugin().scheduler().task((Entity)player, () -> {
                for (RenderedBone bone : this.bones) {
                    HitBox hb = bone.getHitBox();
                    if (hb == null) continue;
                    hb.hide(player);
                }
            });
            return true;
        }
        return false;
    }

    public boolean isHide(@NotNull Player player) {
        return this.hideFilter.test(player);
    }

    public boolean show(@NotNull Player player) {
        if (this.hidePlayerSet.remove(player.getUniqueId())) {
            if (this.playerMap.containsKey(player.getUniqueId())) {
                PacketBundler bundler = this.createBundler();
                this.forceUpdate(true, bundler);
                this.showPacketHandler.accept(bundler);
                if (!bundler.isEmpty()) {
                    bundler.send(player);
                }
            }
            BetterModel.plugin().scheduler().task((Entity)player, () -> {
                for (RenderedBone bone : this.bones) {
                    HitBox hb = bone.getHitBox();
                    if (hb == null) continue;
                    hb.show(player);
                }
            });
            return true;
        }
        return false;
    }

    @Generated
    public ModelRenderer getParent() {
        return this.parent;
    }

    @Generated
    public RenderSource<?> getSource() {
        return this.source;
    }

    @Generated
    public int getDisplayAmount() {
        return this.displayAmount;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    @Generated
    public AnimationStateHandler<TimeScript> getScriptProcessor() {
        return this.scriptProcessor;
    }
}

