/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.pack.PackData;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.util.FilesKt;
import kr.toxicity.model.util.ListsKt;
import kr.toxicity.model.util.PackGenerator;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\u00020\u0007*\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkr/toxicity/model/util/FolderGenerator;", "Lkr/toxicity/model/util/PackGenerator;", "<init>", "()V", "time", "", "file", "Ljava/io/File;", "fileTree", "Ljava/util/SortedMap;", "", "toFile", "Lkr/toxicity/model/api/pack/PackPath;", "create", "Lkr/toxicity/model/api/pack/PackData;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "core"})
@SourceDebugExtension(value={"SMAP\nPacks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/FolderGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1869#2,2:108\n*S KotlinDebug\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/FolderGenerator\n*L\n60#1:108,2\n*E\n"})
public final class FolderGenerator
implements PackGenerator {
    private final long time = System.currentTimeMillis();
    @NotNull
    private final File file = new File(PluginsKt.getDATA_FOLDER().getParent(), PluginsKt.getCONFIG().buildFolderLocation());
    @NotNull
    private final SortedMap<String, File> fileTree;

    /*
     * WARNING - void declaration
     */
    public FolderGenerator() {
        void $this$fileTree_u24lambda_u242;
        SortedMap sortedMap;
        Comparator comparator = Comparator.reverseOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, "reverseOrder(...)");
        SortedMap sortedMap2 = sortedMap = MapsKt.sortedMapOf(comparator, new Pair[0]);
        FolderGenerator folderGenerator = this;
        boolean bl = false;
        int l = this.file.getPath().length() + 1;
        FilesKt.forEach(this.file, arg_0 -> FolderGenerator.fileTree$lambda$2$lambda$1((SortedMap)$this$fileTree_u24lambda_u242, l, arg_0));
        folderGenerator.fileTree = sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File toFile(PackPath $this$toFile) {
        File file;
        String string = $this$toFile.path();
        Intrinsics.checkNotNullExpressionValue(string, "path(...)");
        String replaced = StringsKt.replace$default(string, '/', File.separatorChar, false, 4, null);
        SortedMap<String, File> sortedMap = this.fileTree;
        synchronized (sortedMap) {
            boolean $i$a$-synchronized-FolderGenerator$toFile$22 = false;
            File $i$a$-synchronized-FolderGenerator$toFile$22 = (File)this.fileTree.remove(replaced);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
            file = $i$a$-synchronized-FolderGenerator$toFile$22;
        }
        File file2 = file;
        if (file == null) {
            File file3;
            File $this$toFile_u24lambda_u244 = file3 = new File(this.file, replaced);
            boolean bl = false;
            $this$toFile_u24lambda_u244.getParentFile().mkdirs();
            file2 = file3;
        }
        return file2;
    }

    @Override
    @NotNull
    public PackData create(@NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter(zipper, "zipper");
        ConcurrentHashMap map = new ConcurrentHashMap();
        List<PackResource> list = zipper.build();
        Intrinsics.checkNotNullExpressionValue(list, "build(...)");
        ListsKt.forEachAsync(list, arg_0 -> FolderGenerator.create$lambda$7(map, this, arg_0));
        Collection<File> collection = this.fileTree.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File p0 = (File)element$iv;
            boolean bl = false;
            p0.delete();
        }
        return new PackData(ListsKt.toImmutableView(map), System.currentTimeMillis() - this.time);
    }

    private static final Unit fileTree$lambda$2$lambda$1$lambda$0(SortedMap $this_apply, int $l, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        String string2 = string.substring($l);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        $this_apply.put(string2, it);
        return Unit.INSTANCE;
    }

    private static final Unit fileTree$lambda$2$lambda$1(SortedMap $this_apply, int $l, File sub) {
        Intrinsics.checkNotNullParameter(sub, "sub");
        FilesKt.forEachAll(sub, arg_0 -> FolderGenerator.fileTree$lambda$2$lambda$1$lambda$0($this_apply, $l, arg_0));
        return Unit.INSTANCE;
    }

    private static final String create$lambda$7$lambda$6(PackResource $it) {
        return "This file was successfully zipped: " + $it.path();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit create$lambda$7(ConcurrentHashMap $map, FolderGenerator this$0, PackResource it) {
        byte[] bytes = (byte[])it.get();
        ((Map)$map).put(it.path(), bytes);
        PackPath packPath = it.path();
        Intrinsics.checkNotNullExpressionValue(packPath, "path(...)");
        Object object = this$0.toFile(packPath);
        object = new FileOutputStream((File)object);
        int n = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)object;
            boolean bl = false;
            output.write(bytes);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        PluginsKt.debugPack(() -> FolderGenerator.create$lambda$7$lambda$6(it));
        return Unit.INSTANCE;
    }
}

