/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintJson;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.event.ModelImportedEvent;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.pack.PackBuilder;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ModelManagerImpl;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.collections.SetsKt;
import kr.toxicity.model.shaded.kotlin.comparisons.ComparisonsKt;
import kr.toxicity.model.shaded.kotlin.enums.EnumEntries;
import kr.toxicity.model.shaded.kotlin.enums.EnumEntriesKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.io.path.PathsKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function3;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.shaded.kotlin.sequences.Sequence;
import kr.toxicity.model.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.model.util.BuffersKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.PluginsKt;
import kr.toxicity.model.util.SendersKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002)*B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\tH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\tH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0$H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl;", "Lkr/toxicity/model/api/manager/ModelManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "itemModelNamespace", "Lorg/bukkit/NamespacedKey;", "generalModelMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "generalModelView", "", "playerModelMap", "playerModelView", "modelExtensions", "", "importModels", "", "Lkr/toxicity/model/manager/ModelManagerImpl$ImportedModel;", "type", "Lkr/toxicity/model/api/data/renderer/ModelRenderer$Type;", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "dir", "Ljava/io/File;", "loadModels", "", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "start", "reload", "model", "name", "models", "", "modelKeys", "limb", "limbs", "limbKeys", "ImportedModel", "ModelPipeline", "core"})
@SourceDebugExtension(value={"SMAP\nModelManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Files.kt\nkr/toxicity/model/util/FilesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Senders.kt\nkr/toxicity/model/util/SendersKt\n+ 7 Senders.kt\nkr/toxicity/model/util/SendersKt$toComponent$1\n+ 8 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n*L\n1#1,331:1\n608#2:332\n17#3,4:333\n22#3:338\n17#3,6:339\n1#4:337\n1869#5,2:345\n30#6:347\n49#6,4:348\n30#6:356\n49#6,4:357\n30#7:352\n30#7:361\n45#8,3:353\n49#8:362\n*S KotlinDebug\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl\n*L\n81#1:332\n90#1:333,4\n90#1:338\n103#1:339,6\n313#1:345,2\n63#1:347\n63#1:348,4\n71#1:356\n71#1:357,4\n63#1:352\n71#1:361\n69#1:353,3\n69#1:362\n*E\n"})
public final class ModelManagerImpl
implements ModelManager,
GlobalManager {
    @NotNull
    public static final ModelManagerImpl INSTANCE = new ModelManagerImpl();
    private static NamespacedKey itemModelNamespace;
    @NotNull
    private static final HashMap<String, ModelRenderer> generalModelMap;
    @NotNull
    private static final Map<String, ModelRenderer> generalModelView;
    @NotNull
    private static final HashMap<String, ModelRenderer> playerModelMap;
    @NotNull
    private static final Map<String, ModelRenderer> playerModelView;
    @NotNull
    private static final Set<String> modelExtensions;

    private ModelManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<ImportedModel> importModels(ModelRenderer.Type type, ReloadPipeline pipeline, File dir) {
        void $this$sortedBy$iv;
        ReloadPipeline reloadPipeline2;
        Object stream;
        ConcurrentHashMap modelFileMap = new ConcurrentHashMap();
        Object object = kr.toxicity.model.util.FilesKt.fileTreeList(dir);
        Throwable throwable = null;
        try {
            stream = (Stream)object;
            boolean bl = false;
            stream = stream.filter(arg_0 -> ModelManagerImpl.importModels$lambda$0$1(ModelManagerImpl::importModels$lambda$0$0, arg_0)).toList();
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        object = (Collection)stream;
        if (object.isEmpty()) {
            boolean reloadPipeline2 = false;
            return CollectionsKt.emptyList();
        }
        List targetFolder = (List)object;
        String string = type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String typeName = string;
        ReloadPipeline $this$importModels_u24lambda_u242 = reloadPipeline2 = pipeline;
        boolean bl = false;
        $this$importModels_u24lambda_u242.setStatus("Importing " + typeName + " models...");
        $this$importModels_u24lambda_u242.setGoal(targetFolder.size());
        Intrinsics.checkNotNull((Object)targetFolder);
        reloadPipeline2.forEachParallel(targetFolder, importModels.2.INSTANCE, arg_0 -> ModelManagerImpl.importModels$lambda$3(modelFileMap, pipeline, typeName, arg_0));
        Collection collection = modelFileMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        reloadPipeline2 = CollectionsKt.asSequence((Iterable)collection);
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Path)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)it.getFirst()));
            }
        }), arg_0 -> ModelManagerImpl.importModels$lambda$5(type, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadModels(ReloadPipeline pipeline, PackZipper zipper) {
        AutoCloseable autoCloseable = new ModelPipeline(zipper);
        Throwable throwable = null;
        try {
            Unit unit;
            File folder2;
            ModelPipeline modelPipeline;
            Map map;
            ModelManagerImpl modelManagerImpl;
            ModelRenderer.Type type;
            ReloadPipeline reloadPipeline;
            boolean bl;
            File target$iv;
            File $this$getOrCreateDirectory$iv;
            File file;
            boolean $i$f$getOrCreateDirectory;
            String name$iv;
            ModelPipeline it = (ModelPipeline)autoCloseable;
            boolean bl2 = false;
            if (PluginsKt.getCONFIG().module().model()) {
                ModelPipeline modelPipeline2 = it;
                Map map2 = generalModelMap;
                ModelManagerImpl modelManagerImpl2 = INSTANCE;
                ModelRenderer.Type type2 = ModelRenderer.Type.GENERAL;
                ReloadPipeline reloadPipeline2 = pipeline;
                File file2 = PluginsKt.getDATA_FOLDER();
                name$iv = "models";
                $i$f$getOrCreateDirectory = false;
                target$iv = file = new File($this$getOrCreateDirectory$iv, name$iv);
                bl = false;
                if (!target$iv.exists()) {
                    File file3;
                    File file4;
                    target$iv.mkdirs();
                    File file5 = target$iv;
                    reloadPipeline = reloadPipeline2;
                    type = type2;
                    modelManagerImpl = modelManagerImpl2;
                    map = map2;
                    modelPipeline = modelPipeline2;
                    boolean bl3 = false;
                    File p0 = file4 = new File(PluginsKt.getDATA_FOLDER().getParent(), "ModelEngine/blueprints");
                    boolean bl4 = false;
                    File file6 = file3 = p0.isDirectory() ? file4 : null;
                    if (file3 != null) {
                        File $this$loadModels_u24lambda_u240_u240_u240 = file3;
                        boolean bl5 = false;
                        FilesKt.copyRecursively$default((File)$this$loadModels_u24lambda_u240_u240_u240, (File)folder2, (boolean)true, null, (int)4, null);
                        Component[] componentArray = new Component[1];
                        NamedTextColor namedTextColor = NamedTextColor.GREEN;
                        Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"GREEN");
                        componentArray[0] = SendersKt.toComponent("ModelEngine's models are successfully migrated.", (TextColor)namedTextColor);
                        PluginsKt.info(componentArray);
                    } else {
                        ModelManagerImpl $this$loadModels_u24lambda_u240_u240_u241 = INSTANCE;
                        boolean bl6 = false;
                        if (PluginsKt.getPLUGIN().version().useModernResource()) {
                            kr.toxicity.model.util.FilesKt.addResource(folder2, "demon_knight.bbmodel");
                        }
                    }
                    unit = Unit.INSTANCE;
                    modelPipeline2 = modelPipeline;
                    map2 = map;
                    modelManagerImpl2 = modelManagerImpl;
                    type2 = type;
                    reloadPipeline2 = reloadPipeline;
                }
                modelPipeline2.addModelTo(map2, modelManagerImpl2.importModels(type2, reloadPipeline2, file));
            }
            if (PluginsKt.getCONFIG().module().playerAnimation()) {
                ModelPipeline modelPipeline3 = it;
                Map map3 = playerModelMap;
                ModelManagerImpl modelManagerImpl3 = INSTANCE;
                ModelRenderer.Type type3 = ModelRenderer.Type.PLAYER;
                ReloadPipeline reloadPipeline3 = pipeline;
                $this$getOrCreateDirectory$iv = PluginsKt.getDATA_FOLDER();
                name$iv = "players";
                $i$f$getOrCreateDirectory = false;
                target$iv = file = new File($this$getOrCreateDirectory$iv, name$iv);
                bl = false;
                if (!target$iv.exists()) {
                    target$iv.mkdirs();
                    folder2 = target$iv;
                    reloadPipeline = reloadPipeline3;
                    type = type3;
                    modelManagerImpl = modelManagerImpl3;
                    map = map3;
                    modelPipeline = modelPipeline3;
                    boolean bl7 = false;
                    kr.toxicity.model.util.FilesKt.addResource(folder2, "steve.bbmodel");
                    unit = Unit.INSTANCE;
                    modelPipeline3 = modelPipeline;
                    map3 = map;
                    modelManagerImpl3 = modelManagerImpl;
                    type3 = type;
                    reloadPipeline3 = reloadPipeline;
                }
                modelPipeline3.addModelTo(map3, modelManagerImpl3.importModels(type3, reloadPipeline3, file));
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void start() {
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoneTags it = (BoneTags)element$iv;
            boolean bl = false;
            BoneTagRegistry.addTag(it);
        }
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        itemModelNamespace = new NamespacedKey(PluginsKt.getCONFIG().namespace(), PluginsKt.getCONFIG().itemNamespace());
        generalModelMap.clear();
        playerModelMap.clear();
        this.loadModels(pipeline, zipper);
    }

    @Override
    @Nullable
    public ModelRenderer model(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return generalModelView.get(name);
    }

    @Override
    @NotNull
    public Collection<ModelRenderer> models() {
        return generalModelView.values();
    }

    @Override
    @NotNull
    public Set<String> modelKeys() {
        return generalModelView.keySet();
    }

    @Override
    @Nullable
    public ModelRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return playerModelView.get(name);
    }

    @Override
    @NotNull
    public Collection<ModelRenderer> limbs() {
        return playerModelView.values();
    }

    @Override
    @NotNull
    public Set<String> limbKeys() {
        return playerModelView.keySet();
    }

    private static final boolean importModels$lambda$0$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return modelExtensions.contains(PathsKt.getExtension((Path)it));
    }

    private static final boolean importModels$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit importModels$lambda$3(ConcurrentHashMap $modelFileMap, ReloadPipeline $pipeline, String $typeName, Path it) {
        File file = it.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ModelBlueprint modelBlueprint = GsonsKt.toTexturedModel(file);
        if (modelBlueprint == null) {
            return Unit.INSTANCE;
        }
        ModelBlueprint load = modelBlueprint;
        $modelFileMap.compute(load.name(), (arg_0, arg_1) -> ModelManagerImpl.importModels$lambda$3$1((arg_0, arg_1) -> ModelManagerImpl.importModels$lambda$3$0($pipeline, $typeName, load, it, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Pair importModels$lambda$3$0(ReloadPipeline $pipeline, String $typeName, ModelBlueprint $load, Path $it, String string, Pair v) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        int index = $pipeline.progress();
        if (v != null) {
            TextComponent.Builder builder;
            Component[] componentArray = new Component[3];
            String $this$toComponent_u24default$iv = "Duplicate " + $typeName + " model name '" + $load.name() + "'.";
            boolean $i$f$toComponent = false;
            String content$iv$iv = $this$toComponent_u24default$iv;
            boolean $i$f$componentOf = false;
            boolean $i$f$componentOf2 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            boolean bl = false;
            TextComponent.Builder builder2 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"content(...)");
            TextComponent.Builder builder3 = builder2;
            int n = 0;
            Component[] componentArray2 = componentArray;
            boolean bl2 = false;
            TextComponent.Builder builder4 = builder = builder3;
            BuildableComponent buildableComponent = builder4.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            componentArray2[n] = (TextComponent)buildableComponent;
            String string2 = "Duplicated file: " + $it;
            NamedTextColor namedTextColor = NamedTextColor.RED;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"RED");
            componentArray[1] = SendersKt.toComponent(string2, (TextColor)namedTextColor);
            String string3 = "And: " + v.getFirst();
            NamedTextColor namedTextColor2 = NamedTextColor.RED;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor2, (String)"RED");
            componentArray[2] = SendersKt.toComponent(string3, (TextColor)namedTextColor2);
            PluginsKt.warn(componentArray);
            return v;
        }
        boolean $i$f$debugPack = false;
        if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
            TextComponent.Builder builder;
            Component[] componentArray = new Component[1];
            ComponentLike[] componentLikeArray = new ComponentLike[2];
            String string4 = "[" + Thread.currentThread().getName() + "] ";
            NamedTextColor namedTextColor = NamedTextColor.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"YELLOW");
            componentLikeArray[0] = SendersKt.toComponent(string4, (TextColor)namedTextColor);
            int n = 1;
            ComponentLike[] componentLikeArray2 = componentLikeArray;
            int n2 = 0;
            Component[] componentArray3 = componentArray;
            boolean bl = false;
            ComponentLike[] componentLikeArray3 = new ComponentLike[3];
            String $this$toComponent_u24default$iv = $typeName + " model file successfully loaded: ";
            boolean $i$f$toComponent = false;
            String content$iv$iv = $this$toComponent_u24default$iv;
            boolean $i$f$componentOf = false;
            boolean $i$f$componentOf3 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            boolean bl3 = false;
            TextComponent.Builder builder5 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"content(...)");
            TextComponent.Builder builder6 = builder5;
            int n3 = 0;
            ComponentLike[] componentLikeArray4 = componentLikeArray3;
            boolean bl4 = false;
            TextComponent.Builder builder7 = builder = builder6;
            BuildableComponent buildableComponent = builder7.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            componentLikeArray4[n3] = (TextComponent)buildableComponent;
            String string5 = ((Object)$it).toString();
            NamedTextColor namedTextColor3 = NamedTextColor.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor3, (String)"GREEN");
            componentLikeArray3[1] = SendersKt.toComponent(string5, (TextColor)namedTextColor3);
            String string6 = " (" + index + "/" + $pipeline.getGoal() + ")";
            NamedTextColor namedTextColor4 = NamedTextColor.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor4, (String)"DARK_GRAY");
            componentLikeArray3[2] = SendersKt.toComponent(string6, (TextColor)namedTextColor4);
            Component component = (Component)SendersKt.componentOf(componentLikeArray3);
            componentLikeArray2[n] = component;
            componentArray3[n2] = SendersKt.componentOf(componentLikeArray);
            PluginsKt.info(componentArray);
        }
        return TuplesKt.to((Object)$it, (Object)$load);
    }

    private static final Pair importModels$lambda$3$1(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final ImportedModel importModels$lambda$5(ModelRenderer.Type $type, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ImportedModel(Files.size((Path)it.getFirst()), $type, (ModelBlueprint)it.getSecond());
    }

    static {
        generalModelMap = new HashMap();
        generalModelView = kr.toxicity.model.util.CollectionsKt.toImmutableView(generalModelMap);
        playerModelMap = new HashMap();
        playerModelView = kr.toxicity.model.util.CollectionsKt.toImmutableView(playerModelMap);
        Object[] objectArray = new String[]{"bbmodel", "ajmodel"};
        modelExtensions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<BoneTags> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])BoneTags.values());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ImportedModel;", "", "size", "", "type", "Lkr/toxicity/model/api/data/renderer/ModelRenderer$Type;", "blueprint", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "<init>", "(JLkr/toxicity/model/api/data/renderer/ModelRenderer$Type;Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;)V", "getSize", "()J", "getType", "()Lkr/toxicity/model/api/data/renderer/ModelRenderer$Type;", "getBlueprint", "()Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "jsonSize", "getJsonSize", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class ImportedModel {
        private final long size;
        @NotNull
        private final ModelRenderer.Type type;
        @NotNull
        private final ModelBlueprint blueprint;
        private final long jsonSize;

        /*
         * WARNING - void declaration
         */
        public ImportedModel(long size, @NotNull ModelRenderer.Type type, @NotNull ModelBlueprint blueprint) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)blueprint, (String)"blueprint");
            this.size = size;
            this.type = type;
            this.blueprint = blueprint;
            List<BlueprintTexture> list = this.blueprint.textures();
            Intrinsics.checkNotNullExpressionValue(list, (String)"textures(...)");
            Iterable iterable = list;
            long l = this.size;
            ImportedModel importedModel = this;
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                BlueprintTexture blueprintTexture = (BlueprintTexture)t;
                n = n2;
                boolean bl = false;
                int n3 = it.image().length;
                n2 = n + n3;
            }
            n = n2;
            importedModel.jsonSize = l - (long)n;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final ModelRenderer.Type getType() {
            return this.type;
        }

        @NotNull
        public final ModelBlueprint getBlueprint() {
            return this.blueprint;
        }

        public final long getJsonSize() {
            return this.jsonSize;
        }

        public final long component1() {
            return this.size;
        }

        @NotNull
        public final ModelRenderer.Type component2() {
            return this.type;
        }

        @NotNull
        public final ModelBlueprint component3() {
            return this.blueprint;
        }

        @NotNull
        public final ImportedModel copy(long size, @NotNull ModelRenderer.Type type, @NotNull ModelBlueprint blueprint) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)blueprint, (String)"blueprint");
            return new ImportedModel(size, type, blueprint);
        }

        public static /* synthetic */ ImportedModel copy$default(ImportedModel importedModel, long l, ModelRenderer.Type type, ModelBlueprint modelBlueprint, int n, Object object) {
            if ((n & 1) != 0) {
                l = importedModel.size;
            }
            if ((n & 2) != 0) {
                type = importedModel.type;
            }
            if ((n & 4) != 0) {
                modelBlueprint = importedModel.blueprint;
            }
            return importedModel.copy(l, type, modelBlueprint);
        }

        @NotNull
        public String toString() {
            return "ImportedModel(size=" + this.size + ", type=" + this.type + ", blueprint=" + this.blueprint + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.size);
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.blueprint.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImportedModel)) {
                return false;
            }
            ImportedModel importedModel = (ImportedModel)other;
            if (this.size != importedModel.size) {
                return false;
            }
            if (this.type != importedModel.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.blueprint, (Object)importedModel.blueprint);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0012\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J*\u0010\u001e\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010\b0#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline;", "Ljava/lang/AutoCloseable;", "Lkr/toxicity/model/shaded/kotlin/AutoCloseable;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "<init>", "(Lkr/toxicity/model/api/pack/PackZipper;)V", "indexer", "", "estimatedSize", "", "textures", "Lkr/toxicity/model/api/pack/PackBuilder;", "Lorg/jetbrains/annotations/NotNull;", "legacyModel", "Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder;", "modernModel", "close", "", "addModelTo", "targetMap", "", "", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "model", "", "Lkr/toxicity/model/manager/ModelManagerImpl$ImportedModel;", "toModernJson", "Lcom/google/gson/JsonObject;", "Lkr/toxicity/model/api/data/blueprint/BlueprintJson;", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "type", "Lkr/toxicity/model/api/data/renderer/ModelRenderer$Type;", "consumer", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/data/blueprint/BlueprintElement$Group;", "ModelBuilder", "core"})
    @SourceDebugExtension(value={"SMAP\nModelManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n+ 4 Senders.kt\nkr/toxicity/model/util/SendersKt\n+ 5 Senders.kt\nkr/toxicity/model/util/SendersKt$toComponent$1\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder\n*L\n1#1,331:1\n1869#2:332\n1870#2:343\n1803#2,2:344\n1805#2:347\n808#2,11:348\n1193#2,2:359\n1267#2,4:361\n1869#2,2:365\n808#2,11:369\n1193#2,2:380\n1267#2,4:382\n45#3,3:333\n49#3:342\n30#4:336\n49#4,4:337\n30#5:341\n1#6:346\n252#7:367\n252#7:368\n*S KotlinDebug\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline\n*L\n194#1:332\n194#1:343\n268#1:344,2\n268#1:347\n305#1:348,11\n306#1:359,2\n306#1:361,4\n162#1:365,2\n297#1:369,11\n298#1:380,2\n298#1:382,4\n221#1:333,3\n221#1:342\n223#1:336\n223#1:337,4\n223#1:341\n202#1:367\n209#1:368\n*E\n"})
    private static final class ModelPipeline
    implements AutoCloseable {
        @NotNull
        private final PackZipper zipper;
        private int indexer;
        private long estimatedSize;
        @NotNull
        private final PackBuilder textures;
        @NotNull
        private final ModelBuilder legacyModel;
        @NotNull
        private final ModelBuilder modernModel;

        public ModelPipeline(@NotNull PackZipper zipper) {
            Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
            this.zipper = zipper;
            this.indexer = 1;
            PackBuilder packBuilder = this.zipper.assets().bettermodel().textures();
            Intrinsics.checkNotNullExpressionValue((Object)packBuilder, (String)"textures(...)");
            this.textures = packBuilder;
            String[] stringArray = new String[]{"item"};
            PackBuilder packBuilder2 = this.zipper.legacy().bettermodel().models().resolve(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)packBuilder2, (String)"resolve(...)");
            this.legacyModel = new ModelBuilder(packBuilder2, PluginsKt.getCONFIG().pack().generateLegacyModel(), (Function3<? super ModelBuilder, ? super List<BlueprintJson>, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ModelPipeline.legacyModel$lambda$0(this, arg_0, arg_1, arg_2)), (Function1<? super ModelBuilder, Unit>)((Function1)arg_0 -> ModelPipeline.legacyModel$lambda$1(this, arg_0)));
            stringArray = new String[]{"modern_item"};
            PackBuilder packBuilder3 = this.zipper.modern().bettermodel().models().resolve(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)packBuilder3, (String)"resolve(...)");
            this.modernModel = new ModelBuilder(packBuilder3, PluginsKt.getCONFIG().pack().generateModernModel(), (Function3<? super ModelBuilder, ? super List<BlueprintJson>, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ModelPipeline.modernModel$lambda$0(this, arg_0, arg_1, arg_2)), (Function1<? super ModelBuilder, Unit>)((Function1)arg_0 -> ModelPipeline.modernModel$lambda$1(this, arg_0)));
        }

        @Override
        public void close() {
            this.modernModel.close();
            this.legacyModel.close();
        }

        public final void addModelTo(@NotNull Map<String, ModelRenderer> targetMap, @NotNull List<ImportedModel> model2) {
            Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            if (model2.isEmpty()) {
                return;
            }
            Iterable $this$forEach$iv = model2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModelRenderer modelRenderer;
                ImportedModel importedModel = (ImportedModel)element$iv;
                boolean bl = false;
                long size = importedModel.getJsonSize();
                ModelBlueprint load = importedModel.getBlueprint();
                boolean hasTexture = load.hasTexture();
                Map<String, ModelRenderer> map = targetMap;
                String string = load.name();
                ModelRenderer $this$addModelTo_u24lambda_u240_u241 = modelRenderer = this.toRenderer(load, importedModel.getType(), (Function1<? super BlueprintElement.Group, Integer>)((Function1)arg_0 -> ModelPipeline.addModelTo$lambda$0$0(hasTexture, this, load, size, arg_0)));
                boolean bl2 = false;
                boolean $i$f$debugPack = false;
                if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
                    TextComponent.Builder builder;
                    TextComponent.Builder builder2;
                    Component[] componentArray = new Component[1];
                    ComponentLike[] componentLikeArray = new ComponentLike[2];
                    String string2 = "[" + Thread.currentThread().getName() + "] ";
                    NamedTextColor namedTextColor = NamedTextColor.YELLOW;
                    Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"YELLOW");
                    componentLikeArray[0] = SendersKt.toComponent(string2, (TextColor)namedTextColor);
                    int n = 1;
                    ComponentLike[] componentLikeArray2 = componentLikeArray;
                    int n2 = 0;
                    Component[] componentArray2 = componentArray;
                    boolean bl3 = false;
                    ComponentLike[] componentLikeArray3 = new ComponentLike[2];
                    String $this$toComponent_u24default$iv = "This model was successfully imported: ";
                    boolean $i$f$toComponent = false;
                    String content$iv$iv = $this$toComponent_u24default$iv;
                    boolean $i$f$componentOf = false;
                    boolean $i$f$componentOf2 = false;
                    TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv), (String)"content(...)");
                    int n3 = 0;
                    ComponentLike[] componentLikeArray4 = componentLikeArray3;
                    boolean bl5 = false;
                    TextComponent.Builder builder3 = builder2 = builder;
                    BuildableComponent buildableComponent = builder3.build();
                    Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
                    componentLikeArray4[n3] = (TextComponent)buildableComponent;
                    String string3 = load.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
                    NamedTextColor namedTextColor2 = NamedTextColor.GREEN;
                    Intrinsics.checkNotNullExpressionValue((Object)namedTextColor2, (String)"GREEN");
                    componentLikeArray3[1] = SendersKt.toComponent(string3, (TextColor)namedTextColor2);
                    Component component = (Component)SendersKt.componentOf(componentLikeArray3);
                    componentLikeArray2[n] = component;
                    componentArray2[n2] = SendersKt.componentOf(componentLikeArray);
                    PluginsKt.info(componentArray);
                }
                EventsKt.call(new ModelImportedEvent(load, $this$addModelTo_u24lambda_u240_u241));
                map.put(string, modelRenderer);
                if (hasTexture) {
                    load.buildImage(this.textures.obfuscator()).forEach(arg_0 -> ModelPipeline.addModelTo$lambda$0$3(arg_0 -> ModelPipeline.addModelTo$lambda$0$2(this, arg_0), arg_0));
                }
                this.estimatedSize += size;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final JsonObject toModernJson(List<BlueprintJson> $this$toModernJson) {
            JsonObject jsonObject;
            if ($this$toModernJson.size() == 1) {
                jsonObject = this.toModernJson((BlueprintJson)CollectionsKt.first($this$toModernJson));
            } else {
                void $this$fold$iv;
                void initial$iv;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"type", (Object)"minecraft:composite");
                Iterable iterable = $this$toModernJson;
                JsonArray jsonArray = new JsonArray($this$toModernJson.size());
                String string = "models";
                int n = 1;
                Pair[] pairArray2 = pairArray;
                boolean $i$f$fold = false;
                void accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void element;
                    void var12_15;
                    BlueprintJson blueprintJson = (BlueprintJson)element$iv;
                    void array = accumulator$iv;
                    boolean bl = false;
                    void $this$toModernJson_u24lambda_u240_u240 = var12_15 = array;
                    boolean bl2 = false;
                    $this$toModernJson_u24lambda_u240_u240.add((JsonElement)this.toModernJson((BlueprintJson)element));
                    accumulator$iv = var12_15;
                }
                void var18_18 = accumulator$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)var18_18);
                jsonObject = GsonsKt.jsonObjectOf(pairArray);
            }
            return jsonObject;
        }

        private final JsonObject toModernJson(BlueprintJson $this$toModernJson) {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"type", (Object)"minecraft:model");
            pairArray[1] = TuplesKt.to((Object)"model", (Object)(PluginsKt.getCONFIG().namespace() + ":modern_item/" + $this$toModernJson.name()));
            Object[] objectArray = new Object[1];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:custom_model_data"), TuplesKt.to((Object)"default", (Object)0xFFFFFF)};
            objectArray[0] = GsonsKt.jsonObjectOf(pairArray2);
            pairArray[2] = TuplesKt.to((Object)"tints", (Object)GsonsKt.jsonArrayOf(objectArray));
            return GsonsKt.jsonObjectOf(pairArray);
        }

        /*
         * WARNING - void declaration
         */
        private final ModelRenderer toRenderer(ModelBlueprint $this$toRenderer, ModelRenderer.Type type, Function1<? super BlueprintElement.Group, Integer> consumer) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            String string = $this$toRenderer.name();
            List<BlueprintElement> list = $this$toRenderer.group();
            Intrinsics.checkNotNullExpressionValue(list, (String)"group(...)");
            Iterable iterable = list;
            ModelRenderer.Type type2 = type;
            String string2 = string;
            boolean $i$f$filterIsInstance = false;
            void var6_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof BlueprintElement.Bone)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object = (List)destination$iv$iv;
            $this$filterIsInstance$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                BlueprintElement.Bone it = (BlueprintElement.Bone)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.name(), (Object)ModelPipeline.toRenderer$parse(it, consumer));
                map.put(pair.getFirst(), pair.getSecond());
            }
            object = destination$iv$iv2;
            Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
            Object object2 = object;
            ModelRenderer.Type type3 = type2;
            String string3 = string2;
            return new ModelRenderer(string3, type3, (Map<BoneName, RendererGroup>)object2, map);
        }

        private static final Unit legacyModel$lambda$0(ModelPipeline this$0, ModelBuilder $this$ModelBuilder, List blueprints, long size) {
            Intrinsics.checkNotNullParameter((Object)$this$ModelBuilder, (String)"$this$ModelBuilder");
            Intrinsics.checkNotNullParameter((Object)blueprints, (String)"blueprints");
            BlueprintJson blueprint = (BlueprintJson)CollectionsKt.first((List)blueprints);
            Pair[] pairArray = new Pair[2];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"custom_model_data", (Object)this$0.indexer)};
            pairArray[0] = TuplesKt.to((Object)"predicate", (Object)GsonsKt.jsonObjectOf(pairArray2));
            pairArray[1] = TuplesKt.to((Object)"model", (Object)(PluginsKt.getCONFIG().namespace() + ":item/" + blueprint.name()));
            GsonsKt.plusAssign($this$ModelBuilder.getEntries(), (JsonElement)GsonsKt.jsonObjectOf(pairArray));
            $this$ModelBuilder.getPack().add(blueprint.name() + ".json", size, () -> ModelPipeline.legacyModel$lambda$0$0(blueprint));
            return Unit.INSTANCE;
        }

        private static final byte[] legacyModel$lambda$0$0(BlueprintJson $blueprint) {
            JsonElement jsonElement = $blueprint.element();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"element(...)");
            return BuffersKt.toByteArray(jsonElement);
        }

        private static final Unit legacyModel$lambda$1(ModelPipeline this$0, ModelBuilder $this$ModelBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$ModelBuilder, (String)"$this$ModelBuilder");
            String string = PluginsKt.getCONFIG().item().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String itemName = string;
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"parent", (Object)"minecraft:item/generated");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"layer0", (Object)("minecraft:item/" + itemName))};
            pairArray[1] = TuplesKt.to((Object)"textures", (Object)GsonsKt.jsonObjectOf(pairArray2));
            pairArray[2] = TuplesKt.to((Object)"overrides", (Object)$this$ModelBuilder.getEntries());
            JsonObject $this$legacyModel_u24lambda_u241_u240 = GsonsKt.jsonObjectOf(pairArray);
            boolean bl = false;
            $this$ModelBuilder.getPack().add(PluginsKt.getCONFIG().itemNamespace() + ".json", this$0.estimatedSize, () -> ModelPipeline.legacyModel$lambda$1$0$0($this$legacyModel_u24lambda_u241_u240));
            String[] stringArray = new String[]{"item"};
            this$0.zipper.legacy().minecraft().models().resolve(stringArray).add(itemName + ".json", this$0.estimatedSize, () -> ModelPipeline.legacyModel$lambda$1$0$1($this$legacyModel_u24lambda_u241_u240));
            return Unit.INSTANCE;
        }

        private static final byte[] legacyModel$lambda$1$0$0(JsonObject $this_run) {
            return BuffersKt.toByteArray((JsonElement)$this_run);
        }

        private static final byte[] legacyModel$lambda$1$0$1(JsonObject $this_run) {
            return BuffersKt.toByteArray((JsonElement)$this_run);
        }

        private static final Unit modernModel$lambda$0(ModelPipeline this$0, ModelBuilder $this$ModelBuilder, List blueprints, long size) {
            Intrinsics.checkNotNullParameter((Object)$this$ModelBuilder, (String)"$this$ModelBuilder");
            Intrinsics.checkNotNullParameter((Object)blueprints, (String)"blueprints");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"threshold", (Object)this$0.indexer), TuplesKt.to((Object)"model", (Object)this$0.toModernJson(blueprints))};
            GsonsKt.plusAssign($this$ModelBuilder.getEntries(), (JsonElement)GsonsKt.jsonObjectOf(pairArray));
            Iterable $this$forEach$iv = blueprints;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlueprintJson json = (BlueprintJson)element$iv;
                boolean bl = false;
                $this$ModelBuilder.getPack().add(json.name() + ".json", size / (long)blueprints.size(), () -> ModelPipeline.modernModel$lambda$0$0$0(json));
            }
            return Unit.INSTANCE;
        }

        private static final byte[] modernModel$lambda$0$0$0(BlueprintJson $json) {
            JsonElement jsonElement = $json.element();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"element(...)");
            return BuffersKt.toByteArray(jsonElement);
        }

        private static final Unit modernModel$lambda$1(ModelPipeline this$0, ModelBuilder $this$ModelBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$ModelBuilder, (String)"$this$ModelBuilder");
            Pair[] pairArray = new Pair[1];
            Pair[] pairArray2 = new Pair[4];
            pairArray2[0] = TuplesKt.to((Object)"type", (Object)"range_dispatch");
            pairArray2[1] = TuplesKt.to((Object)"property", (Object)"custom_model_data");
            Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:empty")};
            pairArray2[2] = TuplesKt.to((Object)"fallback", (Object)GsonsKt.jsonObjectOf(pairArray3));
            pairArray2[3] = TuplesKt.to((Object)"entries", (Object)$this$ModelBuilder.getEntries());
            pairArray[0] = TuplesKt.to((Object)"model", (Object)GsonsKt.jsonObjectOf(pairArray2));
            JsonObject $this$modernModel_u24lambda_u241_u240 = GsonsKt.jsonObjectOf(pairArray);
            boolean bl = false;
            this$0.zipper.modern().bettermodel().items().add(PluginsKt.getCONFIG().itemNamespace() + ".json", this$0.estimatedSize, () -> ModelPipeline.modernModel$lambda$1$0$0($this$modernModel_u24lambda_u241_u240));
            return Unit.INSTANCE;
        }

        private static final byte[] modernModel$lambda$1$0$0(JsonObject $this_run) {
            return BuffersKt.toByteArray((JsonElement)$this_run);
        }

        private static final Integer addModelTo$lambda$0$0(boolean $hasTexture, ModelPipeline this$0, ModelBlueprint $load, long $size, BlueprintElement.Group group) {
            Integer n;
            List<BlueprintJson> list;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            if (!$hasTexture) {
                return null;
            }
            boolean success = false;
            ModelBuilder this_$iv = this$0.modernModel;
            boolean $i$f$ifAvailable = false;
            if (this_$iv.available) {
                ModelBuilder $this$addModelTo_u24lambda_u240_u240_u240 = this_$iv;
                boolean bl = false;
                v0 = group.buildModernJson(this$0.textures.obfuscator().withModels($this$addModelTo_u24lambda_u240_u240_u240.getPack().obfuscator()), $load);
            } else {
                v0 = list = null;
            }
            if (list != null) {
                List<BlueprintJson> it = list;
                boolean bl = false;
                this$0.modernModel.build(it, $size);
                success = true;
            }
            this_$iv = this$0.legacyModel;
            $i$f$ifAvailable = false;
            if (this_$iv.available) {
                ModelBuilder $this$addModelTo_u24lambda_u240_u240_u242 = this_$iv;
                boolean bl = false;
                v1 = group.buildLegacyJson(PluginsKt.getPLUGIN().version().useModernResource(), this$0.textures.obfuscator().withModels($this$addModelTo_u24lambda_u240_u240_u242.getPack().obfuscator()), $load);
            } else {
                v1 = list = null;
            }
            if (list != null) {
                List<BlueprintJson> it = list;
                boolean bl = false;
                this$0.legacyModel.build(CollectionsKt.listOf(it), $size);
                success = true;
            }
            if (success) {
                int n2 = this$0.indexer;
                this$0.indexer = n2 + 1;
                n = n2;
            } else {
                n = null;
            }
            return n;
        }

        private static final Unit addModelTo$lambda$0$2(ModelPipeline this$0, BlueprintImage image) {
            block0: {
                this$0.textures.add(image.name() + ".png", image.estimatedSize(), () -> ModelPipeline.addModelTo$lambda$0$2$0(image));
                JsonObject jsonObject = image.mcmeta();
                if (jsonObject == null) break block0;
                JsonObject meta = jsonObject;
                boolean bl = false;
                this$0.textures.add(image.name() + ".png.mcmeta", -1L, () -> ModelPipeline.addModelTo$lambda$0$2$1$0(meta));
            }
            return Unit.INSTANCE;
        }

        private static final byte[] addModelTo$lambda$0$2$0(BlueprintImage $image) {
            Intrinsics.checkNotNull((Object)$image);
            return BuffersKt.toByteArray($image);
        }

        private static final byte[] addModelTo$lambda$0$2$1$0(JsonObject $meta) {
            return BuffersKt.toByteArray((JsonElement)$meta);
        }

        private static final void addModelTo$lambda$0$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        /*
         * WARNING - void declaration
         */
        private static final RendererGroup toRenderer$parse(BlueprintElement.Bone $this$toRenderer_u24parse, Function1<? super BlueprintElement.Group, Integer> $consumer) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            ItemStack itemStack;
            ItemStack itemStack2;
            Object object;
            float f;
            ItemStack itemStack3;
            if (!($this$toRenderer_u24parse instanceof BlueprintElement.Group)) {
                return new RendererGroup(1.0f, null, $this$toRenderer_u24parse, MapsKt.emptyMap(), null);
            }
            float f2 = ((BlueprintElement.Group)$this$toRenderer_u24parse).scale();
            if (((BlueprintElement.Group)$this$toRenderer_u24parse).name().toItemMapper() != BoneItemMapper.EMPTY) {
                itemStack3 = null;
            } else {
                Integer n = (Integer)$consumer.invoke((Object)$this$toRenderer_u24parse);
                if (n != null) {
                    void i2;
                    void $this$toRenderer_u24parse_u24lambda_u240_u240_u240;
                    int n2 = ((Number)n).intValue();
                    f = f2;
                    boolean bl = false;
                    ItemStack itemStack4 = new ItemStack(PluginsKt.getCONFIG().item());
                    ItemStack $this$toRenderer_u24parse_u24lambda_u240_u240 = itemStack4;
                    boolean bl2 = false;
                    ItemMeta itemMeta = $this$toRenderer_u24parse_u24lambda_u240_u240.getItemMeta();
                    object = itemMeta;
                    itemStack2 = $this$toRenderer_u24parse_u24lambda_u240_u240;
                    boolean bl3 = false;
                    $this$toRenderer_u24parse_u24lambda_u240_u240_u240.setCustomModelData(Integer.valueOf((int)i2));
                    if (PluginsKt.getPLUGIN().version().useItemModelName()) {
                        NamespacedKey namespacedKey = itemModelNamespace;
                        if (namespacedKey == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"itemModelNamespace");
                            namespacedKey = null;
                        }
                        $this$toRenderer_u24parse_u24lambda_u240_u240_u240.setItemModel(namespacedKey);
                    }
                    itemStack2.setItemMeta(itemMeta);
                    itemStack = itemStack4;
                    f2 = f;
                    itemStack3 = itemStack;
                } else {
                    itemStack3 = null;
                }
            }
            List<BlueprintElement> list = ((BlueprintElement.Group)$this$toRenderer_u24parse).children();
            Intrinsics.checkNotNullExpressionValue(list, (String)"children(...)");
            Iterable iterable = list;
            BlueprintElement.Bone bone = $this$toRenderer_u24parse;
            itemStack = itemStack3;
            f = f2;
            boolean $i$f$filterIsInstance = false;
            void i2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof BlueprintElement.Bone)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object2 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = (Iterable)object2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object = destination$iv$iv2;
                BlueprintElement.Bone it = (BlueprintElement.Bone)element$iv$iv;
                boolean bl = false;
                itemStack2 = TuplesKt.to((Object)it.name(), (Object)ModelPipeline.toRenderer$parse(it, $consumer));
                object.put(itemStack2.getFirst(), itemStack2.getSecond());
            }
            object2 = destination$iv$iv2;
            NamedBoundingBox namedBoundingBox = ((BlueprintElement.Group)$this$toRenderer_u24parse).hitBox();
            Object object3 = object2;
            BlueprintElement.Bone bone2 = bone;
            ItemStack itemStack5 = itemStack;
            float f3 = f;
            return new RendererGroup(f3, itemStack5, bone2, (Map<BoneName, RendererGroup>)object3, namedBoundingBox);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u0002B[\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012)\u0010\u0007\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\r\u0012\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J2\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00190\u000f\u00a2\u0006\u0002\b\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001e\u001a\u00020\u000bJ\b\u0010\u001f\u001a\u00020\fH\u0016J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c2\u0003J,\u0010\"\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rH\u00c2\u0003J\u001a\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\u0002\b\rH\u00c2\u0003Je\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062+\b\u0002\u0010\u0007\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\r2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\u0002\b\rH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u0007\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Lkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder;", "Ljava/lang/AutoCloseable;", "Lkr/toxicity/model/shaded/kotlin/AutoCloseable;", "pack", "Lkr/toxicity/model/api/pack/PackBuilder;", "available", "", "onBuild", "Lkr/toxicity/model/shaded/kotlin/Function3;", "", "Lkr/toxicity/model/api/data/blueprint/BlueprintJson;", "", "", "Lkr/toxicity/model/shaded/kotlin/ExtensionFunctionType;", "onClose", "Lkr/toxicity/model/shaded/kotlin/Function1;", "<init>", "(Lkr/toxicity/model/api/pack/PackBuilder;ZLkr/toxicity/model/shaded/kotlin/jvm/functions/Function3;Lkr/toxicity/model/shaded/kotlin/jvm/functions/Function1;)V", "getPack", "()Lkr/toxicity/model/api/pack/PackBuilder;", "entries", "Lcom/google/gson/JsonArray;", "getEntries", "()Lcom/google/gson/JsonArray;", "ifAvailable", "T", "block", "(Lkr/toxicity/model/shaded/kotlin/jvm/functions/Function1;)Ljava/lang/Object;", "build", "list", "size", "close", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "core"})
        @SourceDebugExtension(value={"SMAP\nModelManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder\n*L\n1#1,331:1\n252#1:332\n*S KotlinDebug\n*F\n+ 1 ModelManagerImpl.kt\nkr/toxicity/model/manager/ModelManagerImpl$ModelPipeline$ModelBuilder\n*L\n260#1:332\n*E\n"})
        public static final class ModelBuilder
        implements AutoCloseable {
            @NotNull
            private final PackBuilder pack;
            private final boolean available;
            @NotNull
            private final Function3<ModelBuilder, List<BlueprintJson>, Long, Unit> onBuild;
            @NotNull
            private final Function1<ModelBuilder, Unit> onClose;
            @NotNull
            private final JsonArray entries;

            public ModelBuilder(@NotNull PackBuilder pack, boolean available, @NotNull Function3<? super ModelBuilder, ? super List<BlueprintJson>, ? super Long, Unit> onBuild, @NotNull Function1<? super ModelBuilder, Unit> onClose) {
                Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
                Intrinsics.checkNotNullParameter(onBuild, (String)"onBuild");
                Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
                this.pack = pack;
                this.available = available;
                this.onBuild = onBuild;
                this.onClose = onClose;
                this.entries = GsonsKt.jsonArrayOf(new Object[0]);
            }

            @NotNull
            public final PackBuilder getPack() {
                return this.pack;
            }

            @NotNull
            public final JsonArray getEntries() {
                return this.entries;
            }

            @Nullable
            public final <T> T ifAvailable(@NotNull Function1<? super ModelBuilder, ? extends T> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                boolean $i$f$ifAvailable = false;
                return (T)(this.available ? block.invoke((Object)this) : null);
            }

            public final void build(@NotNull List<BlueprintJson> list, long size) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                this.onBuild.invoke((Object)this, list, (Object)size);
            }

            @Override
            public void close() {
                ModelBuilder this_$iv = this;
                boolean $i$f$ifAvailable = false;
                if (this_$iv.available) {
                    ModelBuilder $this$close_u24lambda_u240 = this_$iv;
                    boolean bl = false;
                    if (!$this$close_u24lambda_u240.entries.isEmpty()) {
                        $this$close_u24lambda_u240.onClose.invoke((Object)$this$close_u24lambda_u240);
                    }
                }
            }

            @NotNull
            public final PackBuilder component1() {
                return this.pack;
            }

            private final boolean component2() {
                return this.available;
            }

            private final Function3<ModelBuilder, List<BlueprintJson>, Long, Unit> component3() {
                return this.onBuild;
            }

            private final Function1<ModelBuilder, Unit> component4() {
                return this.onClose;
            }

            @NotNull
            public final ModelBuilder copy(@NotNull PackBuilder pack, boolean available, @NotNull Function3<? super ModelBuilder, ? super List<BlueprintJson>, ? super Long, Unit> onBuild, @NotNull Function1<? super ModelBuilder, Unit> onClose) {
                Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
                Intrinsics.checkNotNullParameter(onBuild, (String)"onBuild");
                Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
                return new ModelBuilder(pack, available, onBuild, onClose);
            }

            public static /* synthetic */ ModelBuilder copy$default(ModelBuilder modelBuilder, PackBuilder packBuilder, boolean bl, Function3 function3, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    packBuilder = modelBuilder.pack;
                }
                if ((n & 2) != 0) {
                    bl = modelBuilder.available;
                }
                if ((n & 4) != 0) {
                    function3 = modelBuilder.onBuild;
                }
                if ((n & 8) != 0) {
                    function1 = modelBuilder.onClose;
                }
                return modelBuilder.copy(packBuilder, bl, function3, function1);
            }

            @NotNull
            public String toString() {
                return "ModelBuilder(pack=" + this.pack + ", available=" + this.available + ", onBuild=" + this.onBuild + ", onClose=" + this.onClose + ")";
            }

            public int hashCode() {
                int result = this.pack.hashCode();
                result = result * 31 + Boolean.hashCode(this.available);
                result = result * 31 + this.onBuild.hashCode();
                result = result * 31 + this.onClose.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ModelBuilder)) {
                    return false;
                }
                ModelBuilder modelBuilder = (ModelBuilder)other;
                if (!Intrinsics.areEqual((Object)this.pack, (Object)modelBuilder.pack)) {
                    return false;
                }
                if (this.available != modelBuilder.available) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.onBuild, modelBuilder.onBuild)) {
                    return false;
                }
                return Intrinsics.areEqual(this.onClose, modelBuilder.onClose);
            }
        }
    }
}

