/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolation;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class AnimationInterpolator {
    private final Map<BoneName, List<AnimationPoint>> pointMap;
    private final List<AnimationTree> trees;
    private float firstTime = 0.0f;
    private float secondTime = 0.0f;

    @NotNull
    public static FloatSet interpolate(@NotNull Map<BoneName, List<AnimationPoint>> pointMap, @NotNull List<BlueprintChildren> children) {
        FloatAVLTreeSet floatSet = CollectionUtil.mapFloat(pointMap.values().stream().flatMap(Collection::stream), p -> p.position().time(), FloatAVLTreeSet::new);
        new AnimationInterpolator(pointMap, children).interpolateRotation((FloatSet)floatSet);
        InterpolationUtil.insertLerpFrame((FloatCollection)floatSet);
        return floatSet;
    }

    private AnimationInterpolator(@NotNull Map<BoneName, List<AnimationPoint>> pointMap, @NotNull List<BlueprintChildren> children) {
        this.pointMap = pointMap;
        this.trees = CollectionUtil.filterIsInstance(children, BlueprintChildren.BlueprintGroup.class).map(g -> {
            List<AnimationPoint> get = (List<AnimationPoint>)pointMap.get(g.name());
            return new AnimationTree((BlueprintChildren.BlueprintGroup)g, get != null ? get : Collections.emptyList());
        }).flatMap(AnimationTree::flatten).toList();
    }

    public void interpolateRotation(@NotNull FloatSet floats) {
        FloatBidirectionalIterator floatBidirectionalIterator = new FloatAVLTreeSet((FloatCollection)floats).iterator();
        while (floatBidirectionalIterator.hasNext()) {
            double max;
            double minus2;
            float length;
            float v = ((Float)floatBidirectionalIterator.next()).floatValue();
            this.firstTime = this.secondTime;
            this.secondTime = v;
            if (this.secondTime - this.firstTime <= 0.0f || (length = (float)Math.ceil(Math.max((minus2 = this.trees.stream().mapToDouble(t -> t.addTree(this.firstTime, this.secondTime, AnimationPoint::rotation)).max().orElse(0.0)) / 120.0, (max = this.trees.stream().mapToDouble(t -> t.maxTree(this.firstTime, this.secondTime, AnimationPoint::rotation)).max().orElse(0.0)) / 90.0))) < 2.0f) continue;
            float last = this.firstTime;
            for (float f = 1.0f; f < length; f += 1.0f) {
                float addTime = InterpolationUtil.roundTime(InterpolationUtil.lerp(this.firstTime, this.secondTime, f / length));
                if ((double)(addTime - last) < 0.05 || (double)(this.secondTime - addTime) < 0.05) continue;
                last = addTime;
                floats.add(last);
            }
        }
    }

    private static float max(@NotNull Vector3f vector3f) {
        return Math.max(Math.abs(vector3f.x), Math.max(Math.abs(vector3f.y), Math.abs(vector3f.z)));
    }

    private class AnimationTree {
        private final AnimationTree parent;
        private final List<AnimationTree> children;
        private final List<AnimationPoint> points;

        AnimationTree(@NotNull BlueprintChildren.BlueprintGroup group, List<AnimationPoint> points) {
            this(null, group, points);
        }

        AnimationTree(@NotNull AnimationTree parent, @NotNull BlueprintChildren.BlueprintGroup group, List<AnimationPoint> points) {
            this.parent = parent;
            this.points = points;
            this.children = CollectionUtil.filterIsInstance(group.children(), BlueprintChildren.BlueprintGroup.class).map(g -> {
                List<AnimationPoint> get = AnimationInterpolator.this.pointMap.get(g.name());
                return new AnimationTree(this, (BlueprintChildren.BlueprintGroup)g, get != null ? get : Collections.emptyList());
            }).toList();
        }

        @NotNull
        Stream<AnimationTree> flatten() {
            return this.children.isEmpty() ? Stream.of(this) : this.children.stream().flatMap(AnimationTree::flatten);
        }

        private float addTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            return AnimationInterpolator.max(this.findTree(first, second, mapper));
        }

        private float maxTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            float get = AnimationInterpolator.max(this.find(first, second, mapper));
            return this.parent != null ? Math.max(this.parent.maxTree(first, second, mapper), get) : get;
        }

        @NotNull
        private Vector3f findTree(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            Vector3f get = this.find(first, second, mapper);
            return this.parent != null ? this.parent.findTree(first, second, mapper).add((Vector3fc)get) : get;
        }

        @NotNull
        private Vector3f find(float first, float second, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            return this.find(second, mapper).sub((Vector3fc)this.find(first, mapper));
        }

        @NotNull
        private Vector3f find(float time, @NotNull Function<AnimationPoint, VectorPoint> mapper) {
            if (this.points.isEmpty()) {
                return new Vector3f();
            }
            if (this.points.size() == 1) {
                return new Vector3f();
            }
            int i = 0;
            for (AnimationPoint point : this.points) {
                if (mapper.apply(point).time() >= time) break;
                ++i;
            }
            if (i == 0) {
                return new Vector3f();
            }
            if (i == this.points.size()) {
                return new Vector3f();
            }
            VectorPoint first = mapper.apply(this.points.get(i - 1));
            VectorPoint second = mapper.apply(this.points.get(i));
            return second.time() == time ? second.vector().get(new Vector3f()) : InterpolationUtil.lerp(first.vector(), second.vector(), InterpolationUtil.alpha(first.time(), second.time(), time));
        }
    }
}

