/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.util.function.FloatFunction;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record VectorPoint(@NotNull FloatFunction<Vector3f> function, float time, @NotNull VectorInterpolator interpolator) implements Timed
{
    public static final VectorPoint EMPTY = new VectorPoint(FloatFunction.of(new Vector3f()), 0.0f, VectorInterpolator.defaultInterpolator());

    @NotNull
    public Vector3f vector(float time) {
        return this.function.apply(time);
    }

    @NotNull
    public Vector3f vector() {
        return this.vector(this.time);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VectorPoint)) {
            return false;
        }
        VectorPoint that = (VectorPoint)o;
        return Float.compare(this.time, that.time) == 0;
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.time);
    }
}

