/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.manager.SkinManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\b*\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkr/toxicity/model/manager/PlayerManagerImpl;", "Lkr/toxicity/model/api/manager/PlayerManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/model/api/nms/PlayerChannelHandler;", "start", "", "register", "Lorg/bukkit/entity/Player;", "reload", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "player", "uuid", "core"})
public final class PlayerManagerImpl
implements PlayerManager,
GlobalManager {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap();

    private PlayerManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void join(PlayerJoinEvent $this$join) {
                block3: {
                    Object $this$join_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)$this$join, (String)"<this>");
                    if (!$this$join.getPlayer().isOnline()) break block3;
                    PlayerJoinEvent playerJoinEvent = $this$join;
                    try {
                        $this$join_u24lambda_u240 = playerJoinEvent;
                        boolean bl = false;
                        Player player = $this$join_u24lambda_u240.getPlayer();
                        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                        $this$join_u24lambda_u240 = Result.constructor-impl((Object)PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player));
                    }
                    catch (Throwable throwable) {
                        $this$join_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Object $this$handleFailure$iv = $this$join_u24lambda_u240;
                    boolean $i$f$handleFailure = false;
                    Object object = $this$handleFailure$iv;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable throwable2;
                        Throwable it$iv = throwable2 = throwable;
                        boolean bl = false;
                        Throwable throwable3 = it$iv;
                        boolean bl2 = false;
                        PluginsKt.handleException(throwable3, "Unable to load " + $this$join.getPlayer().getName() + "'s data.");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                Intrinsics.checkNotNullParameter((Object)$this$quit, (String)"<this>");
                PlayerChannelHandler playerChannelHandler = (PlayerChannelHandler)PlayerManagerImpl.access$getPlayerMap$p().remove($this$quit.getPlayer().getUniqueId());
                if (playerChannelHandler != null) {
                    AutoCloseable autoCloseable = playerChannelHandler;
                    Throwable throwable = null;
                    try {
                        PlayerChannelHandler it = (PlayerChannelHandler)autoCloseable;
                        boolean bl = false;
                        GameProfile gameProfile = it.profile();
                        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"profile(...)");
                        SkinManagerImpl.INSTANCE.removeCache(gameProfile);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            }
        });
    }

    private final PlayerChannelHandler register(Player $this$register) {
        PlayerChannelHandler playerChannelHandler;
        PlayerChannelHandler $this$register_u24lambda_u242 = playerChannelHandler = playerMap.computeIfAbsent($this$register.getUniqueId(), arg_0 -> PlayerManagerImpl.register$lambda$1(arg_0 -> PlayerManagerImpl.register$lambda$0($this$register, arg_0), arg_0));
        boolean bl = false;
        if (SkinManagerImpl.INSTANCE.supported()) {
            GameProfile gameProfile = $this$register_u24lambda_u242.profile();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"profile(...)");
            SkinManagerImpl.INSTANCE.getOrRequest(gameProfile);
        }
        PlayerChannelHandler playerChannelHandler2 = playerChannelHandler;
        Intrinsics.checkNotNullExpressionValue((Object)playerChannelHandler2, (String)"apply(...)");
        return playerChannelHandler2;
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
    }

    @Override
    @Nullable
    public PlayerChannelHandler player(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return playerMap.get(uuid);
    }

    @Override
    @NotNull
    public PlayerChannelHandler player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.register(player);
    }

    private static final PlayerChannelHandler register$lambda$0(Player $this_register, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PluginsKt.getPLUGIN().nms().inject($this_register);
    }

    private static final PlayerChannelHandler register$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerChannelHandler)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerMap$p() {
        return playerMap;
    }

    public static final /* synthetic */ PlayerChannelHandler access$register(PlayerManagerImpl $this, Player $receiver) {
        return $this.register($receiver);
    }
}

