/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kr.toxicity.model.api.data.raw.Float3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final Parser PARSER = new Parser();

    public static final class Parser
    implements Function<JsonElement, ModelChildren> {
        private Parser() {
        }

        @Override
        public ModelChildren apply(JsonElement element) {
            if (element.isJsonPrimitive()) {
                return new ModelUUID(element.getAsString());
            }
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                return new ModelGroup(object.getAsJsonPrimitive("name").getAsString(), Float3.PARSER.apply(object.get("origin")), Float3.PARSER.apply(object.get("rotation")), object.getAsJsonPrimitive("uuid").getAsString(), object.getAsJsonArray("children").asList().stream().map(this).toList(), Optional.ofNullable(object.getAsJsonPrimitive("visibility")).map(JsonPrimitive::getAsBoolean).orElse(true));
            }
            throw new RuntimeException();
        }
    }

    public record ModelGroup(@NotNull String name, @NotNull Float3 origin, @NotNull Float3 rotation, @NotNull String uuid, @NotNull List<ModelChildren> children, boolean visibility) implements ModelChildren
    {
    }

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
    }
}

