/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.event.CreateTrackerEvent;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.PlayerTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.tracker.VoidTracker;
import kr.toxicity.model.api.util.EventUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BlueprintRenderer {
    private final ModelBlueprint parent;
    private final @Unmodifiable Map<BoneName, RendererGroup> rendererGroupMap;
    private final Map<String, BlueprintAnimation> animationMap;

    @Nullable
    public RendererGroup groupByTree(@NotNull BoneName name) {
        return BlueprintRenderer.groupByTree0(this.rendererGroupMap, name);
    }

    @Nullable
    private static RendererGroup groupByTree0(@NotNull Map<BoneName, RendererGroup> map, @NotNull BoneName name) {
        if (map.isEmpty()) {
            return null;
        }
        RendererGroup get = map.get(name);
        if (get != null) {
            return get;
        }
        return map.values().stream().map(g -> BlueprintRenderer.groupByTree0(g.getChildren(), name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public @Unmodifiable Set<String> animations() {
        return Collections.unmodifiableSet(this.animationMap.keySet());
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity) {
        return this.create(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        EntityTracker tracker = EntityTracker.tracker(entity.getUniqueId());
        if (tracker != null) {
            return tracker;
        }
        return BlueprintRenderer.generate(() -> new EntityTracker(entity, this.instance(null, entity.getLocation().add(0.0, -1024.0, 0.0), modifier), modifier));
    }

    @NotNull
    public EntityTracker createPlayerLimb(@NotNull Player player) {
        return this.createPlayerLimb(player, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker createPlayerLimb(@NotNull Player player, @NotNull TrackerModifier modifier) {
        EntityTracker tracker = EntityTracker.tracker(player.getUniqueId());
        if (tracker != null) {
            return tracker;
        }
        return BlueprintRenderer.generate(() -> new PlayerTracker(player, this.instance(player, player.getLocation().add(0.0, -1024.0, 0.0), modifier), modifier));
    }

    @NotNull
    public VoidTracker create(@NotNull UUID uuid, @NotNull Location location) {
        return this.create(uuid, TrackerModifier.DEFAULT, location);
    }

    @NotNull
    public VoidTracker create(@NotNull UUID uuid, @NotNull TrackerModifier modifier, @NotNull Location location) {
        return BlueprintRenderer.generate(() -> new VoidTracker(uuid, this.instance(null, location, modifier), modifier, location));
    }

    @NotNull
    private RenderInstance instance(@Nullable Player player, @NotNull Location location, @NotNull TrackerModifier modifier) {
        return new RenderInstance(this, this.rendererGroupMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RendererGroup)e.getValue()).create(player, modifier, location))), this.animationMap);
    }

    private static <T extends Tracker> T generate(Supplier<T> supplier) {
        Tracker created = (Tracker)supplier.get();
        EventUtil.call(new CreateTrackerEvent(created));
        return (T)created;
    }

    @Generated
    public BlueprintRenderer(ModelBlueprint parent, Map<BoneName, RendererGroup> rendererGroupMap, Map<String, BlueprintAnimation> animationMap) {
        this.parent = parent;
        this.rendererGroupMap = rendererGroupMap;
        this.animationMap = animationMap;
    }

    @Generated
    public ModelBlueprint getParent() {
        return this.parent;
    }

    @Generated
    public Map<BoneName, RendererGroup> getRendererGroupMap() {
        return this.rendererGroupMap;
    }
}

