/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.event.ModelDespawnAtPlayerEvent;
import kr.toxicity.model.api.event.ModelSpawnAtPlayerEvent;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tracker
implements AutoCloseable {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(256);
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));
    protected final RenderInstance instance;
    private final ScheduledFuture<?> task;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean runningSingle = new AtomicBoolean();
    private final AtomicBoolean readyForForceUpdate = new AtomicBoolean();
    private final TrackerModifier modifier;
    private final Runnable updater;
    private long frame = 0L;
    private Supplier<ModelRotation> rotationSupplier = () -> ModelRotation.EMPTY;
    private BiConsumer<Tracker, PacketBundler> consumer = (t, b) -> {};

    public Tracker(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        this.instance = instance;
        this.modifier = modifier;
        this.updater = () -> {
            PacketBundler bundle = BetterModel.inst().nms().createBundler();
            boolean moveAccepted = instance.move(this.frame % 5L == 0L ? (this.isRunningSingleAnimation() && BetterModel.inst().configManager().lockOnPlayAnimation() ? instance.getRotation() : this.rotation()) : null, bundle);
            if (this.readyForForceUpdate.compareAndSet(true, false) && !moveAccepted) {
                instance.forceUpdate(bundle);
            }
            this.consumer.accept(this, bundle);
            if (!bundle.isEmpty()) {
                instance.viewedPlayer().forEach(bundle::send);
            }
        };
        this.task = EXECUTOR.scheduleAtFixedRate(() -> {
            if (this.playerCount() > 0) {
                this.updater.run();
            }
            ++this.frame;
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        this.tint(0xFFFFFF);
        if (modifier.sightTrace()) {
            instance.viewFilter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.tick((t, b) -> t.instance.getScriptProcessor().tick());
    }

    @NotNull
    public final ModelRotation rotation() {
        return this.rotationSupplier.get();
    }

    public final void rotation(@NotNull Supplier<ModelRotation> rotationSupplier) {
        this.rotationSupplier = rotationSupplier;
    }

    public void frame(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.consumer = this.consumer.andThen(consumer);
    }

    public void tick(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.schedule(5L, consumer);
    }

    public void schedule(long period, @NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        if (period <= 0L) {
            throw new RuntimeException("period cannot be <= 0");
        }
        this.frame((t, b) -> {
            if (this.frame % period == 0L) {
                consumer.accept((Tracker)t, (PacketBundler)b);
            }
        });
    }

    protected void update() {
        this.updater.run();
    }

    @NotNull
    public String name() {
        return this.instance.getParent().name();
    }

    public double height() {
        return this.instance.height();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.task.cancel(true);
            this.instance.despawn();
        }
    }

    public void despawn() {
        if (!this.isClosed()) {
            this.instance.despawn();
        }
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public void forceUpdate(boolean force) {
        this.readyForForceUpdate.set(force);
    }

    public boolean isRunningSingleAnimation() {
        return this.runningSingle.get();
    }

    protected boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        if (this.isClosed()) {
            return false;
        }
        if (!EventUtil.call(new ModelSpawnAtPlayerEvent(player, this))) {
            return false;
        }
        this.instance.spawn(player, bundler);
        return true;
    }

    public boolean remove(@NotNull Player player) {
        if (this.isClosed()) {
            return false;
        }
        EventUtil.call(new ModelDespawnAtPlayerEvent(player, this));
        this.instance.remove(player);
        return true;
    }

    public int playerCount() {
        return this.instance.playerCount();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.instance.viewedPlayer();
    }

    public void tint(int rgb) {
        this.tint(BonePredicate.TRUE, rgb);
    }

    public void tint(@NotNull BonePredicate predicate, int rgb) {
        if (this.instance.tint(predicate, rgb)) {
            this.forceUpdate(true);
        }
    }

    @NotNull
    public abstract Location location();

    @NotNull
    public abstract UUID uuid();

    public boolean animateLoop(@NotNull String animation) {
        return this.animateLoop(animation, AnimationModifier.DEFAULT_LOOP);
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier) {
        return this.animateLoop(animation, modifier, () -> {});
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animateLoop(e -> true, animation, modifier, removeTask);
    }

    public boolean animateLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.instance.animateLoop(filter, animation, modifier, removeTask);
    }

    public boolean animateSingle(@NotNull String animation) {
        return this.animateSingle(animation, AnimationModifier.DEFAULT);
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier) {
        return this.animateSingle(animation, modifier, () -> {});
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animateSingle(e -> true, animation, modifier, removeTask);
    }

    public boolean animateSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        boolean success = this.instance.animateSingle(filter, animation, modifier, this.wrapToSingle(removeTask));
        if (success) {
            this.runningSingle.set(true);
        }
        return success;
    }

    public void stopAnimation(@NotNull String animation) {
        this.stopAnimation(e -> true, animation);
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation) {
        this.instance.stopAnimation(filter, animation);
    }

    private Runnable wrapToSingle(@NotNull Runnable runnable) {
        return () -> {
            runnable.run();
            this.runningSingle.set(false);
        };
    }

    public boolean replaceLoop(@NotNull String target, @NotNull String animation) {
        return this.replaceLoop(e -> true, target, animation);
    }

    public boolean replaceSingle(@NotNull String target, @NotNull String animation) {
        return this.replaceSingle(e -> true, target, animation);
    }

    public boolean replaceLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        return this.instance.replaceLoop(filter, target, animation);
    }

    public boolean replaceSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        boolean success = this.instance.replaceSingle(filter, target, animation);
        if (success) {
            this.runningSingle.set(true);
        }
        return success;
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.instance.togglePart(predicate, toggle);
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.instance.itemStack(predicate, itemStack);
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.instance.glow(predicate, glow, glowColor);
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.instance.enchant(predicate, enchant);
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.instance.brightness(predicate, block, sky);
    }

    @Nullable
    public RenderedBone bone(@NotNull BoneName name) {
        return this.bone((RenderedBone b) -> b.getName().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull String name) {
        return this.bone((RenderedBone b) -> b.getName().name().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull Predicate<RenderedBone> predicate) {
        return this.instance.boneOf(predicate);
    }

    @NotNull
    public List<RenderedBone> bones() {
        return this.instance.bones();
    }

    @NotNull
    public List<ModelDisplay> displays() {
        return this.bones().stream().map(RenderedBone::getDisplay).filter(Objects::nonNull).toList();
    }

    @Generated
    public RenderInstance getInstance() {
        return this.instance;
    }
}

