/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVIndexer;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVNamespace;
import org.jetbrains.annotations.NotNull;

public final class UVUtil {
    public static final BufferedImage EMPTY_IMAGE = new BufferedImage(16, 16, 1);

    private UVUtil() {
        throw new RuntimeException();
    }

    public static int rgb(int value) {
        return value & 0xFFFFFF;
    }

    public static boolean alpha(int value) {
        return (value >> 24 & 0xFF) > 0;
    }

    @NotNull
    public static JsonObject packModel(@NotNull String textureName, @NotNull JsonArray elements) {
        JsonObject obj = new JsonObject();
        JsonObject textures = new JsonObject();
        textures.addProperty("0", textureName);
        textures.addProperty("particle", textureName);
        obj.add("textures", (JsonElement)textures);
        obj.add("elements", (JsonElement)elements);
        return obj;
    }

    @NotNull
    public static JsonObject model(@NotNull UVNamespace namespace, @NotNull String modelName, @NotNull UVIndexer indexer, int indexes) {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", "model");
        obj.addProperty("model", namespace.asset(modelName));
        JsonArray tints = new JsonArray(indexes);
        for (int i = 0; i < indexes; ++i) {
            JsonObject tint = new JsonObject();
            tint.addProperty("type", "minecraft:custom_model_data");
            tint.addProperty("index", (Number)indexer.color());
            tint.addProperty("default", (Number)0);
            tints.add((JsonElement)tint);
        }
        obj.add("tints", (JsonElement)tints);
        return obj;
    }

    static {
        for (int w = 0; w < 16; ++w) {
            for (int h = 0; h < 16; ++h) {
                EMPTY_IMAGE.setRGB(w, h, 0xFFFFFF);
            }
        }
    }
}

