/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.util.InterpolationUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record BlueprintScript(@NotNull String name, @NotNull AnimationIterator.Type type, float length, @NotNull List<TimeScript> scripts) {
    @NotNull
    public static BlueprintScript from(@NotNull ModelAnimation animation, @NotNull ModelAnimator animator) {
        float time;
        Stream<TimeScript> stream = animator.keyframes().stream().map(d -> AnimationScript.of(d.dataPoints().stream().map(Datapoint::script).filter(Objects::nonNull).map(raw -> BetterModel.plugin().scriptManager().build((String)raw)).filter(Objects::nonNull).toList()).time(d.time()));
        if (animator.keyframes().getFirst().time() > 0.0f) {
            stream = Stream.concat(Stream.of(TimeScript.EMPTY), stream);
        }
        if ((time = animation.length()) > 0.0f) {
            stream = Stream.concat(stream, Stream.of(AnimationScript.EMPTY.time(time)));
        }
        AtomicDouble doubleCache = new AtomicDouble();
        return new BlueprintScript(animation.name(), animation.loop(), animation.length(), stream.distinct().map(t -> t.time(InterpolationUtil.roundTime(t.time() - (float)doubleCache.getAndSet((double)t.time())))).toList());
    }

    @NotNull
    public static BlueprintScript fromEmpty(@NotNull ModelAnimation animation) {
        return new BlueprintScript(animation.name(), animation.loop(), animation.length(), List.of(TimeScript.EMPTY, AnimationScript.EMPTY.time(animation.length())));
    }

    @NotNull
    public AnimationIterator<TimeScript> iterator() {
        return this.type.create(this.scripts);
    }
}

