/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolation;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class BezierInterpolation
implements VectorInterpolation {
    @Nullable
    private final Vector3f bezierLeftTime;
    @Nullable
    private final Vector3f bezierLeftValue;
    @Nullable
    private final Vector3f bezierRightTime;
    @Nullable
    private final Vector3f bezierRightValue;

    @Override
    @NotNull
    public VectorPoint interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
        VectorPoint p1 = p2Index > 0 ? points.get(p2Index - 1) : VectorPoint.EMPTY;
        VectorPoint p2 = points.get(p2Index);
        return new VectorPoint(InterpolationUtil.bezier(time, p1.time(), p2.time(), p1.vector(), p2.vector(), this.bezierLeftTime, this.bezierLeftValue, this.bezierRightTime, this.bezierRightValue), time, this);
    }

    @Generated
    public BezierInterpolation(@Nullable Vector3f bezierLeftTime, @Nullable Vector3f bezierLeftValue, @Nullable Vector3f bezierRightTime, @Nullable Vector3f bezierRightValue) {
        this.bezierLeftTime = bezierLeftTime;
        this.bezierLeftValue = bezierLeftValue;
        this.bezierRightTime = bezierRightTime;
        this.bezierRightValue = bezierRightValue;
    }
}

