/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.Objects;
import java.util.Set;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneTag;
import org.jetbrains.annotations.NotNull;

public record BoneName(@NotNull Set<BoneTag> tags, @NotNull String name, @NotNull String rawName) {
    public boolean tagged(BoneTag ... tags) {
        for (BoneTag boneTag : tags) {
            if (!this.tags.contains(boneTag)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BoneItemMapper toItemMapper() {
        return this.tags.isEmpty() ? BoneItemMapper.EMPTY : this.tags.stream().map(BoneTag::itemMapper).filter(Objects::nonNull).findFirst().orElse(BoneItemMapper.EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoneName)) {
            return false;
        }
        BoneName boneName = (BoneName)o;
        return this.name.equals(boneName.name) && this.tags.equals(boneName.tags);
    }

    @Override
    public int hashCode() {
        return 31 * this.tags.hashCode() * this.name.hashCode();
    }
}

