/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import com.vdurmont.semver4j.Semver;
import java.io.InputStream;
import java.util.function.Consumer;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.manager.CommandManager;
import kr.toxicity.model.api.manager.CompatibilityManager;
import kr.toxicity.model.api.manager.ConfigManager;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.manager.SkinManager;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.pack.PackData;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.scheduler.ModelScheduler;
import kr.toxicity.model.api.version.MinecraftVersion;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterModelPlugin {
    @NotNull
    default public ReloadResult reload() {
        return this.reload(ReloadInfo.DEFAULT);
    }

    @NotNull
    public ReloadResult reload(@NotNull ReloadInfo var1);

    public boolean isSnapshot();

    @NotNull
    public MinecraftVersion version();

    @NotNull
    public Semver semver();

    @NotNull
    public NMS nms();

    @NotNull
    public ModelManager modelManager();

    @NotNull
    public PlayerManager playerManager();

    @NotNull
    public EntityManager entityManager();

    @NotNull
    public CommandManager commandManager();

    @NotNull
    public ScriptManager scriptManager();

    @NotNull
    public CompatibilityManager compatibilityManager();

    @NotNull
    public ConfigManager configManager();

    @NotNull
    public SkinManager skinManager();

    @NotNull
    public ModelScheduler scheduler();

    public void addReloadStartHandler(@NotNull Consumer<PackZipper> var1);

    public void addReloadEndHandler(@NotNull Consumer<ReloadResult> var1);

    @NotNull
    public BetterModelLogger logger();

    @NotNull
    public BukkitAudiences audiences();

    @Nullable
    public InputStream getResource(@NotNull String var1);

    public static sealed interface ReloadResult {
        public static final OnReload ON_RELOAD = new OnReload();

        public static final class OnReload
        implements ReloadResult {
            private OnReload() {
            }
        }

        public record Failure(@NotNull Throwable throwable) implements ReloadResult
        {
        }

        public record Success(long assetsTime, @NotNull PackData packData) implements ReloadResult
        {
            public long packingTime() {
                return this.packData().time();
            }

            public long totalTime() {
                return this.assetsTime + this.packingTime();
            }
        }
    }
}

