/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.function.Supplier;
import kr.toxicity.model.api.pack.PackAssets;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class PackBuilder {
    private final PackAssets assets;
    private final PackPath path;

    @NotNull
    public PackBuilder resolve(String ... paths) {
        return new PackBuilder(this.assets, this.path.resolve(paths));
    }

    public void add(@NotNull String path, @NotNull Supplier<byte[]> supplier) {
        this.add(new String[]{path}, supplier);
    }

    public void add(@NotNull String[] paths, @NotNull Supplier<byte[]> supplier) {
        PackPath resolve = this.path.resolve(paths);
        this.assets.resourceMap.putIfAbsent(resolve, PackResource.of(resolve, supplier));
    }

    @Generated
    public PackBuilder(PackAssets assets, PackPath path) {
        this.assets = assets;
        this.path = path;
    }
}

