/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatSet;
import kr.toxicity.model.api.data.raw.Float3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class MathUtil {
    public static int MINECRAFT_TICK_MILLS = 50;
    public static final float ROTATION_DEGREE = 22.5f;
    public static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    public static final float RADIANS_TO_DEGREES = 57.29578f;
    public static final float MODEL_TO_BLOCK_MULTIPLIER = 16.0f;
    public static final FloatSet VALID_ROTATION_DEGREES = FloatSet.of((float[])new float[]{0.0f, 22.5f, 45.0f, -22.5f, -45.0f});

    private MathUtil() {
        throw new RuntimeException();
    }

    public static boolean checkValidDegree(@NotNull Float3 rotation) {
        int i = 0;
        if (rotation.x() != 0.0f) {
            ++i;
        }
        if (rotation.y() != 0.0f) {
            ++i;
        }
        if (rotation.z() != 0.0f) {
            ++i;
        }
        return i < 2 && MathUtil.checkValidDegree(rotation.x()) && MathUtil.checkValidDegree(rotation.y()) && MathUtil.checkValidDegree(rotation.z());
    }

    public static boolean checkValidDegree(float rotation) {
        return VALID_ROTATION_DEGREES.contains(rotation);
    }

    @NotNull
    public static Float3 identifier(@NotNull Float3 rotation) {
        if (MathUtil.checkValidDegree(rotation)) {
            return Float3.ZERO;
        }
        return rotation;
    }

    @NotNull
    public static Vector3f animationToDisplay(@NotNull Vector3f vector) {
        return new Vector3f(vector.x, -vector.y, -vector.z);
    }

    @NotNull
    public static Vector3f transformToDisplay(@NotNull Vector3f vector) {
        return new Vector3f(vector.x, vector.y, -vector.z);
    }

    @NotNull
    public static Quaternionf toQuaternion(@NotNull Vector3f vector) {
        return new Quaternionf().rotateZYX(vector.z * ((float)Math.PI / 180), vector.y * ((float)Math.PI / 180), vector.x * ((float)Math.PI / 180));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Vector3f vec) {
        return MathUtil.toXYZEuler(MathUtil.toQuaternion(vec));
    }

    @NotNull
    public static Matrix3f toMatrix(@NotNull Quaternionf quaternion) {
        return quaternion.get(new Matrix3f());
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Quaternionf quaternion) {
        return MathUtil.toXYZEuler(MathUtil.toMatrix(quaternion));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Matrix3f mat) {
        Vector3f ret = new Vector3f();
        if (Math.abs(mat.m20) < 1.0f) {
            ret.x = (float)Math.atan2(-mat.m21, mat.m22);
            ret.z = (float)Math.atan2(-mat.m10, mat.m00);
        } else {
            ret.x = (float)Math.atan2(mat.m12, mat.m11);
            ret.z = 0.0f;
        }
        ret.y = (float)Math.asin(Math.clamp(mat.m20, -1.0f, 1.0f));
        return ret.mul(57.29578f);
    }
}

