/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class VectorUtil {
    private static final float FRAME_HASH = 0.031f;

    private VectorUtil() {
        throw new RuntimeException();
    }

    private static void point(@NotNull FloatSet target, @NotNull List<VectorPoint> points) {
        for (VectorPoint point : points) {
            target.add(point.time());
        }
    }

    @NotNull
    public static List<AnimationPoint> putAnimationPoint(@NotNull List<AnimationPoint> animations, @NotNull FloatSet points) {
        return VectorUtil.sum(animations.stream().map(AnimationPoint::position).distinct().toList(), animations.stream().map(AnimationPoint::rotation).distinct().toList(), animations.stream().map(AnimationPoint::scale).distinct().toList(), points);
    }

    public static boolean isVisible(@NotNull Vector3f vector3f) {
        return vector3f.x > 0.0f && vector3f.y > 0.0f && vector3f.z > 0.0f;
    }

    @NotNull
    public static List<AnimationPoint> sum(float length, @NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale) {
        FloatAVLTreeSet set = new FloatAVLTreeSet((Comparator)FloatComparators.NATURAL_COMPARATOR);
        set.add(0.0f);
        set.add(length);
        VectorUtil.point((FloatSet)set, position);
        VectorUtil.point((FloatSet)set, scale);
        VectorUtil.point((FloatSet)set, rotation);
        VectorUtil.insertRotationFrame((FloatSet)set, rotation);
        VectorUtil.insertLerpFrame((FloatCollection)set);
        return VectorUtil.sum(position, rotation, scale, (FloatSet)set);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale, @NotNull FloatSet points) {
        ArrayList<AnimationPoint> list = new ArrayList<AnimationPoint>();
        List<VectorPoint> pp = VectorUtil.putPoint(position, points);
        List<VectorPoint> rp = VectorUtil.putPoint(rotation, points);
        List<VectorPoint> sp = VectorUtil.putPoint(scale, points);
        for (int i = 0; i < pp.size(); ++i) {
            list.add(new AnimationPoint(pp.get(i), rp.get(i), sp.get(i)));
        }
        return list;
    }

    @NotNull
    public static List<VectorPoint> putPoint(@NotNull List<VectorPoint> vectors, @NotNull FloatSet points) {
        ArrayList<VectorPoint> newVectors = new ArrayList<VectorPoint>();
        if (vectors.size() < 2) {
            VectorPoint first = vectors.isEmpty() ? VectorPoint.EMPTY : vectors.getFirst();
            points.iterator().forEachRemaining(f -> newVectors.add(new VectorPoint(first.vector(), f, first.interpolation())));
            return newVectors;
        }
        VectorPoint p1 = VectorPoint.EMPTY;
        VectorPoint p2 = vectors.getFirst();
        VectorPoint last = vectors.getLast();
        float length = last.time();
        int i = 0;
        float t = p2.time();
        FloatIterator floatIterator = points.iterator();
        while (floatIterator.hasNext()) {
            float point = ((Float)floatIterator.next()).floatValue();
            while (i < vectors.size() - 1 && t < point) {
                p1 = p2;
                p2 = vectors.get(++i);
                t = p2.time();
            }
            if (point > length) {
                newVectors.add(new VectorPoint(last.vector(), point, last.interpolation()));
                continue;
            }
            newVectors.add(point == t ? vectors.get(i) : p1.interpolation().interpolate(vectors, i, point));
        }
        if (t < length) {
            newVectors.addAll(vectors.subList(i, vectors.size()));
        }
        return newVectors;
    }

    public static void insertRotationFrame(@NotNull FloatSet frames, @NotNull List<VectorPoint> vectorPoints) {
        for (int i = 0; i < vectorPoints.size() - 1; ++i) {
            VectorPoint before = vectorPoints.get(i);
            VectorPoint after = vectorPoints.get(i + 1);
            Vector3f sub = after.vector().sub((Vector3fc)before.vector(), new Vector3f()).absolute();
            float max = Math.max(sub.x, Math.max(sub.y, sub.z)) / 30.0f;
            float angle = (float)Math.ceil(max);
            if (!(angle > 1.0f)) continue;
            float last = before.time();
            for (float t = 1.0f; t < angle; t += 1.0f) {
                float value = VectorUtil.linear(before.time(), after.time(), t / angle);
                if ((double)(value - last) < 0.05) continue;
                last = value;
                frames.add(last);
            }
        }
    }

    public static void insertLerpFrame(@NotNull FloatCollection frames) {
        VectorUtil.insertLerpFrame(frames, (float)BetterModel.config().lerpFrameTime() / 20.0f);
    }

    public static void insertLerpFrame(@NotNull FloatCollection frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        frame += 0.031f;
        FloatArrayList list = new FloatArrayList(frames);
        float init = 0.0f;
        Float initAfter = (Float)list.getFirst();
        while (true) {
            float f;
            init += frame;
            if (!(f < initAfter.floatValue() - frame)) break;
            frames.add(init);
        }
        block1: for (int i = 0; i < list.size() - 1; ++i) {
            float before = list.getFloat(i);
            float after = list.getFloat(i + 1);
            while (true) {
                float f;
                before += frame;
                if (!(f < after - frame)) continue block1;
                frames.add(before);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f linear(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f(VectorUtil.linear(p0.x, p1.x, alpha), VectorUtil.linear(p0.y, p1.y, alpha), VectorUtil.linear(p0.z, p1.z, alpha));
    }

    public static float linear(float p0, float p1, float alpha) {
        return VectorUtil.fma(p1 - p0, alpha, p0);
    }

    public static float cubicBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float tt = t * t;
        float uuu = uu * u;
        float utt = u * tt;
        float uut = uu * t;
        float ttt = tt * t;
        return VectorUtil.fma(uuu, p0, VectorUtil.fma(3.0f * uut, p1, VectorUtil.fma(3.0f * utt, p2, ttt * p3)));
    }

    public static float derivativeBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float ut = u * t;
        float tt = t * t;
        return VectorUtil.fma(3.0f * uu, p1 - p0, VectorUtil.fma(6.0f * ut, p2 - p1, 3.0f * tt * (p3 - p2)));
    }

    public static float solveBezierTForTime(float time, float t0, float h1, float h2, float t1) {
        float t = 0.5f;
        int maxIterations = 20;
        float epsilon = 1.0E-5f;
        for (int i = 0; i < maxIterations; ++i) {
            float bezTime = VectorUtil.cubicBezier(t0, h1, h2, t1, t);
            float derivative = VectorUtil.derivativeBezier(t0, h1, h2, t1, t);
            float error = bezTime - time;
            if (Math.abs(error) < epsilon) {
                return t;
            }
            if (derivative != 0.0f) {
                t -= error / derivative;
            }
            t = Math.clamp(t, 0.0f, 1.0f);
        }
        return t;
    }

    @NotNull
    public static Vector3f bezier(float time, float startTime, float endTime, @NotNull Vector3f startValue, @NotNull Vector3f endValue, @Nullable Vector3f bezierLeftTime, @Nullable Vector3f bezierLeftValue, @Nullable Vector3f bezierRightTime, @Nullable Vector3f bezierRightValue) {
        Vector3f p1 = bezierRightValue != null ? bezierRightValue.add((Vector3fc)startValue, new Vector3f()) : startValue;
        Vector3f p2 = bezierLeftValue != null ? bezierLeftValue.add((Vector3fc)endValue, new Vector3f()) : endValue;
        return new Vector3f(VectorUtil.cubicBezier(startValue.x, p1.x, p2.x, endValue.x, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.x + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.x + endTime : endTime, endTime)), VectorUtil.cubicBezier(startValue.y, p1.y, p2.y, endValue.y, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.y + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.y + endTime : endTime, endTime)), VectorUtil.cubicBezier(startValue.z, p1.z, p2.z, endValue.z, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.z + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.z + endTime : endTime, endTime)));
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(VectorUtil.fma(t3, VectorUtil.fma(-1.0f, p0.x, VectorUtil.fma(3.0f, p1.x, VectorUtil.fma(-3.0f, p2.x, p3.x))), VectorUtil.fma(t2, VectorUtil.fma(2.0f, p0.x, VectorUtil.fma(-5.0f, p1.x, VectorUtil.fma(4.0f, p2.x, -p3.x))), VectorUtil.fma(t, -p0.x + p2.x, 2.0f * p1.x))), VectorUtil.fma(t3, VectorUtil.fma(-1.0f, p0.y, VectorUtil.fma(3.0f, p1.y, VectorUtil.fma(-3.0f, p2.y, p3.y))), VectorUtil.fma(t2, VectorUtil.fma(2.0f, p0.y, VectorUtil.fma(-5.0f, p1.y, VectorUtil.fma(4.0f, p2.y, -p3.y))), VectorUtil.fma(t, -p0.y + p2.y, 2.0f * p1.y))), VectorUtil.fma(t3, VectorUtil.fma(-1.0f, p0.z, VectorUtil.fma(3.0f, p1.z, VectorUtil.fma(-3.0f, p2.z, p3.z))), VectorUtil.fma(t2, VectorUtil.fma(2.0f, p0.z, VectorUtil.fma(-5.0f, p1.z, VectorUtil.fma(4.0f, p2.z, -p3.z))), VectorUtil.fma(t, -p0.z + p2.z, 2.0f * p1.z)))).mul(0.5f);
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a, @NotNull Vector3f b2, @NotNull Vector3f c2) {
        a.x = VectorUtil.fma(a.x, b2.x, c2.x);
        a.y = VectorUtil.fma(a.y, b2.y, c2.y);
        a.z = VectorUtil.fma(a.z, b2.z, c2.z);
        return a;
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a, float b2, @NotNull Vector3f c2) {
        a.x = VectorUtil.fma(a.x, b2, c2.x);
        a.y = VectorUtil.fma(a.y, b2, c2.y);
        a.z = VectorUtil.fma(a.z, b2, c2.z);
        return a;
    }

    public static float fma(float a, float b2, float c2) {
        return Math.fma(a, b2, c2);
    }
}

