/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.util;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.net.http.HttpClient;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kr.toxicity.model.BetterModelPluginImpl;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.util.HttpUtil;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.PackUtil;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.util.PluginsKt;
import kr.toxicity.model.util.SendersKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001a\u001a\u001f\u0010\u001b\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001a\u001a\u001a\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u001f\u001a\u00020\u0016*\u00020 2\u0006\u0010\u0017\u001a\u00020!\u001a5\u0010\"\u001a\b\u0012\u0004\u0012\u0002H$0#\"\u0004\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u001a\u000f\u0010&\u001a\u00070!\u00a2\u0006\u0002\b\u0006*\u00020!\u001a/\u0010'\u001a\b\u0012\u0004\u0012\u0002H$0(\"\b\b\u0000\u0010$*\u00020\u000f2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H$0*\u00a2\u0006\u0002\b,\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"$\u0010\r\u001a\u0018\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u0010\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"PLUGIN", "Lkr/toxicity/model/BetterModelPluginImpl;", "getPLUGIN", "()Lkr/toxicity/model/BetterModelPluginImpl;", "CONFIG", "Lkr/toxicity/model/api/BetterModelConfig;", "Lorg/jetbrains/annotations/NotNull;", "getCONFIG", "()Lkr/toxicity/model/api/BetterModelConfig;", "DATA_FOLDER", "Ljava/io/File;", "getDATA_FOLDER", "()Ljava/io/File;", "LATEST_VERSION_CACHE", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lkr/toxicity/model/shaded/kotlin/jvm/internal/EnhancedNullability;", "Lkr/toxicity/model/api/util/HttpUtil$LatestVersion;", "LATEST_VERSION", "getLATEST_VERSION", "()Lkr/toxicity/model/api/util/HttpUtil$LatestVersion;", "info", "", "message", "", "Lnet/kyori/adventure/text/Component;", "([Lnet/kyori/adventure/text/Component;)V", "warn", "debugPack", "lazyMessage", "Lkr/toxicity/model/shaded/kotlin/Function0;", "handleException", "", "", "handleFailure", "Lkr/toxicity/model/shaded/kotlin/Result;", "T", "(Ljava/lang/Object;Lkr/toxicity/model/shaded/kotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toPackName", "httpClient", "Lkr/toxicity/model/api/util/HttpUtil$Result;", "block", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Ljava/net/http/HttpClient;", "Lkr/toxicity/model/shaded/kotlin/ExtensionFunctionType;", "core"})
public final class PluginsKt {
    @NotNull
    private static final LoadingCache<Object, HttpUtil.LatestVersion> LATEST_VERSION_CACHE;

    @NotNull
    public static final BetterModelPluginImpl getPLUGIN() {
        BetterModelPlugin betterModelPlugin = BetterModel.plugin();
        Intrinsics.checkNotNull((Object)betterModelPlugin, (String)"null cannot be cast to non-null type kr.toxicity.model.BetterModelPluginImpl");
        return (BetterModelPluginImpl)betterModelPlugin;
    }

    @NotNull
    public static final BetterModelConfig getCONFIG() {
        BetterModelConfig betterModelConfig = BetterModel.config();
        Intrinsics.checkNotNullExpressionValue((Object)betterModelConfig, (String)"config(...)");
        return betterModelConfig;
    }

    @NotNull
    public static final File getDATA_FOLDER() {
        File file = PluginsKt.getPLUGIN().getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        return file;
    }

    @NotNull
    public static final HttpUtil.LatestVersion getLATEST_VERSION() {
        Object object = LATEST_VERSION_CACHE.get((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (HttpUtil.LatestVersion)object;
    }

    public static final void info(Component ... message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PluginsKt.getPLUGIN().logger().info(Arrays.copyOf(message, message.length));
    }

    public static final void warn(Component ... message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PluginsKt.getPLUGIN().logger().warn(Arrays.copyOf(message, message.length));
    }

    public static final void debugPack(@NotNull Function0<? extends Component> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$debugPack = false;
        if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
            Component[] componentArray = new Component[1];
            ComponentLike[] componentLikeArray = new ComponentLike[2];
            String string = "[" + Thread.currentThread().getName() + "] ";
            NamedTextColor namedTextColor = NamedTextColor.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"YELLOW");
            componentLikeArray[0] = SendersKt.toComponent(string, (TextColor)namedTextColor);
            componentLikeArray[1] = lazyMessage.invoke();
            componentArray[0] = SendersKt.componentOf(componentLikeArray);
            PluginsKt.info(componentArray);
        }
    }

    public static final void handleException(@NotNull Throwable $this$handleException, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$handleException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LogUtil.handleException(message, $this$handleException);
    }

    @NotNull
    public static final <T> Object handleFailure(@NotNull Object $this$handleFailure, @NotNull Function0<String> lazyMessage) {
        Object object;
        block0: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            boolean $i$f$handleFailure = false;
            object = $this$handleFailure;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block0;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            PluginsKt.handleException(it, (String)lazyMessage.invoke());
        }
        return object;
    }

    @NotNull
    public static final String toPackName(@NotNull String $this$toPackName) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackName, (String)"<this>");
        String string = PackUtil.toPackName($this$toPackName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPackName(...)");
        return string;
    }

    @NotNull
    public static final <T> HttpUtil.Result<T> httpClient(@NotNull Function1<? super HttpClient, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        HttpUtil.Result<Object> result = HttpUtil.client(arg_0 -> PluginsKt.httpClient$lambda$0(block, arg_0));
        Intrinsics.checkNotNullExpressionValue(result, (String)"client(...)");
        return result;
    }

    private static final Object httpClient$lambda$0(Function1 $block, HttpClient it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $block.invoke((Object)it);
    }

    static {
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)LATEST_VERSION_CACHE.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        LATEST_VERSION_CACHE = loadingCache;
    }
}

