/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerMovement;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements HitBoxSource {
    private final RendererGroup group;
    private ModelDisplay display;
    private final BoneMovement defaultFrame;
    @Nullable
    private final RenderedBone parent;
    private Map<String, RenderedBone> children = Collections.emptyMap();
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private AnimationMovement keyFrame = null;
    private long delay = 0L;
    private TransformedItemStack itemStack;
    private TransformedItemStack cachedStack;
    private final List<Consumer<AnimationMovement>> movementModifier = new ArrayList<Consumer<AnimationMovement>>();
    private HitBox hitBox;
    private int tint;
    private TreeIterator currentIterator = null;
    private BoneMovement beforeTransform;
    private BoneMovement afterTransform;
    private BoneMovement relativeOffsetCache;
    private Vector3f defaultPosition = new Vector3f();
    private ModelRotation rotation = ModelRotation.EMPTY;

    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull BoneMovement movement) {
        this.group = group;
        this.parent = parent;
        boolean visible = group.getLimb() != null || group.getParent().visibility();
        this.cachedStack = visible ? itemStack : TransformedItemStack.EMPTY;
        this.itemStack = this.cachedStack;
        if (!itemStack.isEmpty()) {
            this.display = BetterModel.inst().nms().create(firstLocation);
            this.display.display(transform);
            if (visible) {
                this.display.item(itemStack.itemStack());
            }
        }
        this.defaultFrame = movement;
    }

    @ApiStatus.Internal
    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        NamedBoundingBox h = this.group.getHitBox();
        if (h != null && predicate.test(this)) {
            HitBoxListener l = listener;
            if (this.hitBox != null) {
                this.hitBox.removeHitBox();
                if (l == null) {
                    l = this.hitBox.listener();
                }
            }
            this.hitBox = BetterModel.inst().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
        }
        this.forEachChildren(e -> e.createHitBox(entity, predicate, listener));
    }

    @ApiStatus.Internal
    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        BonePredicate children;
        boolean checked = false;
        if (predicate.test(this)) {
            this.itemStack = this.cachedStack = itemStack;
            checked = this.applyItem();
        }
        if (this.checkChildren(arg_0 -> RenderedBone.lambda$itemStack$1(children = predicate.children(checked), itemStack, arg_0))) {
            checked = true;
        }
        return checked;
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        BonePredicate children;
        boolean checked = false;
        if (predicate.test(this) && this.display != null) {
            this.display.brightness(block, sky);
            checked = true;
        }
        if (this.checkChildren(arg_0 -> RenderedBone.lambda$brightness$2(children = predicate.children(checked), block, sky, arg_0))) {
            checked = true;
        }
        return checked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimationMovementModifier(@NotNull BonePredicate predicate, @NotNull Consumer<AnimationMovement> consumer) {
        BonePredicate children;
        boolean checked = false;
        if (predicate.test(this)) {
            List<Consumer<AnimationMovement>> list = this.movementModifier;
            synchronized (list) {
                this.movementModifier.add(consumer);
            }
            checked = true;
        }
        if (this.checkChildren(arg_0 -> RenderedBone.lambda$addAnimationMovementModifier$3(children = predicate.children(checked), consumer, arg_0))) {
            checked = true;
        }
        return checked;
    }

    @ApiStatus.Internal
    public void renderers(List<RenderedBone> renderers) {
        renderers.add(this);
        this.forEachChildren(e -> e.renderers(renderers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.reversedView.iterator();
            boolean check = true;
            while (iterator2.hasNext()) {
                TreeIterator next = iterator2.next();
                if (!next.get().booleanValue()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator = next;
                    check = false;
                    break;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0L;
                    check = false;
                    break;
                }
                if (this.delay <= 0L) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    check = false;
                    break;
                }
                check = false;
                break;
            }
            if (check) {
                this.keyFrame = null;
            }
        }
    }

    private boolean updateKeyframe(Iterator<TreeIterator> iterator2, TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        this.relativeOffsetCache = null;
        this.keyFrame = next.next();
        return true;
    }

    public void move(@Nullable ModelRotation rotation, @NotNull TrackerMovement movement, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (rotation != null) {
            this.rotation = rotation;
            if (d != null) {
                d.rotate(rotation, bundler);
            }
        }
        --this.delay;
        this.updateAnimation();
        if (this.delay <= 0L) {
            int f = this.frame();
            this.delay = f;
            this.beforeTransform = this.afterTransform;
            this.afterTransform = movement.plus(this.relativeOffset());
            BoneMovement entityMovement = this.afterTransform.plus(this.defaultPosition);
            if (d != null) {
                d.frame(f <= 0 ? 0 : RenderedBone.toInterpolationDuration(f));
                this.setup(entityMovement);
                d.send(bundler);
            }
        }
        this.forEachChildren(e -> e.move(rotation, movement, bundler));
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        this.forceUpdate0(bundler);
        this.forEachChildren(e -> e.forceUpdate(bundler));
    }

    private void forceUpdate0(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null && this.delay > 0L) {
            float speed = this.currentIterator != null ? this.currentIterator.deltaSpeed() : 1.0f;
            this.delay = Math.round((float)this.delay / speed);
            d.frame(RenderedBone.toInterpolationDuration(this.delay));
            d.send(bundler);
        }
    }

    private static int toInterpolationDuration(long delay) {
        return (int)Math.floor((float)delay / 5.0f) + 1;
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(new Vector3f());
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f offset) {
        if (this.afterTransform != null) {
            float progress = 1.0f - this.progress();
            BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
            Vector3f vec = VectorUtil.linear(before.transform(), this.afterTransform.transform(), progress).add((Vector3fc)offset).add((Vector3fc)this.itemStack.offset()).mul((Vector3fc)VectorUtil.linear(before.scale(), this.afterTransform.scale(), progress)).rotate((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(VectorUtil.linear(before.rawRotation(), this.afterTransform.rawRotation(), progress)))).add((Vector3fc)this.defaultPosition).rotateX((float)(-Math.toRadians(this.rotation.x()))).rotateY((float)(-Math.toRadians(this.rotation.y())));
            return vec.isFinite() ? vec : new Vector3f();
        }
        return new Vector3f();
    }

    private void setup(@NotNull BoneMovement boneMovement) {
        if (this.display != null) {
            this.display.transform(new Transformation(new Vector3f((Vector3fc)boneMovement.transform()).add((Vector3fc)new Vector3f((Vector3fc)this.itemStack.offset()).rotate((Quaternionfc)boneMovement.rotation())), boneMovement.rotation(), new Vector3f((Vector3fc)boneMovement.scale()).mul((Vector3fc)this.itemStack.scale()), new Quaternionf()));
        }
    }

    public void defaultPosition(@NotNull Vector3f movement) {
        this.defaultPosition = this.group.getLimb() != null ? new Vector3f((Vector3fc)movement).add((Vector3fc)this.group.getLimb().getPosition()) : movement;
        this.forEachChildren(e -> e.defaultPosition(movement));
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoneMovement defaultFrame() {
        AnimationMovement k = this.keyFrame != null ? this.keyFrame.copyNotNull() : new AnimationMovement(0.0f, new Vector3f(), new Vector3f(), new Vector3f());
        List<Consumer<AnimationMovement>> list = this.movementModifier;
        synchronized (list) {
            for (Consumer<AnimationMovement> consumer : this.movementModifier) {
                consumer.accept(k);
            }
        }
        return this.defaultFrame.plus(k);
    }

    private float progress() {
        return (float)this.delay / (float)this.frame();
    }

    private BoneMovement relativeOffset() {
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        BoneMovement def = this.defaultFrame();
        if (this.parent != null) {
            BoneMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new BoneMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = def;
        return this.relativeOffsetCache;
    }

    public boolean tint(@NotNull BonePredicate predicate, int tint) {
        BonePredicate children;
        boolean checked = false;
        if (predicate.test(this)) {
            this.tint = tint;
            checked = this.applyItem();
        }
        if (this.checkChildren(arg_0 -> RenderedBone.lambda$tint$8(children = predicate.children(checked), tint, arg_0))) {
            checked = true;
        }
        return checked;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(BetterModel.inst().nms().tint(this.itemStack.itemStack().clone(), this.tint));
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
        this.forEachChildren(e -> e.teleport(location, bundler));
    }

    public void spawn(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(bundler);
        }
        this.forEachChildren(e -> e.spawn(bundler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.loopIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
        this.forEachChildren(e -> e.addLoop(filter, parent, animator, modifier, () -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.singleIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
        this.forEachChildren(e -> e.addSingle(filter, parent, animator, modifier, () -> {}));
    }

    public void replaceModifier(@NotNull Predicate<RenderedBone> filter, @NotNull Function<AnimationModifier, AnimationModifier> function) {
        TreeIterator get;
        if (filter.test(this) && (get = (TreeIterator)this.animators.get(this.getName())) != null) {
            get.modifier = Objects.requireNonNull(function.apply(get.modifier));
        }
        this.forEachChildren(e -> e.replaceModifier(filter, function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}) : new TreeIterator(parent, animator.emptyLoopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}));
                }
            }
        }
        this.forEachChildren(e -> e.replaceLoop(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), AnimationModifier.DEFAULT, () -> {}) : new TreeIterator(parent, animator.emptySingleIterator(), AnimationModifier.DEFAULT, () -> {}));
                }
            }
        }
        this.forEachChildren(e -> e.replaceSingle(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.remove(parent);
            }
        }
        this.forEachChildren(e -> e.stopAnimation(filter, parent));
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
        this.forEachChildren(e -> e.remove(bundler));
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        BonePredicate children;
        boolean checked = false;
        if (predicate.test(this)) {
            this.itemStack = toggle ? this.cachedStack : TransformedItemStack.EMPTY;
            checked = this.applyItem();
        }
        if (this.checkChildren(arg_0 -> RenderedBone.lambda$togglePart$24(children = predicate.children(checked), toggle, arg_0))) {
            checked = true;
        }
        return checked;
    }

    private void forEachChildren(@NotNull Consumer<RenderedBone> consumer) {
        this.children.values().forEach(consumer);
    }

    private boolean checkChildren(@NotNull Function<RenderedBone, Boolean> function) {
        boolean checked = false;
        for (RenderedBone value : this.children.values()) {
            if (!function.apply(value).booleanValue()) continue;
            checked = true;
        }
        return checked;
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox hitBox = this.group.getHitBox();
        return this.worldPosition(hitBox != null ? hitBox.centerVector() : new Vector3f());
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    public void despawn() {
        if (this.hitBox != null) {
            this.hitBox.removeHitBox();
        }
        for (RenderedBone value : this.children.values()) {
            value.despawn();
        }
    }

    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Generated
    public void setChildren(Map<String, RenderedBone> children) {
        this.children = children;
    }

    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    private static /* synthetic */ Boolean lambda$togglePart$24(BonePredicate children, boolean toggle, RenderedBone e) {
        return e.togglePart(children, toggle);
    }

    private static /* synthetic */ Boolean lambda$tint$8(BonePredicate children, int tint, RenderedBone e) {
        return e.tint(children, tint);
    }

    private static /* synthetic */ Boolean lambda$addAnimationMovementModifier$3(BonePredicate children, Consumer consumer, RenderedBone e) {
        return e.addAnimationMovementModifier(children, consumer);
    }

    private static /* synthetic */ Boolean lambda$brightness$2(BonePredicate children, int block, int sky, RenderedBone e) {
        return e.brightness(children, block, sky);
    }

    private static /* synthetic */ Boolean lambda$itemStack$1(BonePredicate children, TransformedItemStack itemStack, RenderedBone e) {
        return e.itemStack(children, itemStack);
    }

    private static class TreeIterator
    implements BlueprintAnimator.AnimatorIterator,
    Supplier<Boolean>,
    Runnable {
        private final String name;
        private final BlueprintAnimator.AnimatorIterator iterator;
        private AnimationModifier modifier;
        private final Runnable removeTask;
        private boolean started = false;
        private boolean ended = false;
        private float cachedSpeed = 1.0f;

        public TreeIterator(String name, BlueprintAnimator.AnimatorIterator iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.name = name;
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public Boolean get() {
            return this.modifier.predicate().get();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        public float deltaSpeed() {
            float previous = this.cachedSpeed;
            this.cachedSpeed = this.modifier.speedValue();
            return this.cachedSpeed / previous;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return new AnimationMovement((float)this.modifier.end() / 20.0f, null, null, null);
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            this.cachedSpeed = this.modifier.speedValue();
            nxt = nxt.time(Math.max(nxt.time() / this.cachedSpeed, 0.01f));
            return nxt;
        }

        @Override
        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeIterator that = (TreeIterator)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

