/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.BlueprintRenderer;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.ScriptProcessor;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerMovement;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class RenderInstance {
    private final BlueprintRenderer parent;
    private final Map<String, RenderedBone> entityMap;
    private final Map<String, BlueprintAnimation> animationMap;
    private final Map<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private Predicate<Player> viewFilter = p -> true;
    private Predicate<Player> spawnFilter = p -> true;
    private ModelRotation rotation = ModelRotation.EMPTY;
    private final ScriptProcessor scriptProcessor = new ScriptProcessor();

    public RenderInstance(@NotNull BlueprintRenderer parent, @NotNull Map<String, RenderedBone> entityMap, @NotNull Map<String, BlueprintAnimation> animationMap) {
        this.parent = parent;
        this.entityMap = entityMap;
        this.animationMap = animationMap;
        this.animateLoop("idle");
    }

    public void viewFilter(@NotNull Predicate<Player> filter) {
        this.viewFilter = this.viewFilter.and(FunctionUtil.throttleTick(filter));
    }

    @NotNull
    public Predicate<Player> spawnFilter() {
        return this.spawnFilter;
    }

    public void spawnFilter(@NotNull Predicate<Player> spawnFilter) {
        this.spawnFilter = this.spawnFilter.and(spawnFilter);
    }

    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        for (RenderedBone value : this.entityMap.values()) {
            value.createHitBox(entity, predicate, listener);
        }
    }

    public void despawn() {
        for (RenderedBone renderedBone : this.entityMap.values()) {
            renderedBone.despawn();
        }
        for (PlayerChannelHandler playerChannelHandler : this.playerMap.values()) {
            this.remove0(playerChannelHandler.player());
        }
        this.playerMap.clear();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        this.entityMap.values().forEach(e -> e.teleport(location, bundler));
    }

    public void move(@Nullable ModelRotation rotation, @NotNull TrackerMovement movement, @NotNull PacketBundler bundler) {
        ModelRotation rot = rotation == null || rotation.equals(this.rotation) ? null : (this.rotation = rotation);
        this.entityMap.values().forEach(e -> e.move(rot, movement, bundler));
    }

    public void defaultPosition(@NotNull Vector3f movement) {
        for (RenderedBone value : this.entityMap.values()) {
            value.defaultPosition(new Vector3f((Vector3fc)movement).add((Vector3fc)value.getGroup().getPosition()));
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.forceUpdate(bundler);
        }
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        boolean checked = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.itemStack(predicate, itemStack)) continue;
            checked = true;
        }
        return checked;
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        boolean checked = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.brightness(predicate, block, sky)) continue;
            checked = true;
        }
        return checked;
    }

    public boolean addAnimationMovementModifier(@NotNull BonePredicate predicate, @NotNull Consumer<AnimationMovement> consumer) {
        boolean ret = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.addAnimationMovementModifier(predicate, consumer)) continue;
            ret = true;
        }
        return ret;
    }

    @NotNull
    public List<RenderedBone> renderers() {
        ArrayList<RenderedBone> list = new ArrayList<RenderedBone>();
        this.entityMap.values().forEach(e -> e.renderers(list));
        return list;
    }

    public double height() {
        double h = 0.0;
        for (RenderedBone renderer : this.renderers()) {
            float lt = renderer.worldPosition().y;
            if (renderer.getName().startsWith("h_")) {
                return lt;
            }
            if (!(h < (double)lt)) continue;
            h = lt;
        }
        return h;
    }

    public boolean tint(@NotNull BonePredicate predicate, int rgb) {
        boolean checked = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.tint(predicate, rgb)) continue;
            checked = true;
        }
        return checked;
    }

    public boolean animateLoop(@NotNull String animation) {
        return this.animateLoop(e -> true, animation, AnimationModifier.DEFAULT_LOOP, () -> {});
    }

    public boolean animateSingle(@NotNull String animation) {
        return this.animateSingle(e -> true, animation, AnimationModifier.DEFAULT, () -> {});
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier) {
        return this.animateLoop(e -> true, animation, modifier, () -> {});
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier) {
        return this.animateSingle(e -> true, animation, modifier, () -> {});
    }

    public boolean animateLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateLoop(get.script(), modifier);
        for (RenderedBone value : this.entityMap.values()) {
            value.addLoop(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask));
        }
        return true;
    }

    public boolean animateSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateSingle(get.script(), modifier);
        for (RenderedBone value : this.entityMap.values()) {
            value.addSingle(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask));
        }
        return true;
    }

    public boolean replaceLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceLoop(get.script(), AnimationModifier.DEFAULT_LOOP);
        for (RenderedBone value : this.entityMap.values()) {
            value.replaceLoop(filter, target, animation, get);
        }
        return true;
    }

    public boolean replaceSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceSingle(get.script(), AnimationModifier.DEFAULT);
        for (RenderedBone value : this.entityMap.values()) {
            value.replaceSingle(filter, target, animation, get);
        }
        return true;
    }

    public void replaceModifier(@NotNull Predicate<RenderedBone> filter, @NotNull Function<AnimationModifier, AnimationModifier> function) {
        for (RenderedBone value : this.entityMap.values()) {
            value.replaceModifier(filter, function);
        }
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String target) {
        this.scriptProcessor.stopAnimation(target);
        for (RenderedBone value : this.entityMap.values()) {
            value.stopAnimation(filter, target);
        }
    }

    public void spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        PlayerChannelHandler get = BetterModel.inst().playerManager().player(player.getUniqueId());
        if (get == null) {
            return;
        }
        if (this.playerMap.get(player.getUniqueId()) != null || this.spawnFilter.test(player)) {
            this.entityMap.values().forEach(e -> e.spawn(bundler));
            this.playerMap.put(player.getUniqueId(), get);
        }
    }

    public void remove(@NotNull Player player) {
        if (this.playerMap.remove(player.getUniqueId()) == null) {
            return;
        }
        this.remove0(player);
    }

    private void remove0(@NotNull Player player) {
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.entityMap.values().forEach(e -> e.remove(bundler));
        bundler.send(player);
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        boolean checked = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.togglePart(predicate, toggle)) continue;
            checked = true;
        }
        return checked;
    }

    public int playerCount() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<PlayerChannelHandler> allPlayer() {
        return this.playerMap.values().stream();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.viewedPlayer(this.viewFilter);
    }

    @NotNull
    public Stream<Player> viewedPlayer(@NotNull Predicate<Player> predicate) {
        return this.allPlayer().map(PlayerChannelHandler::player).filter(predicate);
    }

    @Generated
    public BlueprintRenderer getParent() {
        return this.parent;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    @Generated
    public ScriptProcessor getScriptProcessor() {
        return this.scriptProcessor;
    }
}

