/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record TransformedItemStack(@NotNull Vector3f offset, @NotNull Vector3f scale, @NotNull ItemStack itemStack) {
    @NotNull
    public static final TransformedItemStack EMPTY = TransformedItemStack.of(new ItemStack(Material.AIR));

    @NotNull
    public static TransformedItemStack of(@NotNull ItemStack itemStack) {
        return TransformedItemStack.of(new Vector3f(), new Vector3f(1.0f), itemStack);
    }

    @NotNull
    public static TransformedItemStack of(@NotNull Vector3f offset, @NotNull Vector3f scale, @NotNull ItemStack itemStack) {
        return new TransformedItemStack(offset, scale, itemStack);
    }

    public boolean isEmpty() {
        return switch (this.itemStack.getType()) {
            case Material.AIR, Material.CAVE_AIR, Material.VOID_AIR -> true;
            default -> false;
        };
    }

    @NotNull
    public TransformedItemStack copy() {
        return new TransformedItemStack(new Vector3f((Vector3fc)this.offset), new Vector3f((Vector3fc)this.scale), this.itemStack.clone());
    }
}

