/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPI;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIHandler;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandRegistrationStrategy;
import kr.toxicity.model.shaded.dev.jorel.commandapi.SafeVarHandle;
import kr.toxicity.model.shaded.dev.jorel.commandapi.SpigotCommandRegistration;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.ArgumentSubType;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.SuggestionProviders;
import kr.toxicity.model.shaded.dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import kr.toxicity.model.shaded.dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import kr.toxicity.model.shaded.dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import kr.toxicity.model.shaded.dev.jorel.commandapi.nms.NMS_Common;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.FloatRange;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.FunctionWrapper;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.IntegerRange;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.Location2D;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.ParticleData;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.ScoreboardSlot;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftSound;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_17_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_17_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public abstract class NMS_1_17_Common
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
    private static final Field entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "o", "usesSelector");
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemInput = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "tag", NBTTagCompound.class);

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getKey()));
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.multipleEntities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    @Override
    public Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public abstract String[] compatibleVersions();

    @Override
    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().asString();
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(commandFunction, css);
        CustomFunction.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_17_Common.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key).e();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.ofExact((int)color);
    }

    @Override
    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)((MinecraftKey)cmdCtx.getArgument(key, MinecraftKey.class)).getKey().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var4_6 = biome;
                yield var4_6;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var4_7;
                yield var4_7 = NMS_1_17_Common.fromResourceLocation((MinecraftKey)cmdCtx.getArgument(key, MinecraftKey.class));
            }
            default -> {
                NamespacedKey var4_8;
                yield var4_8 = null;
            }
        };
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)senderWrapper.getSource());
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_17_Common.fromResourceLocation(IRegistry.X.getKey((Object)ArgumentEnchantment.a(cmdCtx, (String)key))));
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.getEntities((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.getName((EntityTypes)((EntityTypes)IRegistry.Y.get(ArgumentEntitySummon.a(cmdCtx, (String)key)))).getKey());
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.a();
        Double highBoxed = (Double)range.b();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public final SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey resourceLocation = new MinecraftKey(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CustomFunction)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public final Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().e()) {
            result.add(NMS_1_17_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.a();
        Integer highBoxed = (Integer)range.b();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemInput.get(input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.a, blockPos.b);
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.getX(), vecPos.getY(), vecPos.getZ());
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_17_Common.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().getLootTable(resourceLocation));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return NMS_1_17_Common.fromResourceLocation(ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key));
    }

    @Override
    public Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, Particle particle, VibrationParticleOption options) {
        BlockPosition origin = options.c().b();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).getWorld();
        Location from = new Location((World)level.getWorld(), (double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
        PositionSource positionSource = options.c().c();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.c().c()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        BlockPosition to = (BlockPosition)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.getX(), (double)to.getY(), (double)to.getZ()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.c().a()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.getById((int)IRegistry.V.getId((Object)ArgumentMobEffect.a(cmdCtx, (String)key)));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_17_Common.fromResourceLocation(ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_17_Common.fromResourceLocation(recipe.getKey()), recipe.toBukkitRecipe());
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = css.getPosition();
        Vec2F rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.getX(), pos.getY(), pos.getZ(), rot.j, rot.i);
        Entity proxyEntity = css.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEffect soundEvent = (SoundEffect)IRegistry.T.get(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEffect)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.getNamespace() + ":" + soundResource.getKey()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctionData();
                ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).getAdvancementData().getAdvancements().stream().map(Advancement::getName), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> CompletionProviders.d;
            case SuggestionProviders.ENTITIES -> CompletionProviders.e;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)IRegistry.V.keySet(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).getFunctionData().b(new MinecraftKey(key.getNamespace(), key.getKey())).getTagged();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().f()) {
            result.add(NMS_1_17_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.getWorld() == null ? null : css.getWorld().getWorld();
    }

    @Override
    public abstract void reloadDataPacks();

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        return new SpigotCommandRegistration<CommandListenerWrapper>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
    }
}

