/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.BlueprintRenderer;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.entity.RenderedEntity;
import kr.toxicity.model.api.entity.TrackerMovement;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.EntityScript;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EntityTracker
extends Tracker {
    private static final Map<UUID, EntityTracker> TRACKER_MAP = new ConcurrentHashMap<UUID, EntityTracker>();
    @NotNull
    private final Entity entity;
    @NotNull
    private final EntityAdapter adapter;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean forRemoval = new AtomicBoolean();
    private final AtomicBoolean autoSpawn = new AtomicBoolean(true);
    private final AtomicInteger damageTintValue = new AtomicInteger(0xFF7979);
    private final AtomicLong damageTint = new AtomicLong(-1L);

    @NotNull
    public UUID world() {
        return this.entity.getWorld().getUID();
    }

    @Nullable
    public static EntityTracker tracker(@NotNull Entity entity) {
        EntityTracker t = EntityTracker.tracker(entity.getUniqueId());
        if (t == null) {
            String tag = (String)entity.getPersistentDataContainer().get(TRACKING_ID, PersistentDataType.STRING);
            if (tag == null) {
                return null;
            }
            BlueprintRenderer render = BetterModel.inst().modelManager().renderer(tag);
            if (render != null) {
                return render.create(entity);
            }
        }
        return t;
    }

    @Nullable
    public static EntityTracker tracker(@NotNull UUID uuid) {
        return TRACKER_MAP.get(uuid);
    }

    public static void reload() {
        for (EntityTracker value : new ArrayList<EntityTracker>(TRACKER_MAP.values())) {
            Entity target = value.entity;
            Location loc = target.getLocation();
            BetterModel.inst().scheduler().task(loc, () -> {
                String name;
                try (EntityTracker entityTracker = value;){
                    if (value.forRemoval()) {
                        return;
                    }
                    name = value.name();
                }
                catch (Exception e) {
                    return;
                }
                BlueprintRenderer renderer = BetterModel.inst().modelManager().renderer(name);
                if (renderer != null) {
                    renderer.create(target, value.modifier()).spawnNearby(loc);
                }
            });
        }
    }

    @Override
    @NotNull
    public ModelRotation rotation() {
        return new ModelRotation(0.0f, this.entity instanceof LivingEntity ? this.adapter.bodyYaw() : this.entity.getYaw());
    }

    @NotNull
    public static List<EntityTracker> trackers(@NotNull Predicate<EntityTracker> predicate) {
        return TRACKER_MAP.values().stream().filter(predicate).toList();
    }

    public EntityTracker(@NotNull Entity entity, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        super(instance, modifier);
        EntityAdapter entityAdapter;
        this.entity = entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entityAdapter = BetterModel.inst().nms().adapt(livingEntity);
        } else {
            entityAdapter = EntityAdapter.EMPTY;
        }
        this.adapter = entityAdapter.multiply(modifier.scale());
        instance.defaultPosition(new Vector3f(0.0f, -this.adapter.passengerPosition().y, 0.0f));
        instance.addAnimationMovementModifier(r -> r.getName().startsWith("h_"), a -> {
            if (a.rotation() != null && !this.isRunningSingleAnimation()) {
                a.rotation().add(-this.adapter.pitch(), Math.clamp(-this.adapter.yaw() + this.adapter.bodyYaw(), -45.0f, 45.0f), 0.0f);
            }
        });
        Supplier<Float> damageTickProvider = FunctionUtil.throttleTick(this.adapter::damageTick);
        Supplier<Boolean> walkSupplier = FunctionUtil.throttleTick(() -> this.adapter.onWalk() || (double)((Float)damageTickProvider.get()).floatValue() > 0.25 || instance.renderers().stream().anyMatch(e -> {
            HitBox hitBox = e.getHitBox();
            return hitBox != null && hitBox.onWalk();
        }));
        Supplier<Float> walkSpeedSupplier = FunctionUtil.throttleTick(modifier.damageEffect() ? () -> Float.valueOf(this.adapter.walkSpeed() + 4.0f * (float)Math.sqrt(((Float)damageTickProvider.get()).floatValue())) : () -> Float.valueOf(1.0f));
        instance.animateLoop("walk", new AnimationModifier(walkSupplier, 4, 0, walkSpeedSupplier));
        instance.animateLoop("idle_fly", new AnimationModifier(this.adapter::fly, 4, 0, 1.0f));
        instance.animateLoop("walk_fly", new AnimationModifier(() -> this.adapter.fly() && (Boolean)walkSupplier.get() != false, 4, 0, walkSpeedSupplier));
        Supplier<TrackerMovement> supplier = () -> new TrackerMovement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f((float)this.adapter.scale()), new Vector3f(0.0f, 0.0f, 0.0f));
        this.setMovement(supplier);
        TRACKER_MAP.put(entity.getUniqueId(), this);
        BetterModel.inst().scheduler().task(entity.getLocation(), () -> {
            entity.getPersistentDataContainer().set(TRACKING_ID, PersistentDataType.STRING, (Object)instance.getParent().getParent().name());
            if (!this.closed.get() && !this.forRemoval()) {
                this.createHitBox();
            }
        });
        instance.setup(this.getMovement().get());
        this.tick(t -> t.displays().forEach(d -> d.sync(this.adapter)));
        this.tick(t -> {
            BlueprintScript.ScriptReader reader = t.instance.getScriptProcessor().getCurrentReader();
            if (reader == null) {
                return;
            }
            EntityScript script = reader.script();
            if (script == null) {
                return;
            }
            BetterModel.inst().scheduler().task(entity.getLocation(), () -> script.accept(entity));
        });
        this.frame(t -> {
            if (this.damageTint.getAndDecrement() == 0L) {
                this.tint(0xFFFFFF);
            }
        });
    }

    @Override
    public double height() {
        return super.height() + (double)this.adapter.passengerPosition().y;
    }

    public void createHitBox() {
        this.createHitBox(e -> e.getName().contains("hitbox") || e.getName().startsWith("b_") || e.getGroup().getMountController().canMount());
    }

    public void createHitBox(@NotNull Predicate<RenderedEntity> predicate) {
        this.createHitBox(predicate, HitBoxListener.EMPTY);
    }

    public void createHitBox(@NotNull Predicate<RenderedEntity> predicate, @NotNull HitBoxListener listener) {
        this.instance.createHitBox(this.adapter, predicate, listener);
    }

    public int damageTintValue() {
        return this.damageTintValue.get();
    }

    public void damageTintValue(int tint) {
        this.damageTintValue.set(tint);
    }

    public void damageTint() {
        if (!this.modifier().damageEffect()) {
            return;
        }
        long get = this.damageTint.get();
        if (get <= 0L && this.damageTint.compareAndSet(get, 50L)) {
            this.tint(this.damageTintValue.get());
        }
    }

    public void forRemoval(boolean removal) {
        this.forRemoval.set(removal);
    }

    public boolean forRemoval() {
        return this.forRemoval.get();
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
        this.instance.allPlayer().forEach(p -> p.endTrack(this));
        super.close();
        TRACKER_MAP.remove(this.entity.getUniqueId());
        BetterModel.inst().scheduler().task(this.entity.getLocation(), () -> this.entity.getPersistentDataContainer().remove(TRACKING_ID));
    }

    @Override
    @NotNull
    public Location location() {
        return this.entity.getLocation();
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.entity.getUniqueId();
    }

    public boolean autoSpawn() {
        return this.autoSpawn.get();
    }

    public void autoSpawn(boolean spawn) {
        this.autoSpawn.set(spawn);
    }

    public void spawnNearby(@NotNull Location location) {
        Predicate<Player> filter = this.instance.spawnFilter();
        for (Entity e : location.getWorld().getNearbyEntities(location, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE)) {
            Player player;
            if (!(e instanceof Player) || !filter.test(player = (Player)e)) continue;
            this.spawn(player);
        }
    }

    public void spawn(@NotNull Player player) {
        BetterModel.inst().nms().hide(player, this.entity);
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.spawn(player, bundler);
        BetterModel.inst().nms().mount(this, bundler);
        bundler.send(player);
        PlayerChannelHandler handler2 = BetterModel.inst().playerManager().player(player.getUniqueId());
        if (handler2 != null) {
            handler2.startTrack(this);
        }
    }

    @Override
    public void remove(@NotNull Player player) {
        super.remove(player);
        PlayerChannelHandler handler2 = BetterModel.inst().playerManager().player(player.getUniqueId());
        if (handler2 != null) {
            handler2.endTrack(this);
        }
    }

    public void refresh() {
        this.instance.createHitBox(this.adapter, r -> r.getHitBox() != null, null);
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        BetterModel.inst().nms().mount(this, bundler);
        if (!bundler.isEmpty()) {
            this.viewedPlayer().forEach(bundler::send);
        }
    }

    @NotNull
    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public AtomicBoolean getClosed() {
        return this.closed;
    }

    @Generated
    public AtomicBoolean getForRemoval() {
        return this.forRemoval;
    }

    @Generated
    public AtomicBoolean getAutoSpawn() {
        return this.autoSpawn;
    }

    @Generated
    public AtomicInteger getDamageTintValue() {
        return this.damageTintValue;
    }

    @Generated
    public AtomicLong getDamageTint() {
        return this.damageTint;
    }

    @NotNull
    @Generated
    public EntityAdapter getAdapter() {
        return this.adapter;
    }
}

