/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final JsonDeserializer<ModelChildren> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new ModelUUID(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonArray children = json.getAsJsonObject().getAsJsonArray("children");
            return new ModelOutliner((ModelGroup)context.deserialize(json, ModelGroup.class), children.asList().stream().map(child -> (ModelChildren)context.deserialize(child, ModelChildren.class)).toList());
        }
        throw new RuntimeException();
    };

    @NotNull
    public BlueprintElement toBlueprint(@NotNull ModelLoadContext var1);

    @NotNull
    public Stream<ModelChildren> flatten();

    @NotNull
    public String uuid();

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            return Objects.requireNonNull(context.elements.get(this.uuid())).toBlueprint();
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.of(this);
        }
    }

    public record ModelOutliner(@NotNull ModelGroup group, @NotNull @Unmodifiable List<ModelChildren> children) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            List<BlueprintElement> child = CollectionUtil.mapToList(this.children, c2 -> c2.toBlueprint(context));
            List<BlueprintElement.Cube> filtered = CollectionUtil.filterIsInstance(child, BlueprintElement.Cube.class).toList();
            ModelGroup selectedGroup = context.groups.getOrDefault(this.uuid(), this.group);
            return new BlueprintElement.Group(UUID.fromString(selectedGroup.uuid()), BoneTagRegistry.parse(selectedGroup.name()), selectedGroup.origin(), selectedGroup.rotation().invertXZ(), child, filtered.isEmpty() ? selectedGroup.visibility() : filtered.stream().anyMatch(BlueprintElement.Cube::visibility));
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(ModelChildren::flatten));
        }

        @Override
        @NotNull
        public String uuid() {
            return this.group.uuid();
        }
    }
}

