/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser;

import java.util.ArrayList;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitCaptionKeys;
import kr.toxicity.model.shaded.org.incendo.cloud.caption.CaptionVariable;
import kr.toxicity.model.shaded.org.incendo.cloud.component.CommandComponent;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandContext;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandInput;
import kr.toxicity.model.shaded.org.incendo.cloud.exception.parsing.ParserException;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ParserDescriptor;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.apiguardian.api.API;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EnchantmentParser<C>
implements ArgumentParser<C, Enchantment>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Enchantment> enchantmentParser() {
        return ParserDescriptor.of(new EnchantmentParser<C>(), Enchantment.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, Enchantment> enchantmentComponent() {
        return CommandComponent.builder().parser(EnchantmentParser.enchantmentParser());
    }

    public @NonNull ArgumentParseResult<Enchantment> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        NamespacedKey key;
        String input = commandInput.peekString();
        try {
            key = input.contains(":") ? new NamespacedKey(commandInput.readUntilAndSkip(':'), commandInput.readString()) : NamespacedKey.minecraft((String)commandInput.readString());
        }
        catch (Exception ex) {
            return ArgumentParseResult.failure((Throwable)((Object)new EnchantmentParseException(input, commandContext)));
        }
        Enchantment enchantment = Enchantment.getByKey((NamespacedKey)key);
        if (enchantment == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new EnchantmentParseException(input, commandContext)));
        }
        return ArgumentParseResult.success((Object)enchantment);
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        ArrayList<String> completions = new ArrayList<String>();
        for (Enchantment value : Enchantment.values()) {
            if (value.getKey().getNamespace().equals("minecraft")) {
                completions.add(value.getKey().getKey());
                continue;
            }
            completions.add(value.getKey().toString());
        }
        return completions;
    }

    public static final class EnchantmentParseException
    extends ParserException {
        private final String input;

        public EnchantmentParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(EnchantmentParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_ENCHANTMENT, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

