/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintJson;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.pack.PackObfuscator;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.PackUtil;
import kr.toxicity.model.api.util.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public sealed interface BlueprintChildren {

    public record BlueprintElement(@NotNull ModelElement element) implements BlueprintChildren
    {
        @NotNull
        private Float3 identifierDegree() {
            return MathUtil.identifier(this.element.rotation());
        }

        @NotNull
        private static Float3 centralize(@NotNull Float3 target, @NotNull Float3 groupOrigin, float scale2) {
            return target.minus(groupOrigin).div(scale2);
        }

        @NotNull
        private static Float3 deltaPosition(@NotNull Float3 target, @NotNull Quaternionf quaternionf) {
            return target.rotate(quaternionf).minus(target);
        }

        @NotNull
        private JsonObject buildJson(int tint, float scale2, @NotNull ModelBlueprint parent, @NotNull BlueprintGroup group, @NotNull Float3 identifier) {
            Quaternionf qua = MathUtil.toQuaternion(identifier.toVector()).invert();
            Float3 centerOrigin = BlueprintElement.centralize(this.element.origin(), group.origin, scale2);
            Float3 groupDelta = BlueprintElement.deltaPosition(centerOrigin, qua);
            Float3 inflate = new Float3(this.element.inflate() / scale2);
            return JsonObjectBuilder.builder().jsonArray("from", BlueprintElement.centralize(this.element.from(), group.origin, scale2).plus(groupDelta).plus(Float3.CENTER).minus(inflate).toJson()).jsonArray("to", BlueprintElement.centralize(this.element.to(), group.origin, scale2).plus(groupDelta).plus(Float3.CENTER).plus(inflate).toJson()).jsonObject("faces", Objects.requireNonNull(this.element.faces()).toJson(parent, tint)).jsonObject("rotation", (JsonObject)Optional.of(this.element.rotation().minus(identifier)).filter(r -> !Float3.ZERO.equals(r)).map(rot -> {
                JsonObject rotation2 = this.getRotation((Float3)rot);
                rotation2.add("origin", (JsonElement)centerOrigin.plus(groupDelta).plus(Float3.CENTER).toJson());
                return rotation2;
            }).orElse(null)).build();
        }

        @NotNull
        private JsonObject getRotation(@NotNull Float3 rot) {
            JsonObject rotation2 = new JsonObject();
            if (Math.abs(rot.x()) > 0.0f) {
                rotation2.addProperty("angle", (Number)Float.valueOf(rot.x()));
                rotation2.addProperty("axis", "x");
            } else if (Math.abs(rot.y()) > 0.0f) {
                rotation2.addProperty("angle", (Number)Float.valueOf(rot.y()));
                rotation2.addProperty("axis", "y");
            } else if (Math.abs(rot.z()) > 0.0f) {
                rotation2.addProperty("angle", (Number)Float.valueOf(rot.z()));
                rotation2.addProperty("axis", "z");
            }
            return rotation2;
        }
    }

    public record BlueprintGroup(@NotNull BoneName name, @NotNull Float3 origin, @NotNull Float3 rotation, @NotNull List<BlueprintChildren> children, boolean visibility) implements BlueprintChildren
    {
        @NotNull
        private final Float3 origin;

        @NotNull
        public Float3 origin() {
            return this.origin.invertXZ();
        }

        @NotNull
        private String jsonName(@NotNull ModelBlueprint parent) {
            return PackUtil.toPackName(parent.name() + "_" + this.name.rawName());
        }

        @Nullable
        public BlueprintJson buildLegacyJson(boolean skipLog, @NotNull PackObfuscator.Pair obfuscator, @NotNull ModelBlueprint parent) {
            Predicate<BlueprintElement> filter = element -> MathUtil.checkValidDegree(element.identifierDegree());
            if (!skipLog) {
                filter = CollectionUtil.filterWithWarning(filter, element -> "The model " + parent.name() + "'s cube \"" + element.element.name() + "\" has an invalid rotation which does not supported in legacy client (<=1.21.3) " + String.valueOf(element.element.rotation()));
            }
            return this.buildJson(-2, 1, this.scale(), obfuscator, parent, Float3.ZERO, CollectionUtil.filterIsInstance(this.children, BlueprintElement.class).filter(filter));
        }

        @Nullable
        public @Unmodifiable List<BlueprintJson> buildModernJson(@NotNull PackObfuscator.Pair obfuscator, @NotNull ModelBlueprint parent) {
            float scale2 = this.scale();
            List<BlueprintJson> list = CollectionUtil.mapIndexed(CollectionUtil.group(CollectionUtil.filterIsInstance(this.children, BlueprintElement.class), BlueprintElement::identifierDegree), (i, entry) -> this.buildJson(0, i + 1, scale2, obfuscator, parent, (Float3)entry.getKey(), ((List)entry.getValue()).stream())).filter(Objects::nonNull).toList();
            return list.isEmpty() ? null : list;
        }

        @Nullable
        private BlueprintJson buildJson(int tint, int number, float scale2, @NotNull PackObfuscator.Pair obfuscator, @NotNull ModelBlueprint parent, @NotNull Float3 identifier, @NotNull Stream<BlueprintElement> cubes) {
            if (parent.textures().isEmpty()) {
                return null;
            }
            List<BlueprintElement> cubeElement = cubes.filter(c2 -> c2.element.hasTexture()).toList();
            if (cubeElement.isEmpty()) {
                return null;
            }
            return new BlueprintJson(obfuscator.models().obfuscate(this.jsonName(parent) + "_" + number), (JsonElement)JsonObjectBuilder.builder().jsonObject("textures", textures -> {
                int index = 0;
                for (BlueprintTexture texture : parent.textures()) {
                    textures.property(Integer.toString(index++), texture.packNamespace(obfuscator.textures(), parent.name()));
                }
                textures.property("particle", parent.textures().getFirst().packNamespace(obfuscator.textures(), parent.name()));
            }).jsonArray("elements", CollectionUtil.mapToJson(cubeElement, cube -> cube.buildJson(tint, scale2, parent, this, identifier))).jsonObject("display", display -> display.jsonObject("fixed", fixed -> {
                if (!identifier.equals(Float3.ZERO)) {
                    fixed.jsonArray("rotation", identifier.convertToMinecraftDegree().toJson());
                }
            })).build());
        }

        public float scale() {
            return (float)CollectionUtil.filterIsInstance(this.children, BlueprintElement.class).mapToDouble(e -> e.element.max(this.origin) / 16.0f).max().orElse(1.0);
        }

        @Nullable
        public NamedBoundingBox hitBox() {
            return CollectionUtil.filterIsInstance(this.children, BlueprintElement.class).map(be -> {
                ModelElement element = be.element;
                Vector3f from = element.from().minus(this.origin).toBlockScale().toVector();
                Vector3f to = element.to().minus(this.origin).toBlockScale().toVector();
                return ModelBoundingBox.of(from.x, from.y, from.z, to.x, to.y, to.z).invert();
            }).max(Comparator.comparingDouble(ModelBoundingBox::length)).map(max -> new NamedBoundingBox(this.name, (ModelBoundingBox)max)).orElse(null);
        }
    }
}

