/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class VoidTracker
extends Tracker {
    private Location location;
    private final UUID uuid;

    public VoidTracker(@NotNull UUID uuid, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier, @NotNull Location location) {
        super(instance, modifier);
        this.uuid = uuid;
        this.location = location;
        instance.setup(this.getMovement().get());
    }

    public void location(Location location) {
        this.location = Objects.requireNonNull(location, "location");
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.instance.teleport(location, bundler);
        if (!bundler.isEmpty()) {
            for (Player player : this.viewedPlayer()) {
                bundler.send(player);
            }
        }
    }

    @Override
    @NotNull
    public ModelRotation rotation() {
        return new ModelRotation(0.0f, this.location.getYaw());
    }

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    public void spawn(@NotNull Player player) {
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.spawn(player, bundler);
        bundler.send(player);
    }
}

