/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import kr.toxicity.model.api.BetterModel;
import org.jetbrains.annotations.NotNull;

public final class LogUtil {
    private LogUtil() {
        throw new RuntimeException();
    }

    public static void handleException(@NotNull String message, @NotNull Throwable throwable) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(message);
        list.add("Reason: " + throwable.getMessage());
        if (BetterModel.inst().configManager().debug().exception()) {
            list.add("Stack trace:");
            try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                 PrintStream print = new PrintStream(byteArray);){
                throwable.printStackTrace(print);
                list.add(byteArray.toString(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                list.add("Unknown");
            }
        }
        BetterModel.inst().logger().warn((String[])list.toArray(String[]::new));
    }
}

