/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.util.VectorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record BlueprintAnimation(@NotNull String name, @NotNull AnimationIterator.Type loop, float length, boolean override, @NotNull @Unmodifiable Map<BoneName, BlueprintAnimator> animator, @NotNull BlueprintScript script, @NotNull List<AnimationMovement> emptyAnimator) {
    @NotNull
    public static BlueprintAnimation from(@NotNull ModelAnimation animation) {
        HashMap<BoneName, BlueprintAnimator.AnimatorData> map = new HashMap<BoneName, BlueprintAnimator.AnimatorData>();
        BlueprintScript blueprintScript = BlueprintScript.emptyOf(animation);
        Map<String, ModelAnimator> animator = animation.animators();
        for (Map.Entry<String, ModelAnimator> entry : animator.entrySet()) {
            String name = entry.getValue().name();
            if (name == null) continue;
            BlueprintAnimator.Builder builder = new BlueprintAnimator.Builder(animation.length());
            ArrayList<ModelKeyframe> frameList = new ArrayList<ModelKeyframe>(entry.getValue().keyframes());
            frameList.sort(Comparator.naturalOrder());
            for (ModelKeyframe keyframe : frameList) {
                builder.addFrame(keyframe);
            }
            if (entry.getKey().equals("effects")) {
                blueprintScript = BlueprintScript.from(animation, entry.getValue());
                continue;
            }
            map.put(BoneTagRegistry.parse(name), builder.build(name));
        }
        Map<BoneName, BlueprintAnimator> newMap = BlueprintAnimation.newMap(map);
        return new BlueprintAnimation(animation.name(), animation.loop(), animation.length(), animation.override(), newMap, blueprintScript, newMap.isEmpty() ? List.of(new AnimationMovement(0.0f, null, null, null)) : newMap.values().iterator().next().keyFrame().stream().map(a2 -> new AnimationMovement(a2.time(), null, null, null)).toList());
    }

    @NotNull
    private static Map<BoneName, BlueprintAnimator> newMap(@NotNull Map<BoneName, BlueprintAnimator.AnimatorData> oldMap) {
        HashMap<BoneName, BlueprintAnimator> newMap = new HashMap<BoneName, BlueprintAnimator>();
        FloatAVLTreeSet floatSet = new FloatAVLTreeSet((Comparator)FloatComparators.NATURAL_COMPARATOR);
        oldMap.values().forEach(arg_0 -> BlueprintAnimation.lambda$newMap$3((FloatSet)floatSet, arg_0));
        for (Map.Entry<BoneName, BlueprintAnimator.AnimatorData> entry : oldMap.entrySet()) {
            List<AnimationMovement> list = BlueprintAnimation.getAnimationMovements((FloatSet)floatSet, entry);
            newMap.put(entry.getKey(), new BlueprintAnimator(entry.getValue().name(), list));
        }
        return newMap;
    }

    @NotNull
    private static List<AnimationMovement> getAnimationMovements(@NotNull FloatSet floatSet, @NotNull Map.Entry<BoneName, BlueprintAnimator.AnimatorData> entry) {
        List<AnimationPoint> frame = entry.getValue().points();
        if (frame.isEmpty()) {
            return Collections.emptyList();
        }
        List<AnimationMovement> list = VectorUtil.putAnimationPoint(frame, (FloatCollection)floatSet).stream().map(AnimationPoint::toMovement).collect(Collectors.toList());
        return BlueprintAnimation.processFrame(list);
    }

    @NotNull
    private static List<AnimationMovement> processFrame(@NotNull List<AnimationMovement> target) {
        if (target.size() <= 1) {
            return target;
        }
        ArrayList<AnimationMovement> list = new ArrayList<AnimationMovement>();
        list.add(target.getFirst());
        for (int i = 1; i < target.size(); ++i) {
            AnimationMovement get = target.get(i);
            list.add(get.time(get.time() - target.get(i - 1).time()));
        }
        return list;
    }

    @NotNull
    public AnimationIterator emptyIterator(@NotNull AnimationIterator.Type type) {
        return type.create(this.emptyAnimator);
    }

    private static /* synthetic */ void lambda$newMap$3(FloatSet floatSet, BlueprintAnimator.AnimatorData a2) {
        a2.points().stream().mapToDouble(t -> t.position().time()).forEach(d2 -> floatSet.add((float)d2));
    }
}

