/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.ConfigManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.manager.PlayerManagerImpl;
import kr.toxicity.model.manager.SkinManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00020\f*\u00020!H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkr/toxicity/model/manager/PlayerManagerImpl;", "Lkr/toxicity/model/api/manager/PlayerManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/model/api/nms/PlayerChannelHandler;", "renderMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "start", "", "register", "Lorg/bukkit/entity/Player;", "reload", "info", "Lkr/toxicity/model/api/manager/ReloadInfo;", "limbs", "", "limb", "name", "animate", "", "player", "model", "animation", "modifier", "Lkr/toxicity/model/api/animation/AnimationModifier;", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "uuid", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n808#2,11:112\n1193#2,2:123\n1267#2,4:125\n808#2,11:129\n1193#2,2:140\n1267#2,4:142\n*S KotlinDebug\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n*L\n103#1:112,11\n104#1:123,2\n104#1:125,4\n96#1:129,11\n97#1:140,2\n97#1:142,4\n*E\n"})
public final class PlayerManagerImpl
implements PlayerManager,
GlobalManagerImpl {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, ModelRenderer> renderMap = new HashMap();

    private PlayerManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void join(PlayerJoinEvent $this$join) {
                Intrinsics.checkNotNullParameter($this$join, "<this>");
                if ($this$join.getPlayer().isOnline()) {
                    Object object;
                    PlayerJoinEvent playerJoinEvent = $this$join;
                    try {
                        PlayerJoinEvent $this$join_u24lambda_u240 = playerJoinEvent;
                        boolean bl = false;
                        Player player = $this$join_u24lambda_u240.getPlayer();
                        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                        object = Result.constructor-impl(PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    PluginsKt.handleFailure(object, () -> start.1.join$lambda$1($this$join));
                }
            }

            @EventHandler
            public final void change(PlayerChangedWorldEvent $this$change) {
                Intrinsics.checkNotNullParameter($this$change, "<this>");
                if ($this$change.getPlayer().isOnline()) {
                    Object object;
                    PlayerChangedWorldEvent playerChangedWorldEvent = $this$change;
                    try {
                        PlayerChangedWorldEvent $this$change_u24lambda_u242 = playerChangedWorldEvent;
                        boolean bl = false;
                        Player player = $this$change_u24lambda_u242.getPlayer();
                        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                        PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player).unregisterAll();
                        object = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    PluginsKt.handleFailure(object, () -> start.1.change$lambda$3($this$change));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                Intrinsics.checkNotNullParameter($this$quit, "<this>");
                PlayerChannelHandler playerChannelHandler = (PlayerChannelHandler)PlayerManagerImpl.access$getPlayerMap$p().remove($this$quit.getPlayer().getUniqueId());
                if (playerChannelHandler != null) {
                    AutoCloseable autoCloseable = playerChannelHandler;
                    Throwable throwable = null;
                    try {
                        PlayerChannelHandler it = (PlayerChannelHandler)autoCloseable;
                        boolean bl = false;
                        GameProfile gameProfile = it.profile();
                        Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
                        Boolean bl2 = SkinManagerImpl.INSTANCE.removeCache(gameProfile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
            }

            private static final String join$lambda$1(PlayerJoinEvent $this_join) {
                return "Unable to load " + $this_join.getPlayer().getName() + "'s data.";
            }

            private static final String change$lambda$3(PlayerChangedWorldEvent $this_change) {
                return "Unable to refresh " + $this_change.getPlayer().getName() + "'s data.";
            }
        });
    }

    private final PlayerChannelHandler register(Player $this$register) {
        PlayerChannelHandler playerChannelHandler;
        PlayerChannelHandler $this$register_u24lambda_u242 = playerChannelHandler = playerMap.computeIfAbsent($this$register.getUniqueId(), arg_0 -> PlayerManagerImpl.register$lambda$1(arg_0 -> PlayerManagerImpl.register$lambda$0($this$register, arg_0), arg_0));
        boolean bl = false;
        if (SkinManagerImpl.INSTANCE.supported()) {
            GameProfile gameProfile = $this$register_u24lambda_u242.profile();
            Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
            SkinManagerImpl.INSTANCE.getOrRequest(gameProfile);
        }
        PlayerChannelHandler playerChannelHandler2 = playerChannelHandler;
        Intrinsics.checkNotNullExpressionValue(playerChannelHandler2, "apply(...)");
        return playerChannelHandler2;
    }

    @Override
    public void reload(@NotNull ReloadInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
        renderMap.clear();
        if (ConfigManagerImpl.INSTANCE.module().playerAnimation()) {
            kr.toxicity.model.util.FilesKt.forEachAllFolder(kr.toxicity.model.util.FilesKt.getOrCreateDirectory(PluginsKt.getDATA_FOLDER(), "players", PlayerManagerImpl::reload$lambda$3), PlayerManagerImpl::reload$lambda$4);
        }
    }

    @Override
    @NotNull
    public List<ModelRenderer> limbs() {
        Collection<ModelRenderer> collection = renderMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @Nullable
    public ModelRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return renderMap.get(name);
    }

    @Override
    public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(animation, "animation");
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        ModelRenderer modelRenderer = renderMap.get(model);
        if (modelRenderer != null) {
            ModelRenderer it = modelRenderer;
            boolean bl2 = false;
            EntityTracker entityTracker = it.getOrCreate((Entity)player);
            Intrinsics.checkNotNullExpressionValue(entityTracker, "getOrCreate(...)");
            EntityTracker create = entityTracker;
            boolean success = create.animate(animation, modifier, () -> PlayerManagerImpl.animate$lambda$6$lambda$5(create));
            if (!success) {
                create.close();
            }
            bl = success;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final ModelRenderer toRenderer(ModelBlueprint $this$toRenderer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<BlueprintChildren> list = $this$toRenderer.group();
        Intrinsics.checkNotNullExpressionValue(list, "group(...)");
        Iterable iterable = list;
        ModelBlueprint modelBlueprint = $this$toRenderer;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            Pair<BoneName, RendererGroup> pair = TuplesKt.to(it.boneName(), PlayerManagerImpl.toRenderer$parse(it, $this$toRenderer));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
        Map map2 = destination$iv$iv2;
        ModelBlueprint modelBlueprint2 = modelBlueprint;
        return new ModelRenderer(modelBlueprint2, map2, map);
    }

    @Override
    @Nullable
    public PlayerChannelHandler player(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return playerMap.get(uuid);
    }

    @Override
    @NotNull
    public PlayerChannelHandler player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.register(player);
    }

    @Override
    public void end() {
        GlobalManagerImpl.super.end();
    }

    private static final PlayerChannelHandler register$lambda$0(Player $this_register, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return PluginsKt.getPLUGIN().nms().inject($this_register);
    }

    private static final PlayerChannelHandler register$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerChannelHandler)$tmp0.invoke(p0);
    }

    private static final Unit reload$lambda$3(File folder) {
        Intrinsics.checkNotNullParameter(folder, "folder");
        kr.toxicity.model.util.FilesKt.addResourceAs(folder, "steve.bbmodel");
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$4(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(FilesKt.getExtension(it), "bbmodel")) {
            ModelBlueprint load = GsonsKt.toModel(it);
            ((Map)renderMap).put(load.name(), INSTANCE.toRenderer(load));
        }
        return Unit.INSTANCE;
    }

    private static final void animate$lambda$6$lambda$5(EntityTracker $create) {
        $create.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final RendererGroup toRenderer$parse(BlueprintChildren.BlueprintGroup $this$toRenderer_u24parse, ModelBlueprint $this_toRenderer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        BoneName boneName = $this$toRenderer_u24parse.boneName();
        float f = $this_toRenderer.scale();
        ItemStack itemStack = new ItemStack(Material.AIR);
        List<BlueprintChildren> list = $this$toRenderer_u24parse.children();
        Intrinsics.checkNotNullExpressionValue(list, "children(...)");
        Iterable iterable = list;
        BlueprintChildren.BlueprintGroup blueprintGroup = $this$toRenderer_u24parse;
        ItemStack itemStack2 = itemStack;
        float f2 = f;
        BoneName boneName2 = boneName;
        boolean $i$f$filterIsInstance = false;
        void var4_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            Pair<BoneName, RendererGroup> pair = TuplesKt.to(it.boneName(), PlayerManagerImpl.toRenderer$parse(it, $this_toRenderer));
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        NamedBoundingBox namedBoundingBox = $this$toRenderer_u24parse.hitBox();
        Object object2 = object;
        BlueprintChildren.BlueprintGroup blueprintGroup2 = blueprintGroup;
        ItemStack itemStack3 = itemStack2;
        float f3 = f2;
        BoneName boneName3 = boneName2;
        return new RendererGroup(boneName3, f3, itemStack3, blueprintGroup2, (Map<BoneName, RendererGroup>)object2, namedBoundingBox);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerMap$p() {
        return playerMap;
    }

    public static final /* synthetic */ PlayerChannelHandler access$register(PlayerManagerImpl $this, Player $receiver) {
        return $this.register($receiver);
    }
}

