/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.player;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kr.toxicity.model.api.player.PlayerSkinProvider;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.text.Charsets;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkr/toxicity/model/player/HttpPlayerSkinProvider;", "Lkr/toxicity/model/api/player/PlayerSkinProvider;", "<init>", "()V", "serializer", "Lcom/google/gson/Gson;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "provide", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/authlib/GameProfile;", "profile", "Profile", "core"})
public final class HttpPlayerSkinProvider
implements PlayerSkinProvider {
    private final Gson serializer = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), (Object)new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)PropertyMap.class), (Object)new PropertyMap.Serializer()).create();

    @Override
    @NotNull
    public CompletableFuture<GameProfile> provide(@NotNull GameProfile profile) {
        Intrinsics.checkNotNullParameter(profile, "profile");
        CompletableFuture completableFuture = PluginsKt.httpClient(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9(profile, this, arg_0)).orElse(arg_0 -> HttpPlayerSkinProvider.provide$lambda$10(profile, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "orElse(...)");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CompletionStage provide$lambda$9$lambda$1(HttpClient $this_httpClient, HttpResponse it) {
        JsonElement jsonElement;
        Closeable closeable = (Closeable)it.body();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull(stream);
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            jsonElement = JsonParser.parseReader((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        String uuid = jsonElement.getAsJsonObject().getAsJsonPrimitive("id").getAsString();
        return $this_httpClient.sendAsync(HttpRequest.newBuilder().GET().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid)).build(), HttpResponse.BodyHandlers.ofInputStream());
    }

    private static final CompletionStage provide$lambda$9$lambda$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final GameProfile provide$lambda$9$lambda$6(HttpPlayerSkinProvider this$0, HttpResponse it) {
        GameProfile gameProfile;
        Closeable closeable = (Closeable)it.body();
        Throwable throwable = null;
        try {
            GameProfile gameProfile2;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Gson gson = this$0.serializer;
            Intrinsics.checkNotNull(stream);
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            Profile p = (Profile)gson.fromJson((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), Profile.class);
            boolean bl2 = false;
            GameProfile $this$provide_u24lambda_u249_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = gameProfile2 = new GameProfile(p.getId(), p.getName());
            boolean bl3 = false;
            $this$provide_u24lambda_u249_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.getProperties().putAll((Multimap)p.getProperties());
            gameProfile = gameProfile2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return gameProfile;
    }

    private static final GameProfile provide$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
        return (GameProfile)$tmp0.invoke(p0);
    }

    private static final GameProfile provide$lambda$9$lambda$8(GameProfile $profile, Throwable it) {
        Intrinsics.checkNotNull(it);
        PluginsKt.handleException(it, "Unable to get " + $profile.getName() + "'s skin data.");
        return null;
    }

    private static final CompletableFuture provide$lambda$9(GameProfile $profile, HttpPlayerSkinProvider this$0, HttpClient $this$httpClient) {
        Intrinsics.checkNotNullParameter($this$httpClient, "$this$httpClient");
        return ((CompletableFuture)((CompletableFuture)$this$httpClient.sendAsync(HttpRequest.newBuilder().GET().uri(URI.create("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + $profile.getName())).build(), HttpResponse.BodyHandlers.ofInputStream()).thenCompose(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9$lambda$2(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9$lambda$1($this$httpClient, arg_0), arg_0))).thenApply(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9$lambda$7(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9$lambda$6(this$0, arg_0), arg_0))).exceptionally(arg_0 -> HttpPlayerSkinProvider.provide$lambda$9$lambda$8($profile, arg_0));
    }

    private static final CompletableFuture provide$lambda$10(GameProfile $profile, Exception it) {
        Intrinsics.checkNotNull(it);
        PluginsKt.handleException(it, "Unable to get " + $profile.getName() + "'s user data.");
        return CompletableFuture.completedFuture(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/model/player/HttpPlayerSkinProvider$Profile;", "", "id", "Ljava/util/UUID;", "name", "", "properties", "Lcom/mojang/authlib/properties/PropertyMap;", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Lcom/mojang/authlib/properties/PropertyMap;)V", "getId", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "getProperties", "()Lcom/mojang/authlib/properties/PropertyMap;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class Profile {
        @NotNull
        private final UUID id;
        @NotNull
        private final String name;
        @NotNull
        private final PropertyMap properties;

        public Profile(@NotNull UUID id, @NotNull String name, @NotNull PropertyMap properties) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(properties, "properties");
            this.id = id;
            this.name = name;
            this.properties = properties;
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PropertyMap getProperties() {
            return this.properties;
        }

        @NotNull
        public final UUID component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final PropertyMap component3() {
            return this.properties;
        }

        @NotNull
        public final Profile copy(@NotNull UUID id, @NotNull String name, @NotNull PropertyMap properties) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(properties, "properties");
            return new Profile(id, name, properties);
        }

        public static /* synthetic */ Profile copy$default(Profile profile, UUID uUID, String string, PropertyMap propertyMap, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = profile.id;
            }
            if ((n & 2) != 0) {
                string = profile.name;
            }
            if ((n & 4) != 0) {
                propertyMap = profile.properties;
            }
            return profile.copy(uUID, string, propertyMap);
        }

        @NotNull
        public String toString() {
            return "Profile(id=" + this.id + ", name=" + this.name + ", properties=" + this.properties + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.properties.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Profile)) {
                return false;
            }
            Profile profile = (Profile)other;
            if (!Intrinsics.areEqual(this.id, profile.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, profile.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.properties, profile.properties);
        }
    }
}

