/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateDummyTrackerEvent;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class DummyTracker
extends Tracker {
    private Location location;
    private UUID uuid = UUID.randomUUID();

    public DummyTracker(@NotNull Location location, @NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        super(pipeline, modifier);
        this.location = location;
        pipeline.animate("spawn");
        pipeline.scale(() -> this.scaler().scale(this));
        this.rotation(() -> new ModelRotation(this.location.getPitch(), this.location.getYaw()));
        pipeline.defaultPosition(FunctionUtil.asSupplier(new Vector3f()));
        preUpdateConsumer.accept(this);
        this.update();
        EventUtil.call(new CreateDummyTrackerEvent(this));
    }

    public void location(@NotNull Location location) {
        if (this.location.equals((Object)location)) {
            return;
        }
        this.location = Objects.requireNonNull(location, "location");
        PacketBundler bundler = this.pipeline.createBundler();
        this.pipeline.teleport(location, bundler);
        if (!bundler.isEmpty()) {
            this.pipeline.allPlayer().map(PlayerChannelHandler::player).forEach(bundler::send);
        }
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    public void spawn(@NotNull Player player) {
        PacketBundler bundler = this.pipeline.createBundler();
        this.spawn(player, bundler);
        bundler.send(player);
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

