/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.PlayerTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface RenderSource<T extends Tracker> {
    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull Location location) {
        return new BaseDummy(location);
    }

    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull Location location, @NotNull GameProfile profile, boolean slim) {
        return new ProfiledDummy(location, profile, slim);
    }

    @ApiStatus.Internal
    @NotNull
    public static Entity of(@NotNull org.bukkit.entity.Entity entity) {
        Record record;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            record = new BasePlayer(player);
        } else {
            record = new BaseEntity(entity);
        }
        return record;
    }

    @NotNull
    public Location location();

    public T create(@NotNull RenderPipeline var1, @NotNull TrackerModifier var2, @NotNull Consumer<T> var3);

    public record BaseDummy(@NotNull Location location) implements Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }
    }

    public record ProfiledDummy(@NotNull Location location, @NotNull GameProfile profile, boolean slim) implements Profiled,
    Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }
    }

    public static final class BasePlayer
    extends Record
    implements Entity,
    Profiled {
        @NotNull
        private final Player entity;

        public BasePlayer(@NotNull Player entity) {
            this.entity = entity;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate((org.bukkit.entity.Entity)this.entity).create(pipeline.name(), r -> new PlayerTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate((org.bukkit.entity.Entity)this.entity).getOrCreate(name, r -> new PlayerTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.getLocation();
        }

        @Override
        @NotNull
        public GameProfile profile() {
            return BetterModel.plugin().nms().profile(this.entity);
        }

        @Override
        public boolean slim() {
            PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(this.entity.getUniqueId());
            return channel != null && channel.isSlim();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this, o);
        }

        @NotNull
        public Player entity() {
            return this.entity;
        }
    }

    public record BaseEntity(@NotNull org.bukkit.entity.Entity entity) implements Entity
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new EntityTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new EntityTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public Location location() {
            return this.entity.getLocation();
        }
    }

    public static sealed interface Profiled
    permits ProfiledDummy, BasePlayer {
        @NotNull
        public GameProfile profile();

        public boolean slim();
    }

    public static sealed interface Dummy
    extends RenderSource<DummyTracker>
    permits BaseDummy, ProfiledDummy {
    }

    public static sealed interface Entity
    extends RenderSource<EntityTracker>
    permits BaseEntity, BasePlayer {
        @NotNull
        public org.bukkit.entity.Entity entity();

        @NotNull
        public EntityTracker getOrCreate(@NotNull String var1, @NotNull Supplier<RenderPipeline> var2, @NotNull TrackerModifier var3, @NotNull Consumer<EntityTracker> var4);
    }
}

