/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.ModelRotator;
import kr.toxicity.model.api.tracker.ModelScaler;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TrackerData(@NotNull String id, @Nullable ModelScaler scaler, @Nullable ModelRotator rotator, @NotNull TrackerModifier modifier, @SerializedName(value="hide-option") @Nullable EntityHideOption hideOption, @SerializedName(value="mark-for-spawn") @Nullable Set<UUID> markForSpawn) {
    @Nullable
    private final ModelScaler scaler;
    @Nullable
    private final ModelRotator rotator;
    @SerializedName(value="hide-option")
    @Nullable
    private final EntityHideOption hideOption;
    @SerializedName(value="mark-for-spawn")
    @Nullable
    private final Set<UUID> markForSpawn;
    public static final Gson PARSER = new GsonBuilder().registerTypeAdapter(ModelScaler.class, (json, typeOfT, context) -> json.isJsonObject() ? ModelScaler.deserialize(json.getAsJsonObject()) : ModelScaler.defaultScaler()).registerTypeAdapter(ModelScaler.class, (src, typeOfSrc, context) -> src.serialize()).registerTypeAdapter(ModelRotator.class, (json, typeOfT, context) -> json.isJsonObject() ? ModelRotator.deserialize(json.getAsJsonObject()) : ModelRotator.YAW).registerTypeAdapter(ModelRotator.class, (src, typeOfSrc, context) -> src.serialize()).registerTypeAdapter(EntityHideOption.class, (json, typeOfT, context) -> json.isJsonArray() ? EntityHideOption.deserialize(json.getAsJsonArray()) : EntityHideOption.DEFAULT).registerTypeAdapter(EntityHideOption.class, (src, typeOfSrc, context) -> src.serialize()).registerTypeAdapter(UUID.class, (json, typeOfT, context) -> UUID.fromString(json.getAsString())).registerTypeAdapter(UUID.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.toString())).create();

    public void applyAs(@NotNull EntityTracker tracker) {
        tracker.markPlayerForSpawn(this.markForSpawn());
        tracker.hideOption(this.hideOption());
        tracker.scaler(this.scaler());
        tracker.rotator(this.rotator());
    }

    @NotNull
    public JsonElement serialize() {
        return PARSER.toJsonTree((Object)this);
    }

    @NotNull
    public static TrackerData deserialize(@NotNull JsonElement element) {
        return element.isJsonPrimitive() ? new TrackerData(element.getAsString(), ModelScaler.entity(), null, TrackerModifier.DEFAULT, null, null) : (TrackerData)PARSER.fromJson(element, TrackerData.class);
    }

    @NotNull
    public ModelScaler scaler() {
        return this.scaler != null ? this.scaler : ModelScaler.entity();
    }

    @NotNull
    public ModelRotator rotator() {
        return this.rotator != null ? this.rotator : ModelRotator.YAW;
    }

    @NotNull
    public EntityHideOption hideOption() {
        return this.hideOption != null ? this.hideOption : EntityHideOption.DEFAULT;
    }

    @NotNull
    public Set<UUID> markForSpawn() {
        return this.markForSpawn != null ? this.markForSpawn : Collections.emptySet();
    }

    @Override
    @NotNull
    public String toString() {
        return this.serialize().toString();
    }
}

