/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.config.DebugConfig;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LogUtil {
    private LogUtil() {
        throw new RuntimeException();
    }

    public static void handleException(@NotNull String message, @NotNull Throwable throwable) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(message);
        list.add("Reason: " + throwable.getMessage());
        if (BetterModel.config().debug().has(DebugConfig.DebugOption.EXCEPTION)) {
            list.add("Stack trace:");
            try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                 PrintStream print = new PrintStream(byteArray);){
                throwable.printStackTrace(print);
                list.add(byteArray.toString(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                list.add("Unknown");
            }
        } else {
            list.add("If you want to see the stack trace, set debug.exception to true in config.yml");
        }
        BetterModel.plugin().logger().warn((String[])list.toArray(String[]::new));
    }

    public static void debug(@NotNull DebugConfig.DebugOption option, @NotNull Supplier<String> log) {
        LogUtil.debug(option, () -> BetterModel.plugin().logger().info("DEBUG-" + String.valueOf((Object)option) + ": " + (String)log.get()));
    }

    public static void debug(@NotNull DebugConfig.DebugOption option, @NotNull Runnable runnable) {
        if (BetterModel.config().debug().has(option)) {
            runnable.run();
        }
    }
}

