/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Map;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.mount.MountController;
import kr.toxicity.model.api.mount.MountControllers;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RendererGroup {
    private final BoneName name;
    private final BlueprintChildren.BlueprintGroup parent;
    private final Vector3f position;
    private final Vector3f rotation;
    private final TransformedItemStack itemStack;
    private final @Unmodifiable Map<BoneName, RendererGroup> children;
    @Nullable
    private final NamedBoundingBox hitBox;
    @NotNull
    private final BoneItemMapper itemMapper;
    @NotNull
    private final MountController mountController;

    public RendererGroup(@NotNull BoneName name, float scale, @Nullable ItemStack itemStack, @NotNull BlueprintChildren.BlueprintGroup group, @NotNull Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox box) {
        this.name = name;
        this.itemMapper = name.toItemMapper();
        this.parent = group;
        this.children = children;
        this.itemStack = TransformedItemStack.of(new Vector3f(), new Vector3f(), new Vector3f(scale).div(4.0f), itemStack != null ? itemStack : new ItemStack(Material.AIR));
        this.position = group.origin().toBlockScale().toVector();
        this.hitBox = box;
        this.rotation = group.rotation().toVector();
        this.mountController = name.tagged(BoneTags.SEAT) ? BetterModel.config().defaultMountController() : (name.tagged(BoneTags.SUB_SEAT) ? MountControllers.NONE : MountControllers.INVALID);
    }

    @NotNull
    public RenderedBone create(@NotNull RenderSource<?> source, @NotNull TrackerModifier modifier) {
        return this.create(source, modifier, null);
    }

    @NotNull
    private RenderedBone create(@NotNull RenderSource<?> source, @NotNull TrackerModifier modifier, @Nullable RenderedBone parentBone) {
        return new RenderedBone(this, parentBone, source, new BoneMovement(parentBone != null ? this.position.sub((Vector3fc)parentBone.getGroup().position, new Vector3f()) : new Vector3f(), new Vector3f(1.0f), MathUtil.toQuaternion(this.rotation), this.rotation), modifier, parent -> CollectionUtil.mapValue(this.children, value -> value.create(source, modifier, (RenderedBone)parent)));
    }

    @NotNull
    public TransformedItemStack getItemStack() {
        return this.itemStack.copy();
    }

    @Generated
    public RendererGroup(BoneName name, BlueprintChildren.BlueprintGroup parent, Vector3f position, Vector3f rotation, TransformedItemStack itemStack, Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox hitBox, @NotNull BoneItemMapper itemMapper, @NotNull MountController mountController) {
        if (itemMapper == null) {
            throw new NullPointerException("itemMapper is marked non-null but is null");
        }
        if (mountController == null) {
            throw new NullPointerException("mountController is marked non-null but is null");
        }
        this.name = name;
        this.parent = parent;
        this.position = position;
        this.rotation = rotation;
        this.itemStack = itemStack;
        this.children = children;
        this.hitBox = hitBox;
        this.itemMapper = itemMapper;
        this.mountController = mountController;
    }

    @Generated
    public BoneName getName() {
        return this.name;
    }

    @Generated
    public BlueprintChildren.BlueprintGroup getParent() {
        return this.parent;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Map<BoneName, RendererGroup> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public NamedBoundingBox getHitBox() {
        return this.hitBox;
    }

    @NotNull
    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @NotNull
    @Generated
    public MountController getMountController() {
        return this.mountController;
    }
}

