/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateEntityTrackerEvent;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatConstantSupplier;
import kr.toxicity.model.api.util.function.FloatSupplier;
import kr.toxicity.model.api.util.lazy.LazyFloatProvider;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTracker
extends Tracker {
    private final EntityTrackerRegistry registry;
    private final AtomicInteger damageTintValue = new AtomicInteger(0xFF8080);
    private final AtomicLong damageTint = new AtomicLong(-1L);
    private final Set<UUID> markForSpawn = Collections.newSetFromMap(new ConcurrentHashMap());
    private final HeadRotationProperty headRotationProperty = new HeadRotationProperty();
    private EntityHideOption hideOption = EntityHideOption.DEFAULT;

    @ApiStatus.Internal
    public EntityTracker(@NotNull EntityTrackerRegistry registry, @NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        super(pipeline, modifier);
        this.registry = registry;
        Entity entity = registry.entity();
        EntityAdapter adapter = registry.adapter();
        FloatSupplier scale = FunctionUtil.throttleTickFloat(() -> this.scaler().scale(this));
        if (modifier.shadow()) {
            ModelDisplay shadow = BetterModel.plugin().nms().create(entity.getLocation());
            float baseScale = (float)pipeline.bones().stream().filter(b2 -> b2.getGroup().getParent().visibility()).map(b2 -> b2.getGroup().getHitBox()).filter(Objects::nonNull).mapToDouble(b2 -> Math.max(b2.box().x(), b2.box().z())).max().orElse(0.0);
            this.tick((t, s) -> {
                shadow.shadowRadius(scale.getAsFloat() * baseScale);
                shadow.sync(adapter);
                shadow.sendEntityData(s.getTickBundler());
                shadow.syncPosition(adapter, s.getTickBundler());
            });
            pipeline.spawnPacketHandler(shadow::spawn);
            pipeline.despawnPacketHandler(shadow::remove);
            pipeline.hidePacketHandler(b2 -> shadow.sendEntityData(false, (PacketBundler)b2));
            pipeline.showPacketHandler(shadow::sendEntityData);
        }
        pipeline.hideFilter(p -> !p.canSee(registry.entity()));
        pipeline.defaultPosition(FunctionUtil.throttleTick(() -> adapter.passengerPosition().mul(-1.0f)));
        pipeline.scale(scale);
        Function<Quaternionf, Quaternionf> headRotator = r -> r.mul((Quaternionfc)MathUtil.toQuaternion(this.headRotationProperty.get()));
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.NOT_SET, r -> r.getName().tagged(BoneTags.HEAD)), headRotator);
        pipeline.addRotationModifier(BonePredicate.of(BonePredicate.State.TRUE, r -> r.getName().tagged(BoneTags.HEAD_WITH_CHILDREN)), headRotator);
        FloatSupplier damageTickProvider = FunctionUtil.throttleTickFloat(adapter::damageTick);
        BooleanSupplier walkSupplier = FunctionUtil.throttleTickBoolean(() -> adapter.onWalk() || (double)damageTickProvider.getAsFloat() > 0.25 || pipeline.bones().stream().anyMatch(e -> {
            HitBox hitBox = e.getHitBox();
            return hitBox != null && hitBox.onWalk();
        }));
        FloatConstantSupplier walkSpeedSupplier = modifier.damageAnimation() ? FunctionUtil.throttleTickFloat(() -> adapter.walkSpeed() + 4.0f * (float)Math.sqrt(damageTickProvider.getAsFloat())) : FloatConstantSupplier.ONE;
        pipeline.animate("walk", new AnimationModifier(walkSupplier, 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        pipeline.animate("idle_fly", new AnimationModifier(adapter::fly, 6, 0, AnimationIterator.Type.LOOP, 1.0f));
        pipeline.animate("walk_fly", new AnimationModifier(() -> adapter.fly() && walkSupplier.getAsBoolean(), 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        pipeline.animate("spawn", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
        BetterModel.plugin().scheduler().task(entity, () -> {
            if (this.isClosed()) {
                return;
            }
            this.createHitBox();
        });
        this.tick((t, s) -> this.updateBaseEntity0());
        this.tick((t, s) -> {
            if (this.damageTint.getAndDecrement() == 0L) {
                this.tint(-1);
            }
        });
        this.rotation(() -> new ModelRotation(adapter.pitch(), entity instanceof LivingEntity ? adapter.bodyYaw() : adapter.yaw()));
        preUpdateConsumer.accept(this);
        this.update();
        EventUtil.call(new CreateEntityTrackerEvent(this));
    }

    private void createHitBox() {
        this.createHitBox(e -> e.getName().name().equals("hitbox") || e.getName().tagged(BoneTags.HITBOX) || e.getGroup().getMountController().canMount());
    }

    @Override
    @NotNull
    public ModelRotation rotation() {
        return this.registry.adapter().dead() ? this.pipeline.getRotation() : super.rotation();
    }

    private void createHitBox(@NotNull Predicate<RenderedBone> predicate) {
        this.createHitBox(predicate, HitBoxListener.EMPTY);
    }

    public void updateBaseEntity() {
        BetterModel.plugin().scheduler().asyncTaskLater(1L, () -> {
            this.updateBaseEntity0();
            this.forceUpdate(true);
        });
    }

    private void updateBaseEntity0() {
        this.displays().forEach(d -> d.sync(this.registry.adapter()));
    }

    @NotNull
    public EntityTrackerRegistry registry() {
        return this.registry;
    }

    public void createHitBox(@NotNull Predicate<RenderedBone> predicate, @NotNull HitBoxListener listener) {
        this.pipeline.createHitBox(this.registry.adapter(), predicate, listener);
    }

    public int damageTintValue() {
        return this.damageTintValue.get();
    }

    public void damageTintValue(int tint) {
        this.damageTintValue.set(tint);
    }

    public void damageTint() {
        if (!this.modifier().damageTint()) {
            return;
        }
        long get = this.damageTint.get();
        if (get <= 0L && this.damageTint.compareAndSet(get, 10L)) {
            this.task(() -> this.tint(this.damageTintValue()));
        }
    }

    @Override
    public void despawn() {
        if (this.registry.adapter().dead()) {
            this.close(Tracker.CloseReason.DESPAWN);
            return;
        }
        super.despawn();
    }

    @Override
    @NotNull
    public Location location() {
        return this.sourceEntity().getLocation();
    }

    @NotNull
    public Entity sourceEntity() {
        return this.registry.entity();
    }

    public void moveDuration(int duration) {
        this.pipeline.moveDuration(duration);
        this.forceUpdate(true);
    }

    public void cancelDamageTint() {
        this.damageTint.set(-1L);
    }

    @NotNull
    public HeadRotationProperty headRotationProperty() {
        return this.headRotationProperty;
    }

    @ApiStatus.Internal
    public void refresh() {
        this.updateBaseEntity0();
        BetterModel.plugin().scheduler().task(this.registry.entity(), () -> this.pipeline.createHitBox(this.registry.adapter(), r -> r.getHitBox() != null, null));
    }

    public boolean markPlayerForSpawn(@NotNull OfflinePlayer player) {
        return this.markForSpawn.add(player.getUniqueId());
    }

    public boolean markPlayerForSpawn(@NotNull Set<UUID> uuids) {
        return this.markForSpawn.addAll(uuids);
    }

    public boolean unmarkPlayerForSpawn(@NotNull OfflinePlayer player) {
        return this.markForSpawn.remove(player.getUniqueId());
    }

    @NotNull
    public TrackerData asTrackerData() {
        return new TrackerData(this.name(), this.scaler, this.rotator, this.modifier, this.hideOption, this.markForSpawn);
    }

    public boolean canBeSpawnedAt(@NotNull OfflinePlayer player) {
        return this.markForSpawn.isEmpty() || this.markForSpawn.contains(player.getUniqueId());
    }

    @NotNull
    public EntityHideOption hideOption() {
        return this.hideOption;
    }

    public void hideOption(@NotNull EntityHideOption hideOption) {
        this.hideOption = Objects.requireNonNull(hideOption);
    }

    public final class HeadRotationProperty
    implements Supplier<Vector3f> {
        private float rotationDelay = 150.0f;
        private float minRotation = -90.0f;
        private float maxRotation = 90.0f;
        private final Supplier<Vector3f> delegate = LazyFloatProvider.ofVector(10L, () -> this.rotationDelay, () -> new Vector3f(Math.clamp(EntityTracker.this.registry.adapter().pitch(), this.minRotation, this.maxRotation), Math.clamp(-EntityTracker.this.registry.adapter().yaw() + EntityTracker.this.registry.adapter().bodyYaw(), this.minRotation, this.maxRotation), 0.0f));

        private HeadRotationProperty() {
        }

        @Override
        @NotNull
        public Vector3f get() {
            return this.delegate.get();
        }

        public synchronized void delay(float delay) {
            this.rotationDelay = delay;
        }

        public void minRotation(float min) {
            this.rotation(min, this.maxRotation);
        }

        public void maxRotation(float max) {
            this.rotation(this.minRotation, max);
        }

        public synchronized void rotation(float min, float max) {
            this.minRotation = Math.min(min, max);
            this.maxRotation = Math.max(min, max);
        }
    }
}

