/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.function.Function;
import kr.toxicity.model.api.util.ItemUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record TransformedItemStack(@NotNull Vector3f position, @NotNull Vector3f offset, @NotNull Vector3f scale, @NotNull ItemStack itemStack) {
    @NotNull
    public static TransformedItemStack empty() {
        return TransformedItemStack.of(new ItemStack(Material.AIR));
    }

    @NotNull
    public static TransformedItemStack of(@NotNull ItemStack itemStack) {
        return TransformedItemStack.of(new Vector3f(), new Vector3f(), new Vector3f(1.0f), itemStack);
    }

    @NotNull
    public static TransformedItemStack of(@NotNull Vector3f position, @NotNull Vector3f offset, @NotNull Vector3f scale, @NotNull ItemStack itemStack) {
        return new TransformedItemStack(position, offset, scale, itemStack);
    }

    @NotNull
    public TransformedItemStack asAir() {
        return TransformedItemStack.of(this.position, this.offset, this.scale, new ItemStack(Material.AIR));
    }

    @NotNull
    public TransformedItemStack modify(@NotNull Function<ItemStack, ItemStack> mapper) {
        return TransformedItemStack.of(this.position, this.offset, this.scale, mapper.apply(this.itemStack.clone()));
    }

    public boolean isAir() {
        return ItemUtil.isEmpty(this.itemStack);
    }

    @NotNull
    public TransformedItemStack copy() {
        return new TransformedItemStack(new Vector3f((Vector3fc)this.position), new Vector3f((Vector3fc)this.offset), new Vector3f((Vector3fc)this.scale), this.itemStack.clone());
    }
}

