package kr.toxicity.model.api.event;

import kr.toxicity.model.api.BetterModelPlugin;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

@RequiredArgsConstructor
@Getter
public final class PluginEndReloadEvent extends AbstractModelEvent {
    /**
     * Handler list
     */
    public static final HandlerList HANDLER_LIST = new HandlerList();

    private final BetterModelPlugin.ReloadResult result;

    @Override
    public @NotNull HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    /**
     * Gets handler list
     * @return handler list
     */
    public static @NotNull HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
