/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.io.File;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Stream;
import kr.toxicity.model.api.pack.PackByte;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackOverlay;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PackResult {
    private final PackMeta meta;
    private final File directory;
    private final Map<PackOverlay, Set<PackByte>> overlays = new TreeMap<PackOverlay, Set<PackByte>>();
    private final Set<PackByte> assets = new TreeSet<PackByte>();
    private final Set<PackByte> assetsView = Collections.unmodifiableSet(this.assets);
    private final long creationTime = System.currentTimeMillis();
    private boolean frozen = false;
    private boolean changed = false;
    private UUID uuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void set(@Nullable PackOverlay overlay, @NotNull PackByte packByte) {
        if (this.frozen) {
            throw new IllegalStateException("result is frozen.");
        }
        if (overlay == null) {
            Set<PackByte> set = this.assets;
            synchronized (set) {
                this.assets.add(packByte);
            }
            return;
        }
        Map<PackOverlay, Set<PackByte>> map = this.overlays;
        synchronized (map) {
            this.overlays.computeIfAbsent(overlay, o -> new TreeSet()).add(packByte);
        }
    }

    public void freeze() {
        this.freeze(false);
    }

    public boolean changed() {
        return this.changed;
    }

    public void freeze(boolean changed) {
        if (this.frozen) {
            throw new IllegalStateException("result is frozen.");
        }
        this.frozen = true;
        this.changed = changed;
    }

    @NotNull
    public PackMeta meta() {
        return this.meta;
    }

    @Nullable
    public File directory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UUID hash() {
        if (this.uuid != null) {
            return this.uuid;
        }
        PackResult packResult = this;
        synchronized (packResult) {
            if (this.uuid != null) {
                return this.uuid;
            }
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                this.stream().map(PackByte::bytes).forEach(sha::update);
                this.uuid = UUID.nameUUIDFromBytes(sha.digest());
                return this.uuid;
            }
            catch (Exception e) {
                this.uuid = UUID.randomUUID();
                return this.uuid;
            }
        }
    }

    public int size() {
        return this.assets.size() + this.overlays.values().stream().mapToInt(Set::size).sum();
    }

    public long time() {
        return System.currentTimeMillis() - this.creationTime;
    }

    @NotNull
    public @Unmodifiable Set<PackByte> overlays(@NotNull PackOverlay overlay) {
        Set<PackByte> get = this.overlays.get(overlay);
        return get != null ? Collections.unmodifiableSet(get) : Collections.emptySet();
    }

    public Stream<PackByte> stream() {
        return Stream.concat(this.overlays.values().stream().flatMap(Collection::stream), this.assets.stream());
    }

    @NotNull
    public @Unmodifiable Set<PackByte> assets() {
        return this.assetsView;
    }

    @Generated
    public PackResult(PackMeta meta, File directory) {
        this.meta = meta;
        this.directory = directory;
    }
}

