/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.nms.v1_21_R3;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.event.ModelDamagedEvent;
import kr.toxicity.model.api.event.ModelInteractAtEvent;
import kr.toxicity.model.api.event.ModelInteractEvent;
import kr.toxicity.model.api.mount.MountController;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelInteractionHand;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.nms.v1_21_R3.FunctionsKt;
import kr.toxicity.model.nms.v1_21_R3.HitBoxImpl;
import kr.toxicity.model.nms.v1_21_R3.HitBoxInteraction;
import kr.toxicity.model.nms.v1_21_R3.ModelDamageSourceImpl;
import kr.toxicity.model.shaded.kotlin.Lazy;
import kr.toxicity.model.shaded.kotlin.LazyKt;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0004H\u0016J\b\u00103\u001a\u00020\u0014H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u0010\u0005\u001a\u000206H\u0016J\b\u00107\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u0002012\u0006\u00108\u001a\u00020\u000eH\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0016J\b\u0010>\u001a\u00020\u0012H\u0016J\u0010\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u0002012\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020=H\u0016J\b\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002012\u0006\u0010G\u001a\u000206H\u0016J\u0010\u0010H\u001a\u0002012\u0006\u0010G\u001a\u000206H\u0016J\b\u0010I\u001a\u000201H\u0016J\u0010\u0010J\u001a\u0002012\u0006\u0010K\u001a\u00020\u0014H\u0016J\b\u0010L\u001a\u00020\u0014H\u0016J2\u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020O2\b\u0010R\u001a\u0004\u0018\u00010\f2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020\fH\u0016J*\u0010U\u001a\u0002012\u0006\u0010W\u001a\u00020O2\u0006\u0010X\u001a\u00020O2\u0006\u0010Y\u001a\u00020O2\b\u0010V\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010Z\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u0012H\u0016J\u0010\u0010\\\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\fH\u0016J\u0010\u0010]\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\fH\u0016J\u0010\u0010^\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\fH\u0002J\u0010\u0010_\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0`H\u0016J\n\u0010b\u001a\u0004\u0018\u00010cH\u0016J\b\u0010d\u001a\u00020\u0012H\u0016J\u0010\u0010e\u001a\u0002012\u0006\u0010f\u001a\u00020gH\u0002J\b\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u0002012\u0006\u0010f\u001a\u00020gH\u0002J \u0010k\u001a\n #*\u0004\u0018\u00010:0:2\u0006\u0010f\u001a\u00020g2\u0006\u0010l\u001a\u00020mH\u0002J\b\u0010n\u001a\u000201H\u0016J\u001a\u0010o\u001a\u0002012\u0006\u0010p\u001a\u00020q2\b\u0010S\u001a\u0004\u0018\u00010rH\u0016J\b\u0010s\u001a\u00020tH\u0016J\b\u0010u\u001a\u00020tH\u0016J\b\u0010v\u001a\u00020tH\u0016J\b\u0010w\u001a\u00020\u0012H\u0016J\b\u0010x\u001a\u00020\u0012H\u0016J\u0018\u0010y\u001a\u0002012\u0006\u0010f\u001a\u00020z2\u0006\u0010{\u001a\u00020|H\u0016J \u0010}\u001a\u0002012\u0006\u0010f\u001a\u00020z2\u0006\u0010{\u001a\u00020|2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0011\u0010\u0080\u0001\u001a\u0002012\u0006\u0010f\u001a\u00020zH\u0016J\u0011\u0010\u0081\u0001\u001a\u0002012\u0006\u0010f\u001a\u00020zH\u0016J\u001c\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010f\u001a\u00030\u0084\u00012\u0007\u0010{\u001a\u00030\u0085\u0001H\u0016J%\u0010\u0086\u0001\u001a\u00030\u0083\u00012\u0007\u0010f\u001a\u00030\u0084\u00012\u0007\u0010\u0087\u0001\u001a\u00020m2\u0007\u0010{\u001a\u00030\u0085\u0001H\u0016J\u001b\u0010\u0088\u0001\u001a\u00020\u00122\u0007\u0010\u0089\u0001\u001a\u00020a2\u0007\u0010S\u001a\u00030\u008a\u0001H\u0016J\u001c\u0010\u0088\u0001\u001a\u00020\u00122\u0007\u0010\u0089\u0001\u001a\u00020a2\b\u0010G\u001a\u0004\u0018\u00010\fH\u0016J%\u0010\u0088\u0001\u001a\u00020\u00122\u0007\u0010\u0089\u0001\u001a\u00020a2\b\u0010G\u001a\u0004\u0018\u00010\f2\u0007\u0010S\u001a\u00030\u008a\u0001H\u0016J.\u0010\u0088\u0001\u001a\u00020\u00122\u0007\u0010\u0089\u0001\u001a\u00020a2\b\u0010G\u001a\u0004\u0018\u00010\f2\u0007\u0010S\u001a\u00030\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020\u0012H\u0016J%\u0010\u008c\u0001\u001a\u00020\u00122\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0005\u001a\u00030\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020iH\u0016J\u0014\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0016J\t\u0010\u0095\u0001\u001a\u00020iH\u0016J\u0013\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0007\u0010\u0098\u0001\u001a\u00020mH\u0014J\u0013\u0010\u0099\u0001\u001a\u00020(2\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0016J\t\u0010\u009c\u0001\u001a\u000201H\u0016J7\u0010\u009d\u0001\u001a\u0005\u0018\u0001H\u009e\u0001\"\u0005\b\u0000\u0010\u009e\u00012\u001b\u0010\u009f\u0001\u001a\u0016\u0012\u0004\u0012\u00020c\u0012\u0005\u0012\u0003H\u009e\u00010\u00a0\u0001\u00a2\u0006\u0003\b\u00a1\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00a2\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR0\u0010\u001f\u001a$\u0012\u001b\u0012\u0019 #*\t\u0018\u00010\u0006\u00a2\u0006\u0002\b!0\u0006\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\b\"0 \u00a2\u0006\u0002\b!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010$\u001a\u0014 #*\t\u0018\u00010\u0006\u00a2\u0006\u0002\b!0\u0006\u00a2\u0006\u0002\b!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u001e\u001a\u0004\b-\u0010.\u00a8\u0006\u00a3\u0001"}, d2={"Lkr/toxicity/model/nms/v1_21_R3/HitBoxImpl;", "Lnet/minecraft/world/entity/decoration/ArmorStand;", "Lkr/toxicity/model/api/nms/HitBox;", "name", "Lkr/toxicity/model/api/bone/BoneName;", "source", "Lkr/toxicity/model/api/data/blueprint/ModelBoundingBox;", "bone", "Lkr/toxicity/model/api/bone/RenderedBone;", "listener", "Lkr/toxicity/model/api/nms/HitBoxListener;", "delegate", "Lnet/minecraft/world/entity/Entity;", "mountController", "Lkr/toxicity/model/api/mount/MountController;", "<init>", "(Lkr/toxicity/model/api/bone/BoneName;Lkr/toxicity/model/api/data/blueprint/ModelBoundingBox;Lkr/toxicity/model/api/bone/RenderedBone;Lkr/toxicity/model/api/nms/HitBoxListener;Lnet/minecraft/world/entity/Entity;Lkr/toxicity/model/api/mount/MountController;)V", "initialized", "", "jumpDelay", "", "mounted", "collision", "noGravity", "forceDismount", "onFly", "craftEntity", "getCraftEntity", "()Lkr/toxicity/model/api/nms/HitBox;", "craftEntity$delegate", "Lkr/toxicity/model/shaded/kotlin/Lazy;", "_rotatedSource", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/NotNull;", "Lkr/toxicity/model/shaded/kotlin/jvm/internal/EnhancedNullability;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "rotatedSource", "getRotatedSource", "()Lkr/toxicity/model/api/data/blueprint/ModelBoundingBox;", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "getDimensions", "()Lnet/minecraft/world/entity/EntityDimensions;", "interaction", "Lkr/toxicity/model/nms/v1_21_R3/HitBoxInteraction;", "getInteraction", "()Lkr/toxicity/model/nms/v1_21_R3/HitBoxInteraction;", "interaction$delegate", "initialSetup", "", "groupName", "id", "uuid", "Ljava/util/UUID;", "Lorg/bukkit/entity/Entity;", "positionSource", "controller", "relativePosition", "Lorg/joml/Vector3f;", "getArmorSlots", "", "Lnet/minecraft/world/item/ItemStack;", "hasMountDriver", "getItemBySlot", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "setItemSlot", "stack", "getMainArm", "Lnet/minecraft/world/entity/HumanoidArm;", "mount", "entity", "dismount", "dismountAll", "setRemainingFireTicks", "remainingFireTicks", "getRemainingFireTicks", "knockback", "d0", "", "d1", "d2", "attacker", "cause", "Lio/papermc/paper/event/entity/EntityKnockbackEvent$Cause;", "push", "pushingEntity", "x", "y", "z", "isCollidable", "ignoreClimbing", "canCollideWith", "canCollideWithBukkit", "checkCollide", "getActiveEffects", "", "Lnet/minecraft/world/effect/MobEffectInstance;", "getControllingPassenger", "Lnet/minecraft/world/entity/LivingEntity;", "onWalk", "mountControl", "player", "Lnet/minecraft/server/level/ServerPlayer;", "movementSpeed", "", "updateFlyStatus", "rideInput", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "tick", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "Lorg/bukkit/event/entity/EntityRemoveEvent$Cause;", "getBukkitLivingEntity", "Lorg/bukkit/craftbukkit/entity/CraftLivingEntity;", "getBukkitEntity", "getBukkitEntityRaw", "hasExactlyOnePlayerPassenger", "isDeadOrDying", "triggerInteract", "Lorg/bukkit/entity/Player;", "hand", "Lkr/toxicity/model/api/nms/ModelInteractionHand;", "triggerInteractAt", "position", "Lorg/bukkit/util/Vector;", "hide", "show", "interact", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/InteractionHand;", "interactAt", "vec", "addEffect", "effectInstance", "Lorg/bukkit/event/entity/EntityPotionEffectEvent$Cause;", "fireEvent", "hurtServer", "world", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "deflection", "Lnet/minecraft/world/entity/projectile/ProjectileDeflection;", "projectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "getHealth", "makeBoundingBox", "Lnet/minecraft/world/phys/AABB;", "vec3", "getDefaultDimensions", "pose", "Lnet/minecraft/world/entity/Pose;", "removeHitBox", "ifLivingEntity", "T", "block", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/shaded/kotlin/ExtensionFunctionType;", "(Lkr/toxicity/model/shaded/kotlin/jvm/functions/Function1;)Ljava/lang/Object;", "v1_21_R3"})
@SourceDebugExtension(value={"SMAP\nHitBoxImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitBoxImpl.kt\nkr/toxicity/model/nms/v1_21_R3/HitBoxImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n461#1:464\n461#1:465\n461#1:466\n461#1:469\n461#1:476\n461#1:477\n461#1:478\n461#1:479\n461#1:480\n461#1:481\n461#1:482\n461#1:483\n461#1:484\n461#1:485\n461#1:486\n1869#2,2:467\n2746#2,3:470\n2746#2,3:473\n*S KotlinDebug\n*F\n+ 1 HitBoxImpl.kt\nkr/toxicity/model/nms/v1_21_R3/HitBoxImpl\n*L\n69#1:464\n112#1:465\n144#1:466\n184#1:469\n217#1:476\n247#1:477\n325#1:478\n384#1:479\n389#1:480\n398#1:481\n408#1:482\n418#1:483\n423#1:484\n427#1:485\n456#1:486\n161#1:467,2\n211#1:470,3\n212#1:473,3\n*E\n"})
public final class HitBoxImpl
extends ArmorStand
implements HitBox {
    @NotNull
    private final BoneName name;
    @NotNull
    private final ModelBoundingBox source;
    @NotNull
    private final RenderedBone bone;
    @NotNull
    private final HitBoxListener listener;
    @NotNull
    private final net.minecraft.world.entity.Entity delegate;
    @NotNull
    private MountController mountController;
    private boolean initialized;
    private int jumpDelay;
    private boolean mounted;
    private boolean collision;
    private boolean noGravity;
    private boolean forceDismount;
    private boolean onFly;
    @NotNull
    private final Lazy craftEntity$delegate;
    @NotNull
    private final Supplier<ModelBoundingBox> _rotatedSource;
    @NotNull
    private final Lazy interaction$delegate;

    /*
     * WARNING - void declaration
     */
    public HitBoxImpl(@NotNull BoneName name, @NotNull ModelBoundingBox source, @NotNull RenderedBone bone, @NotNull HitBoxListener listener, @NotNull net.minecraft.world.entity.Entity delegate, @NotNull MountController mountController) {
        void $this$_init__u24lambda_u240;
        HitBoxInteraction hitBoxInteraction;
        Boolean bl;
        HitBoxImpl hitBoxImpl;
        HitBoxImpl this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)bone, (String)"bone");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)mountController, (String)"mountController");
        super(EntityType.ARMOR_STAND, delegate.level());
        this.name = name;
        this.source = source;
        this.bone = bone;
        this.listener = listener;
        this.delegate = delegate;
        this.mountController = mountController;
        HitBoxImpl hitBoxImpl2 = this_$iv = this;
        boolean $i$f$ifLivingEntity22 = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                void $this$collision_u24lambda_u240;
                net.minecraft.world.entity.LivingEntity livingEntity2 = livingEntity;
                hitBoxImpl = hitBoxImpl2;
                boolean bl2 = false;
                bl = $this$collision_u24lambda_u240.collides;
                hitBoxImpl2 = hitBoxImpl;
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        hitBoxImpl2.collision = Intrinsics.areEqual(bl, (Object)true);
        this.noGravity = this.delegate instanceof Mob ? ((Mob)this.delegate).isNoAi() : this.delegate.isNoGravity();
        this.craftEntity$delegate = LazyKt.lazy(() -> HitBoxImpl.craftEntity_delegate$lambda$0(this));
        Supplier<ModelBoundingBox> supplier = FunctionUtil.throttleTick(() -> HitBoxImpl._rotatedSource$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"throttleTick(...)");
        this._rotatedSource = supplier;
        this.interaction$delegate = LazyKt.lazy(() -> HitBoxImpl.interaction_delegate$lambda$0(this));
        this.moveTo(this.delegate.position());
        this.setInvisible(true);
        this.persist = false;
        this.setSilent(true);
        this.initialized = true;
        this.level().addFreshEntity((net.minecraft.world.entity.Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
        HitBoxInteraction $i$f$ifLivingEntity22 = hitBoxInteraction = this.getInteraction();
        hitBoxImpl = this.level();
        boolean bl3 = false;
        $this$_init__u24lambda_u240.moveTo($this$_init__u24lambda_u240.getDelegate().position());
        hitBoxImpl.addFreshEntity((net.minecraft.world.entity.Entity)hitBoxInteraction, CreatureSpawnEvent.SpawnReason.CUSTOM);
        this.getInteraction().startRiding((net.minecraft.world.entity.Entity)this);
    }

    @NotNull
    public final HitBox getCraftEntity() {
        Lazy lazy = this.craftEntity$delegate;
        return (HitBox)lazy.getValue();
    }

    private final ModelBoundingBox getRotatedSource() {
        return this._rotatedSource.get();
    }

    @NotNull
    public final EntityDimensions getDimensions() {
        ModelBoundingBox $this$_get_dimensions__u24lambda_u240 = this.getRotatedSource();
        boolean bl = false;
        EntityDimensions entityDimensions = new EntityDimensions((float)($this$_get_dimensions__u24lambda_u240.x() + $this$_get_dimensions__u24lambda_u240.z()) / (float)2, (float)$this$_get_dimensions__u24lambda_u240.y(), this.delegate.getEyeHeight(), EntityAttachments.createDefault((float)0.0f, (float)0.0f), false).scale(this.bone.hitBoxScale());
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"run(...)");
        return entityDimensions;
    }

    private final HitBoxInteraction getInteraction() {
        Lazy lazy = this.interaction$delegate;
        return (HitBoxInteraction)((Object)lazy.getValue());
    }

    private final void initialSetup() {
        block4: {
            if (!this.mounted) break block4;
            this.mounted = false;
            if (this.delegate instanceof Mob) {
                ((Mob)this.delegate).setNoAi(this.noGravity);
            } else {
                this.delegate.setNoGravity(this.noGravity);
            }
            HitBoxImpl this_$iv = this;
            boolean $i$f$ifLivingEntity = false;
            if (this_$iv.delegate.valid) {
                net.minecraft.world.entity.Entity entity = this_$iv.delegate;
                net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
                if (livingEntity != null) {
                    net.minecraft.world.entity.LivingEntity $this$initialSetup_u24lambda_u240 = livingEntity;
                    boolean bl = false;
                    $this$initialSetup_u24lambda_u240.collides = this.collision;
                }
            }
        }
    }

    @Override
    @NotNull
    public BoneName groupName() {
        return this.name;
    }

    @Override
    public int id() {
        return this.getId();
    }

    @Override
    @NotNull
    public UUID uuid() {
        UUID uUID = this.uuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
        return uUID;
    }

    @Override
    @NotNull
    public Entity source() {
        CraftEntity craftEntity2 = this.delegate.getBukkitEntity();
        Intrinsics.checkNotNullExpressionValue((Object)craftEntity2, (String)"getBukkitEntity(...)");
        return (Entity)craftEntity2;
    }

    @Override
    @NotNull
    public RenderedBone positionSource() {
        return this.bone;
    }

    @Override
    public boolean forceDismount() {
        return this.forceDismount;
    }

    @Override
    @NotNull
    public MountController mountController() {
        return this.mountController;
    }

    @Override
    public void mountController(@NotNull MountController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.mountController = controller;
    }

    @Override
    @NotNull
    public Vector3f relativePosition() {
        Vec3 $this$relativePosition_u24lambda_u240 = this.delegate.position();
        boolean bl = false;
        Vector3f vector3f = this.bone.hitBoxPosition().add((float)$this$relativePosition_u24lambda_u240.x, (float)$this$relativePosition_u24lambda_u240.y, (float)$this$relativePosition_u24lambda_u240.z);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"run(...)");
        return vector3f;
    }

    @Override
    @NotNull
    public HitBoxListener listener() {
        return this.listener;
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return new LinkedHashSet();
    }

    @Override
    public boolean hasMountDriver() {
        return this.getControllingPassenger() != null;
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void setItemSlot(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public void mount(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.getControllingPassenger() != null) {
            return;
        }
        if (this.getInteraction().getBukkitEntity().addPassenger(entity)) {
            if (this.mountController.canControl()) {
                this.mounted = true;
                this.noGravity = this.delegate.isNoGravity();
                HitBoxImpl this_$iv = this;
                boolean $i$f$ifLivingEntity = false;
                if (this_$iv.delegate.valid) {
                    net.minecraft.world.entity.Entity entity2 = this_$iv.delegate;
                    net.minecraft.world.entity.LivingEntity livingEntity = entity2 instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity2 : null;
                    if (livingEntity != null) {
                        net.minecraft.world.entity.LivingEntity $this$mount_u24lambda_u240 = livingEntity;
                        boolean bl = false;
                        this.collision = $this$mount_u24lambda_u240.collides;
                        $this$mount_u24lambda_u240.collides = false;
                    }
                }
            }
            this.listener.mount(this.getCraftEntity(), entity);
        }
    }

    @Override
    public void dismount(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.forceDismount = true;
        if (this.getInteraction().getBukkitEntity().removePassenger(entity)) {
            this.listener.dismount(this.getCraftEntity(), entity);
        }
        this.forceDismount = false;
    }

    @Override
    public void dismountAll() {
        this.forceDismount = true;
        ImmutableList immutableList = this.getInteraction().passengers;
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"passengers");
        Iterable $this$forEach$iv = (Iterable)immutableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            net.minecraft.world.entity.Entity it = (net.minecraft.world.entity.Entity)element$iv;
            boolean bl = false;
            it.stopRiding(true);
            this.listener.dismount(this.getCraftEntity(), (Entity)it.getBukkitEntity());
        }
        this.forceDismount = false;
    }

    public void setRemainingFireTicks(int remainingFireTicks) {
        this.delegate.setRemainingFireTicks(remainingFireTicks);
    }

    public int getRemainingFireTicks() {
        return this.delegate.getRemainingFireTicks();
    }

    public void knockback(double d0, double d1, double d2, @Nullable net.minecraft.world.entity.Entity attacker, @NotNull EntityKnockbackEvent.Cause cause) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            if (attacker == this.delegate) {
                return;
            }
            HitBoxImpl this_$iv = this;
            boolean $i$f$ifLivingEntity = false;
            if (!this_$iv.delegate.valid) break block2;
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$knockback_u24lambda_u240 = livingEntity;
                boolean bl = false;
                $this$knockback_u24lambda_u240.knockback(d0, d1, d2, attacker, cause);
            }
        }
    }

    public void push(@NotNull net.minecraft.world.entity.Entity pushingEntity) {
        Intrinsics.checkNotNullParameter((Object)pushingEntity, (String)"pushingEntity");
        if (pushingEntity == this.delegate) {
            return;
        }
        this.delegate.push(pushingEntity);
    }

    public void push(double x, double y, double z, @Nullable net.minecraft.world.entity.Entity pushingEntity) {
        if (pushingEntity == this.delegate) {
            return;
        }
        this.delegate.push(x, y, z, pushingEntity);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return this.delegate.isCollidable(ignoreClimbing);
    }

    public boolean canCollideWith(@NotNull net.minecraft.world.entity.Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.checkCollide(entity) && this.delegate.canCollideWith(entity);
    }

    public boolean canCollideWithBukkit(@NotNull net.minecraft.world.entity.Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.checkCollide(entity) && this.delegate.canCollideWithBukkit(entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkCollide(net.minecraft.world.entity.Entity entity) {
        boolean bl;
        net.minecraft.world.entity.Entity it;
        boolean bl2;
        if (entity == this.delegate) return false;
        ImmutableList immutableList = this.passengers;
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"passengers");
        Iterable $this$none$iv = (Iterable)immutableList;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                it = (net.minecraft.world.entity.Entity)element$iv;
                boolean bl3 = false;
                if (it == entity) {
                    return false;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        ImmutableList immutableList2 = this.delegate.passengers;
        Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"passengers");
        $this$none$iv = (Iterable)immutableList2;
        $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                it = (net.minecraft.world.entity.Entity)element$iv;
                boolean bl5 = false;
                if (it == entity) {
                    return false;
                }
                boolean bl6 = false;
                if (!bl6) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (!(entity instanceof HitBoxImpl)) return true;
        if (((HitBoxImpl)entity).delegate == this.delegate) return false;
        return true;
    }

    @NotNull
    public Collection<MobEffectInstance> getActiveEffects() {
        Collection collection;
        Collection collection2;
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$getActiveEffects_u24lambda_u240 = livingEntity;
                boolean bl = false;
                collection2 = $this$getActiveEffects_u24lambda_u240.getActiveEffects();
            } else {
                collection2 = null;
            }
        } else {
            collection2 = collection = null;
        }
        if (collection2 == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public net.minecraft.world.entity.LivingEntity getControllingPassenger() {
        net.minecraft.world.entity.LivingEntity livingEntity;
        if (this.mounted) {
            net.minecraft.world.entity.Entity entity = this.getInteraction().getFirstPassenger();
            livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity == null) {
                livingEntity = super.getControllingPassenger();
            }
        } else {
            livingEntity = null;
        }
        return livingEntity;
    }

    @Override
    public boolean onWalk() {
        return FunctionsKt.isWalking((net.minecraft.world.entity.Entity)this);
    }

    private final void mountControl(ServerPlayer player) {
        if (!(this.delegate instanceof net.minecraft.world.entity.LivingEntity)) {
            return;
        }
        Vec3 travelVector = new Vec3((double)((net.minecraft.world.entity.LivingEntity)this.delegate).xxa, (double)((net.minecraft.world.entity.LivingEntity)this.delegate).yya, (double)((net.minecraft.world.entity.LivingEntity)this.delegate).zza);
        if (!this.mountController.canFly() && ((net.minecraft.world.entity.LivingEntity)this.delegate).isFallFlying()) {
            return;
        }
        this.updateFlyStatus(player);
        Vector3f riddenInput = this.rideInput(player, travelVector);
        if ((double)riddenInput.length() > 0.01) {
            ((net.minecraft.world.entity.LivingEntity)this.delegate).setYRot(player.getYRot());
            if (this.onFly) {
                ((net.minecraft.world.entity.LivingEntity)this.delegate).yHeadRot = player.getYRot();
            }
            this.delegate.move(MoverType.SELF, new Vec3((double)riddenInput.x, (double)riddenInput.y, (double)riddenInput.z));
        }
        double dy = ((net.minecraft.world.entity.LivingEntity)this.delegate).getDeltaMovement().y + ((net.minecraft.world.entity.LivingEntity)this.delegate).getGravity();
        if (!this.onFly && this.mountController.canJump() && (this.delegate.horizontalCollision || FunctionsKt.isJump(player))) {
            boolean bl = 0.0 <= dy ? dy <= 0.01 : false;
            if (bl && this.jumpDelay == 0) {
                this.jumpDelay = 10;
                ((net.minecraft.world.entity.LivingEntity)this.delegate).jumpFromGround();
            }
        }
    }

    private final float movementSpeed() {
        Float f;
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                float f2;
                net.minecraft.world.entity.LivingEntity $this$movementSpeed_u24lambda_u240 = livingEntity;
                boolean bl = false;
                AttributeInstance attributeInstance = $this$movementSpeed_u24lambda_u240.getAttribute(Attributes.MOVEMENT_SPEED);
                if (attributeInstance != null) {
                    float it = (float)attributeInstance.getValue();
                    boolean bl2 = false;
                    f2 = !this.onFly && !$this$movementSpeed_u24lambda_u240.shouldDiscardFriction() ? $this$movementSpeed_u24lambda_u240.level().getBlockState($this$movementSpeed_u24lambda_u240.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * it : it;
                } else {
                    f2 = 0.0f;
                }
                f = Float.valueOf(f2);
            } else {
                f = null;
            }
        } else {
            f = null;
        }
        return f != null ? f.floatValue() : 0.0f;
    }

    private final void updateFlyStatus(ServerPlayer player) {
        boolean fly;
        boolean bl = fly = FunctionsKt.isJump(player) && this.mountController.canFly() || this.noGravity || this.onFly;
        if (this.delegate instanceof Mob) {
            ((Mob)this.delegate).setNoAi(fly);
        } else {
            this.delegate.setNoGravity(fly);
        }
        boolean bl2 = this.onFly = fly && !this.delegate.onGround();
        if (this.onFly) {
            this.delegate.resetFallDistance();
        }
    }

    private final Vector3f rideInput(ServerPlayer player, Vec3 travelVector) {
        MountController.MoveType moveType = this.onFly ? MountController.MoveType.FLY : MountController.MoveType.DEFAULT;
        org.bukkit.entity.Player player2 = (org.bukkit.entity.Player)player.getBukkitEntity();
        CraftEntity craftEntity2 = this.delegate.getBukkitEntity();
        Intrinsics.checkNotNull((Object)craftEntity2, (String)"null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        return this.mountController.move(moveType, player2, (LivingEntity)craftEntity2, new Vector3f(FunctionsKt.xMovement(player), FunctionsKt.yMovement(player), FunctionsKt.zMovement(player)), new Vector3f((float)travelVector.x, (float)travelVector.y, (float)travelVector.z)).mul(this.movementSpeed()).rotateY(-((float)Math.toRadians(player.getYRot())));
    }

    public void tick() {
        Entity.RemovalReason removalReason = this.delegate.getRemovalReason();
        if (removalReason != null) {
            Entity.RemovalReason it = removalReason;
            boolean bl = false;
            if (!this.isRemoved()) {
                this.remove(it);
            }
            return;
        }
        net.minecraft.world.entity.LivingEntity controller = this.getControllingPassenger();
        if (this.jumpDelay > 0) {
            int n = this.jumpDelay;
            this.jumpDelay = n + -1;
        }
        this.getInteraction().setInvisible(this.delegate.isInvisible());
        if (controller instanceof ServerPlayer && !this.isDeadOrDying() && this.mountController.canControl()) {
            if (this.delegate instanceof Mob) {
                ((Mob)this.delegate).getNavigation().stop();
            }
            this.mountControl((ServerPlayer)controller);
        } else {
            this.initialSetup();
        }
        this.setYRot(this.bone.rotation().y());
        this.yHeadRot = this.getYRot();
        this.yBodyRot = this.getYRot();
        Vector3f pos = this.relativePosition();
        double minusHeight = this.getRotatedSource().minY() * (double)this.bone.hitBoxScale();
        this.setPos(pos.x, (double)pos.y + minusHeight, pos.z);
        BlockPos.betweenClosedStream((AABB)this.getBoundingBox()).forEach(arg_0 -> HitBoxImpl.tick$lambda$2(arg_0 -> HitBoxImpl.tick$lambda$1(this, arg_0), arg_0));
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.delegate.lavaHurt();
        }
        this.firstTick = false;
        this.listener.sync(this.getCraftEntity());
    }

    public void remove(@NotNull Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause cause) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.initialSetup();
        this.listener.remove(this.getCraftEntity());
        this.getInteraction().remove(reason);
        super.remove(reason, cause);
    }

    @NotNull
    public CraftLivingEntity getBukkitLivingEntity() {
        return this.getBukkitEntity();
    }

    @NotNull
    public CraftLivingEntity getBukkitEntity() {
        HitBox hitBox = this.getCraftEntity();
        Intrinsics.checkNotNull((Object)hitBox, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftLivingEntity");
        return (CraftLivingEntity)hitBox;
    }

    @NotNull
    public CraftLivingEntity getBukkitEntityRaw() {
        return this.getBukkitEntity();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return false;
    }

    public boolean isDeadOrDying() {
        Boolean bl;
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$isDeadOrDying_u24lambda_u240 = livingEntity;
                boolean bl2 = false;
                bl = $this$isDeadOrDying_u24lambda_u240.isDeadOrDying();
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    @Override
    public void triggerInteract(@NotNull org.bukkit.entity.Player player, @NotNull ModelInteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)hand), (String)"hand");
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getHandle(...)");
        Player player2 = (Player)serverPlayer;
        this.interact(player2, switch (WhenMappings.$EnumSwitchMapping$0[hand.ordinal()]) {
            case 1 -> InteractionHand.OFF_HAND;
            case 2 -> InteractionHand.MAIN_HAND;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Override
    public void triggerInteractAt(@NotNull org.bukkit.entity.Player player, @NotNull ModelInteractionHand hand, @NotNull Vector position) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)hand), (String)"hand");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getHandle(...)");
        Player player2 = (Player)serverPlayer;
        Vec3 vec3 = FunctionsKt.toVanilla(position);
        this.interactAt(player2, vec3, switch (WhenMappings.$EnumSwitchMapping$0[hand.ordinal()]) {
            case 1 -> InteractionHand.OFF_HAND;
            case 2 -> InteractionHand.MAIN_HAND;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Override
    public void hide(@NotNull org.bukkit.entity.Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BetterModelPlugin betterModelPlugin = BetterModel.plugin();
        Intrinsics.checkNotNullExpressionValue((Object)betterModelPlugin, (String)"plugin(...)");
        BetterModelPlugin plugin = betterModelPlugin;
        player.hideEntity((Plugin)plugin, (Entity)this.getBukkitEntity());
        player.hideEntity((Plugin)plugin, (Entity)this.getInteraction().getBukkitEntity());
    }

    @Override
    public void show(@NotNull org.bukkit.entity.Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BetterModelPlugin betterModelPlugin = BetterModel.plugin();
        Intrinsics.checkNotNullExpressionValue((Object)betterModelPlugin, (String)"plugin(...)");
        BetterModelPlugin plugin = betterModelPlugin;
        player.showEntity((Plugin)plugin, (Entity)this.getBukkitEntity());
        player.showEntity((Plugin)plugin, (Entity)this.getInteraction().getBukkitEntity());
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player == this.delegate) {
            InteractionResult.Fail fail = InteractionResult.FAIL;
            Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
            return (InteractionResult)fail;
        }
        CraftHumanEntity craftHumanEntity = player.getBukkitEntity();
        Intrinsics.checkNotNull((Object)craftHumanEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        org.bukkit.entity.Player player2 = (org.bukkit.entity.Player)craftHumanEntity;
        HitBox hitBox = this.getCraftEntity();
        ModelInteractEvent interact = new ModelInteractEvent(player2, hitBox, switch (WhenMappings.$EnumSwitchMapping$1[hand.ordinal()]) {
            case 1 -> ModelInteractionHand.RIGHT;
            case 2 -> ModelInteractionHand.LEFT;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (!FunctionsKt.call((Event)interact)) {
            InteractionResult.Fail fail = InteractionResult.FAIL;
            Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
            return (InteractionResult)fail;
        }
        ((ServerPlayer)player).connection.handleInteract(ServerboundInteractPacket.createInteractionPacket((net.minecraft.world.entity.Entity)this.delegate, (boolean)((ServerPlayer)player).isShiftKeyDown(), (InteractionHand)hand));
        InteractionResult.Success success = InteractionResult.SUCCESS;
        Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
        return (InteractionResult)success;
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (player == this.delegate) {
            InteractionResult.Fail fail = InteractionResult.FAIL;
            Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
            return (InteractionResult)fail;
        }
        CraftHumanEntity craftHumanEntity = player.getBukkitEntity();
        Intrinsics.checkNotNull((Object)craftHumanEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        org.bukkit.entity.Player player2 = (org.bukkit.entity.Player)craftHumanEntity;
        HitBox hitBox = this.getCraftEntity();
        ModelInteractAtEvent interact = new ModelInteractAtEvent(player2, hitBox, switch (WhenMappings.$EnumSwitchMapping$1[hand.ordinal()]) {
            case 1 -> ModelInteractionHand.RIGHT;
            case 2 -> ModelInteractionHand.LEFT;
            default -> throw new NoWhenBranchMatchedException();
        }, FunctionsKt.toBukkit(vec));
        if (!FunctionsKt.call((Event)interact)) {
            InteractionResult.Fail fail = InteractionResult.FAIL;
            Intrinsics.checkNotNullExpressionValue((Object)fail, (String)"FAIL");
            return (InteractionResult)fail;
        }
        ((ServerPlayer)player).connection.handleInteract(ServerboundInteractPacket.createInteractionPacket((net.minecraft.world.entity.Entity)this.delegate, (boolean)((ServerPlayer)player).isShiftKeyDown(), (InteractionHand)hand, (Vec3)vec));
        InteractionResult.Success success = InteractionResult.SUCCESS;
        Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
        return (InteractionResult)success;
    }

    public boolean addEffect(@NotNull MobEffectInstance effectInstance, @NotNull EntityPotionEffectEvent.Cause cause) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$addEffect_u24lambda_u240 = livingEntity;
                boolean bl2 = false;
                bl = $this$addEffect_u24lambda_u240.addEffect(effectInstance, cause);
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    public boolean addEffect(@NotNull MobEffectInstance effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        if (entity == this.delegate) {
            return false;
        }
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity2 = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity2 instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity2 : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$addEffect_u24lambda_u241 = livingEntity;
                boolean bl2 = false;
                bl = $this$addEffect_u24lambda_u241.addEffect(effectInstance, entity);
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    public boolean addEffect(@NotNull MobEffectInstance effectInstance, @Nullable net.minecraft.world.entity.Entity entity, @NotNull EntityPotionEffectEvent.Cause cause) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (entity == this.delegate) {
            return false;
        }
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity2 = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity2 instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity2 : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$addEffect_u24lambda_u242 = livingEntity;
                boolean bl2 = false;
                bl = $this$addEffect_u24lambda_u242.addEffect(effectInstance, entity, cause);
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    public boolean addEffect(@NotNull MobEffectInstance effectInstance, @Nullable net.minecraft.world.entity.Entity entity, @NotNull EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (entity == this.delegate) {
            return false;
        }
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity2 = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity2 instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity2 : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$addEffect_u24lambda_u243 = livingEntity;
                boolean bl2 = false;
                bl = $this$addEffect_u24lambda_u243.addEffect(effectInstance, entity, cause, fireEvent);
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    public boolean hurtServer(@NotNull ServerLevel world, @NotNull DamageSource source, float amount) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.getEntity() == this.delegate || this.delegate.isInvulnerable()) {
            return false;
        }
        if (source.getEntity() == this.getControllingPassenger() && !this.mountController.canBeDamagedByRider()) {
            return false;
        }
        ModelDamageSourceImpl ds = new ModelDamageSourceImpl(source);
        ModelDamagedEvent event = new ModelDamagedEvent(this.getCraftEntity(), ds, amount);
        if (!FunctionsKt.call((Event)event)) {
            return false;
        }
        if (this.listener.damage(this, ds, amount)) {
            return false;
        }
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$hurtServer_u24lambda_u240 = livingEntity;
                boolean bl2 = false;
                bl = $this$hurtServer_u24lambda_u240.hurtServer(world, source, event.getDamage());
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    @NotNull
    public ProjectileDeflection deflection(@NotNull Projectile projectile) {
        ProjectileDeflection projectileDeflection;
        ProjectileDeflection projectileDeflection2;
        Intrinsics.checkNotNullParameter((Object)projectile, (String)"projectile");
        if (projectile.getOwner() == this.delegate) {
            ProjectileDeflection projectileDeflection3 = ProjectileDeflection.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)projectileDeflection3, (String)"NONE");
            return projectileDeflection3;
        }
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$deflection_u24lambda_u240 = livingEntity;
                boolean bl = false;
                projectileDeflection2 = $this$deflection_u24lambda_u240.deflection(projectile);
            } else {
                projectileDeflection2 = null;
            }
        } else {
            projectileDeflection2 = projectileDeflection = null;
        }
        if (projectileDeflection2 == null) {
            ProjectileDeflection projectileDeflection4 = ProjectileDeflection.NONE;
            projectileDeflection = projectileDeflection4;
            Intrinsics.checkNotNullExpressionValue((Object)projectileDeflection4, (String)"NONE");
        }
        return projectileDeflection;
    }

    public float getHealth() {
        Float f;
        HitBoxImpl this_$iv = this;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                net.minecraft.world.entity.LivingEntity $this$getHealth_u24lambda_u240 = livingEntity;
                boolean bl = false;
                f = Float.valueOf($this$getHealth_u24lambda_u240.getHealth());
            } else {
                f = null;
            }
        } else {
            f = null;
        }
        return f != null ? f.floatValue() : super.getHealth();
    }

    @NotNull
    protected AABB makeBoundingBox(@NotNull Vec3 vec3) {
        AABB aABB;
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"vec3");
        if (!this.initialized) {
            AABB aABB2 = super.makeBoundingBox(vec3);
            Intrinsics.checkNotNull((Object)aABB2);
            aABB = aABB2;
        } else {
            AABB aABB3;
            float scale2 = this.bone.hitBoxScale();
            ModelBoundingBox source = this.getRotatedSource();
            AABB $this$makeBoundingBox_u24lambda_u240 = aABB3 = new AABB(vec3.x + source.minX() * (double)scale2, vec3.y, vec3.z + source.minZ() * (double)scale2, vec3.x + source.maxX() * (double)scale2, vec3.y + (source.maxY() - source.minY()) * (double)scale2, vec3.z + source.maxZ() * (double)scale2);
            boolean bl = false;
            if (FunctionsKt.getCONFIG().debug().has(DebugConfig.DebugOption.HITBOX)) {
                this.getBukkitEntity().getWorld().spawnParticle(Particle.DUST, $this$makeBoundingBox_u24lambda_u240.minX, $this$makeBoundingBox_u24lambda_u240.minY, $this$makeBoundingBox_u24lambda_u240.minZ, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                this.getBukkitEntity().getWorld().spawnParticle(Particle.DUST, $this$makeBoundingBox_u24lambda_u240.maxX, $this$makeBoundingBox_u24lambda_u240.maxY, $this$makeBoundingBox_u24lambda_u240.maxZ, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
            }
            aABB = aABB3;
        }
        return aABB;
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        EntityDimensions entityDimensions;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        if (this.initialized) {
            entityDimensions = this.getDimensions();
        } else {
            EntityDimensions entityDimensions2 = super.getDefaultDimensions(pose);
            entityDimensions = entityDimensions2;
            Intrinsics.checkNotNullExpressionValue((Object)entityDimensions2, (String)"getDefaultDimensions(...)");
        }
        return entityDimensions;
    }

    @Override
    public void removeHitBox() {
        BetterModel.plugin().scheduler().task((Entity)this.getBukkitEntity(), () -> HitBoxImpl.removeHitBox$lambda$0(this));
    }

    private final <T> T ifLivingEntity(Function1<? super net.minecraft.world.entity.LivingEntity, ? extends T> block) {
        Object object;
        boolean $i$f$ifLivingEntity = false;
        if (this.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            object = livingEntity != null ? block.invoke((Object)livingEntity) : null;
        } else {
            object = null;
        }
        return (T)object;
    }

    private static final craftEntity.2.1 craftEntity_delegate$lambda$0(HitBoxImpl this$0) {
        Server server = Bukkit.getServer();
        return new HitBox(this$0, server){
            private final /* synthetic */ HitBoxImpl $$delegate_0;
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.CraftServer");
                super((CraftServer)$super_call_param$1, (ArmorStand)$receiver);
                this.$$delegate_0 = $receiver;
            }

            @ApiStatus.Internal
            public void triggerInteract(@NotNull org.bukkit.entity.Player p0, @NotNull ModelInteractionHand p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                this.$$delegate_0.triggerInteract(p0, p1);
            }

            @ApiStatus.Internal
            public void triggerInteractAt(@NotNull org.bukkit.entity.Player p0, @NotNull ModelInteractionHand p1, @NotNull Vector p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                this.$$delegate_0.triggerInteractAt(p0, p1, p2);
            }

            @ApiStatus.Internal
            public void hide(@NotNull org.bukkit.entity.Player p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$$delegate_0.hide(p0);
            }

            @ApiStatus.Internal
            public void show(@NotNull org.bukkit.entity.Player p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$$delegate_0.show(p0);
            }

            @NotNull
            public BoneName groupName() {
                return this.$$delegate_0.groupName();
            }

            @NotNull
            public MountController mountController() {
                return this.$$delegate_0.mountController();
            }

            public void mountController(@NotNull MountController p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$$delegate_0.mountController(p0);
            }

            public boolean onWalk() {
                return this.$$delegate_0.onWalk();
            }

            @NotNull
            public Entity source() {
                return this.$$delegate_0.source();
            }

            public void mount(@NotNull Entity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$$delegate_0.mount(p0);
            }

            public boolean hasMountDriver() {
                return this.$$delegate_0.hasMountDriver();
            }

            public void dismount(@NotNull Entity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$$delegate_0.dismount(p0);
            }

            public void dismountAll() {
                this.$$delegate_0.dismountAll();
            }

            public boolean forceDismount() {
                return this.$$delegate_0.forceDismount();
            }

            @NotNull
            public Vector3f relativePosition() {
                return this.$$delegate_0.relativePosition();
            }

            public void removeHitBox() {
                this.$$delegate_0.removeHitBox();
            }

            @NotNull
            public HitBoxListener listener() {
                return this.$$delegate_0.listener();
            }

            @NotNull
            public RenderedBone positionSource() {
                return this.$$delegate_0.positionSource();
            }

            public int id() {
                return this.$$delegate_0.id();
            }

            @NotNull
            public UUID uuid() {
                return this.$$delegate_0.uuid();
            }
        };
    }

    private static final ModelBoundingBox _rotatedSource$lambda$0(HitBoxImpl this$0) {
        return this$0.source.rotate(new Quaterniond((Quaternionfc)this$0.bone.hitBoxViewRotation()));
    }

    private static final HitBoxInteraction interaction_delegate$lambda$0(HitBoxImpl this$0) {
        return new HitBoxInteraction(this$0);
    }

    private static final Unit tick$lambda$1(HitBoxImpl this$0, BlockPos it) {
        this$0.level().getBlockState(it).entityInside(this$0.level(), it, this$0.delegate);
        return Unit.INSTANCE;
    }

    private static final void tick$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeHitBox$lambda$0(HitBoxImpl this$0) {
        Entity.RemovalReason removalReason;
        Entity.RemovalReason removalReason2;
        HitBoxImpl this_$iv;
        this$0.dismountAll();
        HitBoxImpl hitBoxImpl = this_$iv = this$0;
        boolean $i$f$ifLivingEntity = false;
        if (this_$iv.delegate.valid) {
            net.minecraft.world.entity.Entity entity = this_$iv.delegate;
            net.minecraft.world.entity.LivingEntity livingEntity = entity instanceof net.minecraft.world.entity.LivingEntity ? (net.minecraft.world.entity.LivingEntity)entity : null;
            if (livingEntity != null) {
                void $this$removeHitBox_u24lambda_u240_u240;
                net.minecraft.world.entity.LivingEntity livingEntity2 = livingEntity;
                HitBoxImpl hitBoxImpl2 = hitBoxImpl;
                boolean bl = false;
                removalReason2 = $this$removeHitBox_u24lambda_u240_u240.getRemovalReason();
                hitBoxImpl = hitBoxImpl2;
            } else {
                removalReason2 = null;
            }
        } else {
            removalReason2 = removalReason = null;
        }
        if (removalReason2 == null) {
            removalReason = Entity.RemovalReason.KILLED;
        }
        hitBoxImpl.remove(removalReason);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ModelInteractionHand.values().length];
            try {
                nArray[ModelInteractionHand.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelInteractionHand.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InteractionHand.values().length];
            try {
                nArray[InteractionHand.MAIN_HAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionHand.OFF_HAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

