/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.event.PluginEndReloadEvent;
import kr.toxicity.model.api.event.PluginStartReloadEvent;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.ReflectionUtil;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModel {
    public static final boolean IS_FOLIA = ReflectionUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    public static final boolean IS_PURPUR = ReflectionUtil.classExists("org.purpurmc.purpur.PurpurConfig");
    public static final boolean IS_PAPER = IS_PURPUR || IS_FOLIA || ReflectionUtil.classExists("io.papermc.paper.configuration.PaperConfigurations");
    private static BetterModelPlugin instance;

    private BetterModel() {
        throw new RuntimeException();
    }

    @NotNull
    public static BetterModelConfig config() {
        return BetterModel.plugin().config();
    }

    @NotNull
    public static Optional<ModelRenderer> model(@NotNull String name) {
        return Optional.ofNullable(BetterModel.plugin().modelManager().renderer(name));
    }

    @NotNull
    public static Optional<ModelRenderer> limb(@NotNull String name) {
        return Optional.ofNullable(BetterModel.plugin().playerManager().limb(name));
    }

    @NotNull
    public static Optional<PlayerChannelHandler> player(@NotNull UUID uuid) {
        return Optional.ofNullable(BetterModel.plugin().playerManager().player(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull UUID uuid) {
        return Optional.ofNullable(EntityTrackerRegistry.registry(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull Entity entity) {
        return Optional.ofNullable(EntityTrackerRegistry.registry(entity));
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> models() {
        return BetterModel.plugin().modelManager().renderers();
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> limbs() {
        return BetterModel.plugin().playerManager().limbs();
    }

    @NotNull
    public static BetterModelPlugin plugin() {
        return Objects.requireNonNull(instance, "BetterModel hasn't been initialized yet!");
    }

    @Deprecated
    @NotNull
    public static BetterModelPlugin inst() {
        return BetterModel.plugin();
    }

    @ApiStatus.Internal
    public static void register(@NotNull BetterModelPlugin instance) {
        Objects.requireNonNull(instance, "instance cannot be null.");
        if (BetterModel.instance == instance) {
            throw new RuntimeException("Duplicated instance.");
        }
        instance.addReloadStartHandler(zipper -> EventUtil.call(new PluginStartReloadEvent((PackZipper)zipper)));
        instance.addReloadEndHandler(t -> EventUtil.call(new PluginEndReloadEvent((BetterModelPlugin.ReloadResult)t)));
        BetterModel.instance = instance;
    }
}

