/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.AnimationGenerator;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelAnimator;
import kr.toxicity.model.api.script.BlueprintScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record BlueprintAnimation(@NotNull String name, @NotNull AnimationIterator.Type loop, float length, boolean override, @NotNull @Unmodifiable Map<BoneName, BlueprintAnimator> animator, @Nullable BlueprintScript script, @NotNull List<AnimationMovement> emptyAnimator) {
    @NotNull
    public static BlueprintAnimation from(@NotNull List<BlueprintChildren> children, @NotNull ModelAnimation animation) {
        HashMap<BoneName, BlueprintAnimator.AnimatorData> map = new HashMap<BoneName, BlueprintAnimator.AnimatorData>();
        BlueprintScript blueprintScript = animation.override() ? null : BlueprintScript.fromEmpty(animation);
        Map<String, ModelAnimator> animator = animation.animators();
        for (Map.Entry<String, ModelAnimator> entry : animator.entrySet()) {
            String name = entry.getValue().name();
            if (name == null) continue;
            BlueprintAnimator.Builder builder = new BlueprintAnimator.Builder(animation.length());
            entry.getValue().keyframes().stream().sorted(Comparator.naturalOrder()).forEach(builder::addFrame);
            if (entry.getKey().equals("effects")) {
                blueprintScript = BlueprintScript.from(animation, entry.getValue());
                continue;
            }
            map.put(BoneTagRegistry.parse(name), builder.build(name));
        }
        Map<BoneName, BlueprintAnimator> animators = AnimationGenerator.createMovements(children, map);
        return new BlueprintAnimation(animation.name(), animation.loop(), animation.length(), animation.override(), animators, blueprintScript, animators.isEmpty() ? List.of(AnimationMovement.EMPTY, new AnimationMovement(animation.length())) : animators.values().iterator().next().keyFrame().stream().map(a -> new AnimationMovement(a.time())).toList());
    }

    @NotNull
    public AnimationIterator<AnimationMovement> emptyIterator(@NotNull AnimationIterator.Type type) {
        return type.create(this.emptyAnimator);
    }
}

