/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class InterpolationUtil {
    private static final float FRAME_HASH = 0.01f;
    private static final float FRAME_HASH_REVERT = 100.0f;

    private InterpolationUtil() {
        throw new RuntimeException();
    }

    private static void point(@NotNull FloatSortedSet target, @NotNull List<VectorPoint> points) {
        for (VectorPoint point : points) {
            target.add(point.time());
        }
    }

    @NotNull
    public static List<AnimationPoint> putAnimationPoint(@NotNull List<AnimationPoint> animations, @NotNull FloatSortedSet points) {
        return InterpolationUtil.sum(animations.stream().map(AnimationPoint::position).distinct().toList(), animations.stream().map(AnimationPoint::rotation).distinct().toList(), animations.stream().map(AnimationPoint::scale).distinct().toList(), points);
    }

    @NotNull
    public static List<AnimationPoint> sum(float length, @NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale) {
        FloatAVLTreeSet set = new FloatAVLTreeSet((Comparator)FloatComparators.NATURAL_COMPARATOR);
        set.add(0.0f);
        set.add(length);
        InterpolationUtil.point((FloatSortedSet)set, position);
        InterpolationUtil.point((FloatSortedSet)set, scale);
        InterpolationUtil.point((FloatSortedSet)set, rotation);
        return InterpolationUtil.sum(position, rotation, scale, (FloatSortedSet)set);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale, @NotNull FloatSortedSet points) {
        List<VectorPoint> pp = InterpolationUtil.putPoint(position, points);
        List<VectorPoint> rp = InterpolationUtil.putPoint(rotation, points);
        List<VectorPoint> sp = InterpolationUtil.putPoint(scale, points);
        return IntStream.range(0, pp.size()).mapToObj(i -> new AnimationPoint((VectorPoint)pp.get(i), (VectorPoint)rp.get(i), (VectorPoint)sp.get(i))).toList();
    }

    @NotNull
    public static List<VectorPoint> putPoint(@NotNull List<VectorPoint> vectors, @NotNull FloatSortedSet points) {
        VectorPoint[] newVectors = new VectorPoint[points.size()];
        int index = 0;
        FloatBidirectionalIterator iterator2 = points.iterator();
        if (vectors.size() < 2) {
            VectorPoint first;
            VectorPoint vectorPoint = first = vectors.isEmpty() ? VectorPoint.EMPTY : vectors.getFirst();
            while (iterator2.hasNext()) {
                newVectors[index++] = new VectorPoint(first.vector(), iterator2.nextFloat(), first.interpolation());
            }
            return Arrays.asList(newVectors);
        }
        VectorPoint p1 = VectorPoint.EMPTY;
        VectorPoint p2 = vectors.getFirst();
        VectorPoint last = vectors.getLast();
        float length = last.time();
        int i = 0;
        float t = p2.time();
        while (iterator2.hasNext()) {
            float point = iterator2.nextFloat();
            while (i < vectors.size() - 1 && t < point) {
                p1 = p2;
                p2 = vectors.get(++i);
                t = p2.time();
            }
            if (point > length) {
                newVectors[index++] = new VectorPoint(last.vector(), point, last.interpolation());
                continue;
            }
            newVectors[index++] = point == t ? vectors.get(i) : p1.interpolation().interpolate(vectors, i, point);
        }
        return Arrays.asList(newVectors);
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames) {
        InterpolationUtil.insertLerpFrame(frames, (float)BetterModel.config().lerpFrameTime() / 20.0f);
    }

    public static float roundTime(float time) {
        return (float)((int)MathUtil.fma(time, 100.0f, 0.001f)) * 0.01f;
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        float first = 0.0f;
        float second = 0.0f;
        FloatBidirectionalIterator iterator2 = new FloatAVLTreeSet(frames).iterator();
        while (iterator2.hasNext()) {
            first = second;
            second = iterator2.nextFloat();
            int max = (int)((second - first) / frame);
            for (int i = 0; i < max; ++i) {
                float add = MathUtil.fma(frame, (float)(i + 1), first);
                if (second - add < frame) continue;
                frames.add(add);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f lerp(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f(InterpolationUtil.lerp(p0.x, p1.x, alpha), InterpolationUtil.lerp(p0.y, p1.y, alpha), InterpolationUtil.lerp(p0.z, p1.z, alpha));
    }

    public static float lerp(float p0, float p1, float alpha) {
        return MathUtil.fma(p1 - p0, alpha, p0);
    }

    public static float cubicBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float tt = t * t;
        float uuu = uu * u;
        float utt = u * tt;
        float uut = uu * t;
        float ttt = tt * t;
        return MathUtil.fma(uuu, p0, MathUtil.fma(3.0f * uut, p1, MathUtil.fma(3.0f * utt, p2, ttt * p3)));
    }

    public static float derivativeBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float ut = u * t;
        float tt = t * t;
        return MathUtil.fma(3.0f * uu, p1 - p0, MathUtil.fma(6.0f * ut, p2 - p1, 3.0f * tt * (p3 - p2)));
    }

    public static float solveBezierTForTime(float time, float t0, float h1, float h2, float t1) {
        float t = 0.5f;
        int maxIterations = 20;
        for (int i = 0; i < maxIterations; ++i) {
            float bezTime = InterpolationUtil.cubicBezier(t0, h1, h2, t1, t);
            float derivative = InterpolationUtil.derivativeBezier(t0, h1, h2, t1, t);
            float error = bezTime - time;
            if (Math.abs(error) < 1.0E-5f) {
                return t;
            }
            if (derivative != 0.0f) {
                t -= error / derivative;
            }
            t = Math.clamp(t, 0.0f, 1.0f);
        }
        return t;
    }

    @NotNull
    public static Vector3f bezier(float time, float startTime, float endTime, @NotNull Vector3f startValue, @NotNull Vector3f endValue, @Nullable Vector3f bezierLeftTime, @Nullable Vector3f bezierLeftValue, @Nullable Vector3f bezierRightTime, @Nullable Vector3f bezierRightValue) {
        Vector3f p1 = bezierRightValue != null ? bezierRightValue.add((Vector3fc)startValue, new Vector3f()) : startValue;
        Vector3f p2 = bezierLeftValue != null ? bezierLeftValue.add((Vector3fc)endValue, new Vector3f()) : endValue;
        return new Vector3f(InterpolationUtil.cubicBezier(startValue.x, p1.x, p2.x, endValue.x, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.x + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.x + endTime : endTime, endTime)), InterpolationUtil.cubicBezier(startValue.y, p1.y, p2.y, endValue.y, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.y + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.y + endTime : endTime, endTime)), InterpolationUtil.cubicBezier(startValue.z, p1.z, p2.z, endValue.z, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.z + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.z + endTime : endTime, endTime)));
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.x, MathUtil.fma(3.0f, p1.x, MathUtil.fma(-3.0f, p2.x, p3.x))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.x, MathUtil.fma(-5.0f, p1.x, MathUtil.fma(4.0f, p2.x, -p3.x))), MathUtil.fma(t, -p0.x + p2.x, 2.0f * p1.x))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.y, MathUtil.fma(3.0f, p1.y, MathUtil.fma(-3.0f, p2.y, p3.y))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.y, MathUtil.fma(-5.0f, p1.y, MathUtil.fma(4.0f, p2.y, -p3.y))), MathUtil.fma(t, -p0.y + p2.y, 2.0f * p1.y))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.z, MathUtil.fma(3.0f, p1.z, MathUtil.fma(-3.0f, p2.z, p3.z))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.z, MathUtil.fma(-5.0f, p1.z, MathUtil.fma(4.0f, p2.z, -p3.z))), MathUtil.fma(t, -p0.z + p2.z, 2.0f * p1.z)))).mul(0.5f);
    }
}

