/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.BytecodeCompiler;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record FunctionNode(String object, String function, Node[] arguments) implements Node
{
    @Override
    public String toString() {
        return this.object + "." + this.function + "(" + Arrays.stream(this.arguments).map(Node::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment environment, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        int objectIndex = environment.getObjectIndex(method, this.object);
        method.visitVarInsn(25, objectIndex);
        method.visitLdcInsn((Object)this.function);
        method.visitLdcInsn((Object)(this.function + "$" + this.arguments.length));
        method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "getFunction", "(Lgg/moonflower/molangcompiler/api/object/MolangObject;Ljava/lang/String;Ljava/lang/String;)Lgg/moonflower/molangcompiler/api/MolangExpression;", false);
        int expressionIndex = environment.allocateVariable(this.object + "." + this.function + "$" + this.arguments.length);
        method.visitVarInsn(58, expressionIndex);
        for (Node node : this.arguments) {
            boolean full;
            boolean bl = full = !environment.optimize() || !node.isConstant();
            if (full) {
                node.writeBytecode(method, environment, breakLabel, continueLabel);
            }
            method.visitVarInsn(25, 1);
            if (full) {
                method.visitInsn(95);
            } else {
                BytecodeCompiler.writeFloatConst(method, node.evaluate(environment));
            }
            method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/MolangEnvironment", "loadParameter", "(F)V", true);
        }
        method.visitVarInsn(25, expressionIndex);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/MolangExpression", "resolve", "(Lgg/moonflower/molangcompiler/api/MolangEnvironment;)F", true);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(185, "gg/moonflower/molangcompiler/api/MolangEnvironment", "clearParameters", "()V", true);
    }
}

