/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.core.ast;

import gg.moonflower.molangcompiler.api.exception.MolangException;
import gg.moonflower.molangcompiler.core.MolangUtil;
import gg.moonflower.molangcompiler.core.ast.MathOperation;
import gg.moonflower.molangcompiler.core.ast.Node;
import gg.moonflower.molangcompiler.core.compiler.BytecodeCompiler;
import gg.moonflower.molangcompiler.core.compiler.MolangBytecodeEnvironment;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.MethodNode;

@ApiStatus.Internal
public record MathNode(MathOperation function, Node[] arguments) implements Node
{
    private static final float RADIANS_TO_DEGREES = 57.29578f;
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;

    @Override
    public String toString() {
        if (this.function.getParameters() == 0) {
            return "math." + this.function.getName();
        }
        return "math." + this.function.getName() + "(" + Arrays.stream(this.arguments).map(Node::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public boolean isConstant() {
        if (!this.function.isDeterministic()) {
            return false;
        }
        for (Node parameter : this.arguments) {
            if (parameter.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public float evaluate(MolangBytecodeEnvironment environment) throws MolangException {
        float[] values2 = new float[this.arguments.length];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = this.arguments[i].evaluate(environment);
        }
        return switch (this.function) {
            case MathOperation.ABS -> Math.abs(values2[0]);
            case MathOperation.ACOS -> 57.29578f * (float)Math.acos(values2[0]);
            case MathOperation.ASIN -> 57.29578f * (float)Math.asin(values2[0]);
            case MathOperation.ATAN -> 57.29578f * (float)Math.atan(values2[0]);
            case MathOperation.ATAN2 -> 57.29578f * (float)Math.atan2(values2[0], values2[1]);
            case MathOperation.CEIL -> (float)Math.ceil(values2[0]);
            case MathOperation.CLAMP -> MolangUtil.clamp(values2[0], values2[1], values2[2]);
            case MathOperation.COS -> (float)Math.cos((float)Math.PI / 180 * values2[0]);
            case MathOperation.SIN -> (float)Math.sin((float)Math.PI / 180 * values2[0]);
            case MathOperation.EXP -> (float)Math.exp(values2[0]);
            case MathOperation.FLOOR -> (float)Math.floor(values2[0]);
            case MathOperation.HERMITE_BLEND -> MolangUtil.hermiteBlend(values2[0]);
            case MathOperation.LERP -> MolangUtil.lerp(values2[0], values2[1], values2[2]);
            case MathOperation.LERPROTATE -> MolangUtil.lerpRotate(values2[0], values2[1], values2[2]);
            case MathOperation.LN -> (float)Math.log(values2[0]);
            case MathOperation.MAX -> Math.max(values2[0], values2[1]);
            case MathOperation.MIN -> Math.min(values2[0], values2[1]);
            case MathOperation.MIN_ANGLE -> MolangUtil.wrapDegrees(values2[0]);
            case MathOperation.MOD -> values2[0] % values2[1];
            case MathOperation.PI -> (float)Math.PI;
            case MathOperation.POW -> (float)Math.pow(values2[0], values2[1]);
            case MathOperation.ROUND -> Math.round(values2[0]);
            case MathOperation.SQRT -> (float)Math.sqrt(values2[0]);
            case MathOperation.TRUNC -> (int)values2[0];
            case MathOperation.SIGN -> Math.signum(values2[0]);
            case MathOperation.TRIANGLE_WAVE -> MolangUtil.triangleWave(values2[0], values2[1]);
            default -> throw new MolangException("Unexpected value: " + this.function);
        };
    }

    @Override
    public void writeBytecode(MethodNode method, MolangBytecodeEnvironment env, @Nullable Label breakLabel, @Nullable Label continueLabel) throws MolangException {
        switch (this.function) {
            case ABS: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(F)F", false);
                break;
            }
            case MAX: 
            case MIN: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(FF)F", false);
                break;
            }
            case ACOS: 
            case ASIN: 
            case ATAN: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(D)D", false);
                method.visitInsn(144);
                BytecodeCompiler.writeFloatConst(method, 57.29578f);
                method.visitInsn(106);
                break;
            }
            case CEIL: 
            case EXP: 
            case FLOOR: 
            case LN: 
            case SQRT: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(D)D", false);
                method.visitInsn(144);
                break;
            }
            case COS: 
            case SIN: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                BytecodeCompiler.writeFloatConst(method, (float)Math.PI / 180);
                method.visitInsn(106);
                method.visitInsn(141);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(D)D", false);
                method.visitInsn(144);
                break;
            }
            case POW: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(DD)D", false);
                method.visitInsn(144);
                break;
            }
            case ATAN2: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(141);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(DD)D", false);
                method.visitInsn(144);
                BytecodeCompiler.writeFloatConst(method, 57.29578f);
                method.visitInsn(106);
                break;
            }
            case ROUND: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "java/lang/Math", this.function.getName(), "(F)I", false);
                method.visitInsn(134);
                break;
            }
            case MOD: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(114);
                break;
            }
            case PI: {
                BytecodeCompiler.writeFloatConst(method, (float)Math.PI);
                break;
            }
            case TRUNC: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                method.visitInsn(134);
                break;
            }
            case CLAMP: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[2].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "clamp", "(FFF)F", false);
                break;
            }
            case DIE_ROLL: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[2].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "dieRoll", "(IFF)F", false);
                break;
            }
            case DIE_ROLL_INTEGER: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                method.visitInsn(134);
                this.arguments[2].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                method.visitInsn(134);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "dieRoll", "(IFF)F", false);
                method.visitInsn(139);
                method.visitInsn(134);
                break;
            }
            case HERMITE_BLEND: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "hermiteBlend", "(F)F", false);
                break;
            }
            case LERP: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[2].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "lerp", "(FFF)F", false);
                break;
            }
            case LERPROTATE: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[2].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "lerpRotate", "(FFF)F", false);
                break;
            }
            case MIN_ANGLE: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "wrapDegrees", "(F)F", false);
                break;
            }
            case RANDOM: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "random", "(FF)F", false);
                break;
            }
            case RANDOM_INTEGER: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                method.visitInsn(134);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitInsn(139);
                method.visitInsn(134);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "random", "(FF)F", false);
                method.visitInsn(139);
                method.visitInsn(134);
                break;
            }
            case SIGN: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "java/lang/Math", "signum", "(F)F", false);
                break;
            }
            case TRIANGLE_WAVE: {
                this.arguments[0].writeBytecode(method, env, breakLabel, continueLabel);
                this.arguments[1].writeBytecode(method, env, breakLabel, continueLabel);
                method.visitMethodInsn(184, "gg/moonflower/molangcompiler/core/MolangUtil", "triangleWave", "(FF)F", false);
            }
        }
    }
}

