/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import com.vdurmont.semver4j.Semver;
import java.io.InputStream;
import java.util.function.Consumer;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelEvaluator;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.manager.CommandManager;
import kr.toxicity.model.api.manager.CompatibilityManager;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.manager.SkinManager;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.pack.PackResult;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.scheduler.ModelScheduler;
import kr.toxicity.model.api.version.MinecraftVersion;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterModelPlugin
extends Plugin {
    @NotNull
    default public ReloadResult reload() {
        return this.reload(ReloadInfo.DEFAULT);
    }

    @NotNull
    default public ReloadResult reload(@NotNull CommandSender sender) {
        return this.reload(ReloadInfo.builder().sender(sender).build());
    }

    @NotNull
    public ReloadResult reload(@NotNull ReloadInfo var1);

    public boolean isSnapshot();

    @NotNull
    public BetterModelConfig config();

    @NotNull
    public MinecraftVersion version();

    @NotNull
    public Semver semver();

    @NotNull
    public NMS nms();

    @NotNull
    public ModelManager modelManager();

    @NotNull
    public PlayerManager playerManager();

    @NotNull
    public EntityManager entityManager();

    @NotNull
    public CommandManager commandManager();

    @NotNull
    public ScriptManager scriptManager();

    @NotNull
    public CompatibilityManager compatibilityManager();

    @NotNull
    public SkinManager skinManager();

    @NotNull
    public ModelScheduler scheduler();

    public void addReloadStartHandler(@NotNull Consumer<PackZipper> var1);

    public void addReloadEndHandler(@NotNull Consumer<ReloadResult> var1);

    @NotNull
    public BetterModelLogger logger();

    @NotNull
    public BetterModelEvaluator evaluator();

    @NotNull
    public BukkitAudiences audiences();

    @Nullable
    public InputStream getResource(@NotNull String var1);

    public static sealed interface ReloadResult {

        public record Failure(@NotNull Throwable throwable) implements ReloadResult
        {
        }

        public static enum OnReload implements ReloadResult
        {
            INSTANCE;

        }

        public record Success(long assetsTime, @NotNull PackResult packResult) implements ReloadResult
        {
            public long packingTime() {
                return this.packResult().time();
            }

            public long totalTime() {
                return this.assetsTime + this.packingTime();
            }
        }
    }
}

