/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.util.PackUtil;
import kr.toxicity.model.api.util.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

public record BlueprintTexture(@NotNull String name, BufferedImage image, int uvWidth, int uvHeight) {
    public boolean isAnimatedTexture() {
        if (this.uvWidth > 0 && this.uvHeight > 0) {
            float w;
            float h = (float)this.image.getHeight() / (float)this.uvHeight;
            return h > (w = (float)this.image.getWidth() / (float)this.uvWidth);
        }
        return this.image.getHeight() / this.image.getWidth() > 1;
    }

    @NotNull
    public JsonObject toMcmeta() {
        return JsonObjectBuilder.builder().jsonObject("animation", animation -> {
            animation.property("interpolate", true);
            animation.property("frametime", BetterModel.config().animatedTextureFrameTime());
        }).build();
    }

    @NotNull
    public String packName(@NotNull String parentName) {
        return BetterModel.config().namespace() + ":item/" + PackUtil.toPackName(parentName + "_" + this.name());
    }

    @NotNull
    public ModelResolution resolution() {
        return new ModelResolution(this.uvWidth, this.uvHeight);
    }
}

